/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.file.util;

import com.peak.common.util.CommonUtil;
import com.peak.common.util.DownloadFileUtil;
import com.peak.common.util.SpringUtil;
import com.peak.prd.base.service.IOssService;
import com.peak.prd.exam.common.model.ExamFiles;
import com.peak.prd.exam.common.service.IExamFilesPlusService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuesFileUtil {
    private static final Logger log = LoggerFactory.getLogger(QuesFileUtil.class);

    public static void getFile(Long fileId, String fileGkey, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (fileId == null || fileGkey == null) {
            log.error("quesfile not found[" + fileId + ", " + fileGkey + "]");
            return;
        }
        ExamFiles examFiles = (ExamFiles)((IExamFilesPlusService)SpringUtil.getBean(IExamFilesPlusService.class)).getById(fileId);
        if (examFiles == null || !fileGkey.equalsIgnoreCase(examFiles.getGkey())) {
            log.error("quesfile not found[" + fileId + ", " + fileGkey + "]");
            return;
        }
        String key = CommonUtil.formatByEndSlash((String)examFiles.getFilepath()) + examFiles.getFilename();
        if (log.isDebugEnabled()) {
            log.debug("downloadKey:" + key);
        }
        DownloadFileUtil.downloadResourceFile((String)key, (String)examFiles.getSrcfilename(), (HttpServletResponse)response);
    }

    public static String getFileOssPath(Long fileId, String fileGkey) throws Exception {
        if (fileId == null || fileGkey == null) {
            log.error("quesfile not found[" + fileId + ", " + fileGkey + "]");
            return null;
        }
        ExamFiles examFiles = (ExamFiles)((IExamFilesPlusService)SpringUtil.getBean(IExamFilesPlusService.class)).getById(fileId);
        if (examFiles == null || !fileGkey.equalsIgnoreCase(examFiles.getGkey())) {
            log.error("quesfile not found[" + fileId + ", " + fileGkey + "]");
            return null;
        }
        String key = CommonUtil.formatByEndSlash((String)examFiles.getFilepath()) + examFiles.getFilename();
        if (log.isDebugEnabled()) {
            log.debug("ossKey:" + key);
        }
        IOssService ossService = (IOssService)SpringUtil.getBean((String)"ossService");
        String url = ossService.getUrl(key);
        if (log.isDebugEnabled()) {
            log.debug("ossUrl:{}", (Object)url);
        }
        return url;
    }
}

