/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.migrate.service.imple;

import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.framework.common.page.IQuery;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.exam.examreply.model.ExamReply;
import com.peak.prd.exam.examreply.service.IExamReplyPlusService;
import com.peak.prd.exam.examreply.vo.ExamReplyQuery;
import com.peak.prd.exam.examresult.model.ExamResult;
import com.peak.prd.exam.examresult.service.IExamResultPlusService;
import com.peak.prd.exam.examresult.vo.ExamResultQuery;
import com.peak.prd.exam.migrate.service.IExamMigrateService;
import com.peak.prd.service.IExamDataSourceConfig;
import java.text.SimpleDateFormat;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExamMigrateService
extends PrdBaseService
implements IExamMigrateService {
    private static final Logger log = LoggerFactory.getLogger(ExamMigrateService.class);
    @Autowired
    private IExamDataSourceConfig examDataSourceConfig;
    @Autowired
    private IExamResultPlusService examResultPlusService;
    @Autowired
    private IExamReplyPlusService examReplyPlusService;

    public IEntityDao getEntityDao() {
        return null;
    }

    private IExamResultPlusService getExamResultPlusService_mng() {
        return this.examResultPlusService;
    }

    private IExamReplyPlusService getExamReplyPlusService_mng() {
        return this.examReplyPlusService;
    }

    @Override
    public void migrateExamResultFromStuToMng(Long resultId, boolean includeReplies) {
        ExamResult fromModel = null;
        ExamResult toModel = null;
        try {
            fromModel = (ExamResult)this.examDataSourceConfig.getExamResultPlusService_stu().getById(resultId);
            toModel = (ExamResult)this.getExamResultPlusService_mng().getById(resultId);
            if (fromModel == null || fromModel.getArrangeId() == null || fromModel.getStudentId() == null) {
                return;
            }
            if (toModel == null) {
                if (fromModel.getUsersubmit() == null || fromModel.getUsersubmit() == 0L) {
                    ExamResultQuery examResultQuery = new ExamResultQuery();
                    examResultQuery.setArrangeId(fromModel.getArrangeId());
                    examResultQuery.setStudentId(fromModel.getStudentId());
                    examResultQuery.setUsersubmit(0L);
                    ExamResult tmpModel = (ExamResult)this.getExamResultPlusService_mng().getPrdEntityDao().findOne((IQuery)examResultQuery);
                    if (tmpModel != null) {
                        log.warn(this.getLog(fromModel, tmpModel, "warn"));
                        return;
                    }
                }
                this.getExamResultPlusService_mng().insert((BaseEntity)fromModel);
            } else {
                fromModel.setArrangeId(null);
                fromModel.setStudentId(null);
                fromModel.setPaperId(null);
                fromModel.setExamcount(null);
                fromModel.setSelectstatus(null);
                this.getExamResultPlusService_mng().updateSelective(fromModel);
            }
            if (includeReplies) {
                ExamReplyQuery examReplyQuery = new ExamReplyQuery();
                examReplyQuery.setResultId(fromModel.getResultId());
                List replies = this.examDataSourceConfig.getExamReplyPlusService_stu().findAll(examReplyQuery);
                for (int i = 0; replies != null && i < replies.size(); ++i) {
                    this.migrateExamReplyFromStuToMng((ExamReply)replies.get(i));
                }
            }
        }
        catch (Exception ex) {
            log.error(this.getLog(fromModel, toModel, "error"), (Throwable)ex);
            throw ex;
        }
    }

    private String getLog(ExamResult fromModel, ExamResult toModel, String title) {
        StringBuilder sb = new StringBuilder("===migrateExamResultFromStuToMng===").append(title);
        ExamResult[] results = new ExamResult[]{fromModel, toModel};
        for (int i = 0; i < 2; ++i) {
            ExamResult model = results[i];
            sb.append(i == 0 ? "\n   from: " : "\n   to: ");
            if (model == null) {
                sb.append("empty");
                continue;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            sb.append("[resultId:").append(model.getResultId()).append(", arrangeId:").append(model.getArrangeId()).append(", userId:").append(model.getStudentId()).append(", stusubmit:").append(model.getStusubmit()).append(", usersubmit:").append(model.getUsersubmit()).append(", examcount:").append(model.getExamcount()).append(", selectstatus:").append(model.getSelectstatus()).append(", enterdate:").append(model.getEnterdate() == null ? null : sdf.format(model.getEnterdate())).append(", submitdate:").append(model.getSubmitdate() == null ? null : sdf.format(model.getSubmitdate())).append("]");
        }
        return sb.toString();
    }

    private void migrateExamReplyFromStuToMng(ExamReply fromModel) {
        if (fromModel == null) {
            return;
        }
        ExamReply toModel = (ExamReply)this.getExamReplyPlusService_mng().getById(fromModel.getReplyId());
        if (toModel == null) {
            this.getExamReplyPlusService_mng().insert((BaseEntity)fromModel);
        } else {
            this.getExamReplyPlusService_mng().updateSelective(fromModel);
        }
    }

    @Override
    public void updateFinalMarkFromStuToMng(Long arrangeId, Long userId, Double dFinalMark, Long resultIdOfSelect) {
        this.getExamResultPlusService_mng().updateFinalMark(arrangeId, userId, dFinalMark, resultIdOfSelect);
    }
}

