/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.util;

import com.peak.common.util.RedisService;
import com.peak.common.util.SpringUtil;
import com.peak.prd.config.PrdExamConfig;
import com.peak.prd.exam.examarrange.model.ExamArrange;
import com.peak.prd.exam.examarrange.service.IExamArrangePlusService;
import com.peak.prd.exam.examquestiontype.model.ExamQuestiontype;
import com.peak.prd.exam.examquestiontype.service.IExamQuestiontypePlusService;
import com.peak.prd.exam.util.PrdExamUtil;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrdExamCacheUtil {
    private static final Logger log = LoggerFactory.getLogger(PrdExamCacheUtil.class);
    private static Map<String, Object[]> mapCache = new ConcurrentHashMap<String, Object[]>();
    private static ExecutorService reloadThreadExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(0x7FFFFFFE));
    private static final int TIMEOUT_NO = 0;
    private static final int TIMEOUT_SHORT = 1;
    private static final int TIMEOUT_LONG = 2;
    private static int cacheSeconds;
    private static Map<Long, Long> examCacheCheckDate;

    public static void clearAll() {
        mapCache.clear();
        log.info("PrdExamCacheUtil.clearAll");
    }

    public static void clearByKey(String key) {
        if (key == null || key.isEmpty()) {
            return;
        }
        mapCache.remove(key);
    }

    private static void clearExpired() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                log.info("PrdExamCacheUtil.clearExpired thread started...");
                for (int z = 0; z < Integer.MAX_VALUE; ++z) {
                    try {
                        Thread.sleep(300000L);
                        for (Map.Entry mapEntry : mapCache.entrySet()) {
                            String mapKey = (String)mapEntry.getKey();
                            Object[] mapVal = (Object[])mapEntry.getValue();
                            int isExpired = PrdExamCacheUtil.getExpired((Long)mapVal[0]);
                            if (!PrdExamCacheUtil.isLongExpired(isExpired)) continue;
                            mapCache.remove(mapKey);
                            if (!log.isDebugEnabled()) continue;
                            log.debug("examplus.clearExpired " + mapKey);
                        }
                    }
                    catch (InterruptedException e) {
                        log.error("-clearExpired error-", (Throwable)e);
                    }
                    Calendar calendar = Calendar.getInstance();
                    if (calendar.get(11) != 3) continue;
                    examCacheCheckDate.clear();
                }
            }
        });
        t.setDaemon(true);
        t.start();
    }

    public static <T> T getCachedExamObject(Long examId, Function<Object[], T> fetchFunc, String cachedBusinessType, Object ... allParams) {
        return PrdExamCacheUtil._getCachedObject(examId, fetchFunc, cachedBusinessType, true, allParams);
    }

    public static <T> T getCachedOtherObject(Long businessObjectId, Function<Object[], T> fetchFunc, String cachedBusinessType, Object ... allParams) {
        return PrdExamCacheUtil._getCachedObject(businessObjectId, fetchFunc, cachedBusinessType, false, allParams);
    }

    private static <T> T _getCachedObject(Long businessObjectId, Function<Object[], T> fetchFunc, String cachedBusinessType, boolean isExamBiz, Object ... allParams) {
        int expired;
        String mapKey = cachedBusinessType + businessObjectId;
        Object[] mapVal = mapCache.get(mapKey);
        if (mapVal != null && !PrdExamCacheUtil.isLongExpired(expired = PrdExamCacheUtil.getExpired((Long)mapVal[0], isExamBiz ? businessObjectId : null))) {
            if (PrdExamCacheUtil.isShortExpired(expired)) {
                if (log.isDebugEnabled()) {
                    log.debug("Async call reloadBusinessObject, cacheKey: {}", (Object)mapKey);
                }
                reloadThreadExecutor.execute(() -> PrdExamCacheUtil.reloadBusinessObject(businessObjectId, fetchFunc, cachedBusinessType, isExamBiz, allParams));
            }
            if (log.isDebugEnabled()) {
                log.debug("Cache\u547d\u4e2d, cacheKey: {}", (Object)mapKey);
            }
            return (T)mapVal[1];
        }
        return PrdExamCacheUtil.reloadBusinessObject(businessObjectId, fetchFunc, cachedBusinessType, isExamBiz, allParams);
    }

    private static synchronized <T> T reloadBusinessObject(Long businessObjectId, Function<Object[], T> fetchFunc, String cachedBusinessType, boolean isExamBiz, Object ... allParams) {
        Object[] objectArray;
        String mapKey = cachedBusinessType + businessObjectId;
        Object tmpObj = PrdExamCacheUtil.getCachedValue(mapKey, isExamBiz ? businessObjectId : null);
        if (tmpObj != null) {
            return (T)tmpObj;
        }
        if (allParams == null || allParams.length == 0) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = businessObjectId;
        } else {
            objectArray = allParams;
        }
        T examObject = fetchFunc.apply(objectArray);
        Object[] ary = new Object[]{System.currentTimeMillis(), examObject};
        mapCache.put(mapKey, ary);
        if (log.isDebugEnabled()) {
            log.debug("reloadBusinessObject into cache, cacheKey: {}", (Object)mapKey);
        }
        return examObject;
    }

    public static ExamArrange getExamArrange(Long examId) {
        Function<Object[], ExamArrange> func = params -> {
            IExamArrangePlusService examArrangePlusService = (IExamArrangePlusService)SpringUtil.getBean((String)"examArrangePlusService");
            return (ExamArrange)examArrangePlusService.getById((Long)params[0]);
        };
        return PrdExamCacheUtil.getCachedExamObject(examId, func, ExamArrange.class.getSimpleName(), new Object[0]);
    }

    public static String getExamQuestionTypename(Long typeId) {
        if (typeId == null) {
            return "unknown";
        }
        Function<Object[], String> func = params -> {
            IExamQuestiontypePlusService examQuestiontypePlusService = (IExamQuestiontypePlusService)SpringUtil.getBean(IExamQuestiontypePlusService.class);
            ExamQuestiontype type = (ExamQuestiontype)examQuestiontypePlusService.getById((Long)params[0]);
            return type == null ? null : type.getTypename();
        };
        return PrdExamCacheUtil.getCachedOtherObject(typeId, func, "examQuestionTypename", new Object[0]);
    }

    public static int getExpired(Long cacheCreateTime, Long examId) {
        int expired = PrdExamCacheUtil.getExpired(cacheCreateTime);
        if (expired == 2) {
            return 2;
        }
        if (cacheCreateTime != null && examId != null) {
            if (cacheCreateTime + 10000L > System.currentTimeMillis()) {
                if (log.isDebugEnabled()) {
                    log.debug("10\u79d2\u4ee5\u5185\u7684cache\u6570\u636e\uff0c\u975e\u5e38\u65b0\u9c9c[examId:" + examId + "][expired:" + expired + "]");
                }
                return expired;
            }
            Long checkDate = examCacheCheckDate.get(examId);
            if (checkDate != null && checkDate + 10000L > System.currentTimeMillis()) {
                if (log.isDebugEnabled()) {
                    log.debug("10\u79d2\u4ee5\u5185\uff0c\u68c0\u67e5\u8fc7cache\u6709\u6548\u6027[examId:" + examId + "][expired:" + expired + "]");
                }
                return expired;
            }
            RedisService redisService = (RedisService)SpringUtil.getBean(RedisService.class);
            String examModifyDate = redisService.get("exam:cacheInvalid:exam" + examId);
            if (examModifyDate == null || examModifyDate.isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug("\u8fd1\u671f\u6ca1\u6709\u8003\u8bd5\u4fee\u6539\u64cd\u4f5c[examId:" + examId + "][expired:" + expired + "]");
                }
                examCacheCheckDate.put(examId, System.currentTimeMillis());
                return expired;
            }
            long nExamModifyDate = Long.parseLong(examModifyDate);
            if (cacheCreateTime > nExamModifyDate) {
                if (log.isDebugEnabled()) {
                    log.debug("cache\u5728\u8003\u8bd5\u4fee\u6539\u64cd\u4f5c\u4e4b\u540e[examId:" + examId + "][expired:" + expired + "]");
                }
                examCacheCheckDate.put(examId, System.currentTimeMillis());
                return expired;
            }
            if (log.isDebugEnabled()) {
                log.debug("\u8003\u8bd5\u4fee\u6539\u5f15\u8d77cache\u5931\u6548[examId:" + examId + "][expired:" + expired + "]");
            }
            return 2;
        }
        return expired;
    }

    public static int getExpired(Long cacheCreateTime) {
        boolean b2;
        boolean b1;
        if (cacheSeconds < 0) {
            PrdExamConfig examConfig = (PrdExamConfig)SpringUtil.getBean(PrdExamConfig.class);
            cacheSeconds = examConfig.getCacheSeconds();
            log.info("===cacheSeconds===" + cacheSeconds);
        }
        if (cacheSeconds <= 0) {
            log.warn("cacheEnable false!!!");
            return 2;
        }
        if (PrdExamUtil.isLoadrunner()) {
            return 0;
        }
        boolean bl = b1 = cacheCreateTime + 1000L * (long)cacheSeconds > System.currentTimeMillis();
        if (b1) {
            return 0;
        }
        boolean bl2 = b2 = cacheCreateTime + 1000L * (long)(cacheSeconds + 30) > System.currentTimeMillis();
        if (b2) {
            return 1;
        }
        return 2;
    }

    public static boolean isLongExpired(int expired) {
        return expired == 2;
    }

    public static boolean isShortExpired(int expired) {
        return expired == 1;
    }

    public static Object getCachedValue(String mapKey, Long examId) {
        Object[] mapVal = mapCache.get(mapKey);
        if (mapVal == null) {
            return null;
        }
        int expired = PrdExamCacheUtil.getExpired((Long)mapVal[0], examId);
        return expired > 0 ? null : mapVal[1];
    }

    static {
        PrdExamCacheUtil.clearExpired();
        cacheSeconds = -1;
        examCacheCheckDate = new ConcurrentHashMap<Long, Long>();
    }
}

