/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class ExamApiSignUtil {
    private static String SALT_DEFAULT = "s%ad2f@5#";

    public static String getApiHash(Object data, long ts) {
        return ExamApiSignUtil.getApiHash(data, ts, SALT_DEFAULT);
    }

    public static long getTs() {
        return System.currentTimeMillis();
    }

    public static boolean validate(String data, Long ts, String sign) {
        if (ts == null || data == null) {
            return false;
        }
        if (Math.abs(ts - System.currentTimeMillis()) > 60000L) {
            return false;
        }
        String hash = ExamApiSignUtil.getApiHash(data, ts);
        if (hash == null) {
            return false;
        }
        return hash.equalsIgnoreCase(sign);
    }

    public static String getApiHash(Object data, long ts, String salt) {
        String str = data + "" + ts + salt;
        return ExamApiSignUtil.getSha256Str(str);
    }

    public static String getSha256Str(String str) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(str.getBytes("UTF-8"));
            return ExamApiSignUtil.byte2Hex(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    private static String byte2Hex(byte[] bytes) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte aByte : bytes) {
            String temp = Integer.toHexString(aByte & 0xFF);
            if (temp.length() == 1) {
                stringBuilder.append("0");
            }
            stringBuilder.append(temp);
        }
        return stringBuilder.toString();
    }
}

