/*
 * Decompiled with CFR 0.152.
 */
package com.peak.common.util;

import com.peak.prd.common.appdict.vo.AppdictVO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class DictUtil {
    private static final String DICT_PATH = "config/dict/dict.properties";
    private static Map<String, LinkedHashMap<String, String>> allMap = new HashMap<String, LinkedHashMap<String, String>>();

    private static void reloadProperties() {
        try {
            Properties properties = PropertiesLoaderUtils.loadAllProperties((String)DICT_PATH);
            if (properties != null) {
                HashMap map = new HashMap();
                Enumeration<Object> keys = properties.keys();
                while (keys.hasMoreElements()) {
                    String dictcode = (String)keys.nextElement();
                    String dictline = properties.getProperty(dictcode);
                    if (dictcode == null || dictline == null || dictcode.isEmpty() || dictline.isEmpty()) continue;
                    String[] array = dictline.split(";");
                    LinkedHashMap<String, String> sortValueNameMap = new LinkedHashMap<String, String>();
                    for (int i = 0; i < array.length; ++i) {
                        String[] pair;
                        if (array[i].isEmpty() || (pair = array[i].split(":")).length < 2) continue;
                        sortValueNameMap.put(pair[0], pair[1]);
                    }
                    allMap.put(dictcode, sortValueNameMap);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Map<String, String> getDict(String dictCode) {
        return allMap.get(dictCode);
    }

    public static String getDictName(String dictCode, String value) {
        Map map = allMap.get(dictCode);
        if (map != null) {
            return (String)map.get(value);
        }
        return null;
    }

    public static List<AppdictVO> getStaticDict(String dictCode) {
        Map dictmap = allMap.get(dictCode);
        if (dictmap == null) {
            return new ArrayList<AppdictVO>();
        }
        ArrayList<AppdictVO> dictList = new ArrayList<AppdictVO>();
        dictmap.entrySet().forEach(dict -> {
            AppdictVO appdictVO = new AppdictVO();
            appdictVO.setVal(Long.parseLong((String)dict.getKey()));
            appdictVO.setName((String)dict.getValue());
            dictList.add(appdictVO);
        });
        return dictList;
    }

    public static Map<String, List<AppdictVO>> getMultiStaticDict(List<String> dictCodes) {
        HashMap<String, List<AppdictVO>> dictMap = new HashMap<String, List<AppdictVO>>();
        dictCodes.forEach(dictCode -> {
            List<AppdictVO> dictVOList = DictUtil.getStaticDict(dictCode);
            dictMap.put((String)dictCode, dictVOList);
        });
        return dictMap;
    }

    static {
        DictUtil.reloadProperties();
    }
}

