/*
 * Decompiled with CFR 0.152.
 */
package com.peak.common.util;

import com.peak.common.sign.SignVO;
import com.peak.common.util.ListUtil;
import com.peak.common.util.StringUtil;
import com.peak.prd.common.appconfig.util.AppconfigUtil;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.util.DigestUtils;

public class SignUtil {
    public static String generateSign(Long userId, Long timestamp) {
        if (userId == null || timestamp == null) {
            return "";
        }
        String salt = AppconfigUtil.getValueByConfigkey("Key_SignSalt");
        String signStr = String.valueOf(timestamp) + String.valueOf(userId) + salt;
        String sign = DigestUtils.md5DigestAsHex((byte[])signStr.getBytes(StandardCharsets.UTF_8));
        return sign;
    }

    public static boolean validSign(Long userId, Long timestamp, String sign) {
        String validSign = SignUtil.generateSign(userId, timestamp);
        return !StringUtil.isNullorEmptyStr((String)validSign) && validSign.equals(sign);
    }

    public static void fillSignVO(Long userId, SignVO signVO) {
        Long timestamp = System.currentTimeMillis();
        signVO.setTimestamp(timestamp);
        signVO.setSign(SignUtil.generateSign(userId, timestamp));
    }

    public static void fillSignVOList(Long userId, List<? extends SignVO> signVOList) {
        if (ListUtil.isNullorEmpty(signVOList)) {
            return;
        }
        signVOList.forEach(signVO -> SignUtil.fillSignVO(userId, signVO));
    }

    public static boolean validFileDownloadSign(Long userId, Long timestamp, String sign) {
        if (!SignUtil.validSign(userId, timestamp, sign)) {
            return false;
        }
        String validSecondsStr = AppconfigUtil.getValueByConfigkey("Key_FileDownloadUrlValidSeconds");
        if (StringUtil.isNullorEmptyStr((String)validSecondsStr)) {
            validSecondsStr = "7200";
        }
        Date expiresTime = DateUtils.addSeconds((Date)new Date(timestamp), (int)Integer.valueOf(validSecondsStr));
        Date currentTime = new Date();
        return currentTime.before(expiresTime);
    }
}

