/*
 * Decompiled with CFR 0.152.
 */
package com.peak.common.util;

import com.peak.common.util.AppPathUtil;
import com.peak.common.util.Base64Util;
import com.peak.common.util.FileUtil;
import com.peak.common.util.SecurityUtil;
import com.peak.common.util.SpringUtil;
import com.peak.prd.base.model.IRespStatusEnum;
import com.peak.prd.base.model.ResponseStatusEnum;
import com.peak.prd.base.model.UploadFile;
import com.peak.prd.base.service.IOssService;
import com.peak.prd.base.util.ExceptionUtil;
import com.peak.prd.config.AppCommonConfig;
import com.peak.prd.enums.FileTypeEnum;
import com.peak.prd.lms.common.model.Files;
import com.peak.prd.lms.common.service.IFilesPlusService;
import com.peak.prd.lms.common.service.imple.FilesPlusService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.UUID;
import org.springframework.web.multipart.MultipartFile;

public class UploadFileDBUtil {
    public static UploadFile upload(MultipartFile file, String saveRelativePath, FileTypeEnum fileTypeEnum) throws Exception {
        return UploadFileDBUtil.upload(file, null, saveRelativePath, fileTypeEnum);
    }

    public static UploadFile upload(MultipartFile file, Long srcobjectId, String saveRelativePath, FileTypeEnum fileTypeEnum) throws Exception {
        return UploadFileDBUtil.upload(file, srcobjectId, saveRelativePath, fileTypeEnum, (Boolean)true);
    }

    public static UploadFile upload(MultipartFile file, String saveRelativePath, FileTypeEnum fileTypeEnum, Boolean uploadOss) throws Exception {
        return UploadFileDBUtil.upload(file, null, saveRelativePath, fileTypeEnum, uploadOss);
    }

    public static UploadFile upload(MultipartFile file, Long srcobjectId, String saveRelativePath, FileTypeEnum fileTypeEnum, Boolean uploadOss) throws Exception {
        return UploadFileDBUtil.uploadFile(file, srcobjectId, saveRelativePath, fileTypeEnum, null, uploadOss);
    }

    public static UploadFile upload(MultipartFile file, Long srcobjectId, String saveRelativePath, FileTypeEnum fileTypeEnum, Integer subtype) throws Exception {
        return UploadFileDBUtil.uploadFile(file, srcobjectId, saveRelativePath, fileTypeEnum, subtype, true);
    }

    public static UploadFile upload(MultipartFile file, Long srcobjectId, String saveRelativePath, FileTypeEnum fileTypeEnum, Integer subtype, Boolean uploadOss) throws Exception {
        return UploadFileDBUtil.uploadFile(file, srcobjectId, saveRelativePath, fileTypeEnum, subtype, uploadOss);
    }

    private static UploadFile uploadFile(MultipartFile file, Long srcobjectId, String saveRelativePath, FileTypeEnum fileTypeEnum, Integer subtype, Boolean uploadOss) throws Exception {
        if (file == null || saveRelativePath == null || fileTypeEnum == null) {
            return null;
        }
        if (saveRelativePath.lastIndexOf("/") != saveRelativePath.length() - 1) {
            saveRelativePath = saveRelativePath + "/";
        }
        String originfilename = file.getOriginalFilename();
        String fileExtention = FileUtil.getFileExtention((String)originfilename).toLowerCase();
        UploadFileDBUtil.checkPermission(originfilename, file.getSize());
        String fullpath = FileUtil.getSaveFullpath((String)saveRelativePath);
        String savefilename = FileUtil.getUUIDFilename() + fileExtention;
        String destPath = AppPathUtil.getResourceLocalPath() + fullpath;
        File destFilePath = new File(destPath);
        if (!destFilePath.exists()) {
            destFilePath.mkdirs();
        }
        File destFile = new File(destPath + savefilename);
        file.transferTo(destFile);
        IFilesPlusService filesPlusService = (IFilesPlusService)SpringUtil.getBean(FilesPlusService.class);
        Files files = null;
        files = srcobjectId == null ? filesPlusService.insert(savefilename, originfilename, fileExtention, fullpath, file.getSize(), fileTypeEnum.getIndex()) : (subtype == null ? filesPlusService.insert(savefilename, originfilename, fileExtention, fullpath, file.getSize(), fileTypeEnum.getIndex(), srcobjectId) : filesPlusService.insert(savefilename, originfilename, fileExtention, fullpath, file.getSize(), fileTypeEnum.getIndex(), srcobjectId, subtype));
        if (uploadOss.booleanValue()) {
            UploadFileDBUtil.handleOss(fullpath + savefilename);
        }
        return UploadFileDBUtil.getUploadFile(files.getFileId(), originfilename, savefilename, fileExtention, fullpath + savefilename);
    }

    public static UploadFile upload(String base64codefile, String saveRelativePath, FileTypeEnum fileTypeEnum) throws Exception {
        if (base64codefile == null || saveRelativePath == null) {
            return null;
        }
        String filename = UUID.randomUUID().toString() + "." + base64codefile.substring(base64codefile.indexOf("/") + 1, base64codefile.indexOf(";"));
        return UploadFileDBUtil.upload(base64codefile, filename, saveRelativePath, fileTypeEnum);
    }

    public static UploadFile upload(String base64codefile, String filename, String saveRelativePath, FileTypeEnum fileTypeEnum) throws Exception {
        return UploadFileDBUtil.uploadBase64(base64codefile, filename, saveRelativePath, fileTypeEnum, true);
    }

    public static UploadFile upload(String base64codefile, String saveRelativePath, FileTypeEnum fileTypeEnum, Boolean uploadOss) throws Exception {
        if (base64codefile == null || saveRelativePath == null) {
            return null;
        }
        String filename = UUID.randomUUID().toString() + "." + base64codefile.substring(base64codefile.indexOf("/") + 1, base64codefile.indexOf(";"));
        return UploadFileDBUtil.upload(base64codefile, filename, saveRelativePath, fileTypeEnum, uploadOss);
    }

    public static UploadFile upload(String base64codefile, String filename, String saveRelativePath, FileTypeEnum fileTypeEnum, Boolean uploadOss) throws Exception {
        return UploadFileDBUtil.uploadBase64(base64codefile, filename, saveRelativePath, fileTypeEnum, uploadOss);
    }

    private static UploadFile uploadBase64(String base64codefile, String filename, String saveRelativePath, FileTypeEnum fileTypeEnum, Boolean uploadOss) throws Exception {
        if (base64codefile == null || filename == null || saveRelativePath == null) {
            return null;
        }
        if (saveRelativePath.lastIndexOf("/") != saveRelativePath.length() - 1) {
            saveRelativePath = saveRelativePath + "/";
        }
        String fileExtention = FileUtil.getFileExtention((String)filename).toLowerCase();
        if (!SecurityUtil.isAllowImgext((String)filename)) {
            ExceptionUtil.handle((IRespStatusEnum)ResponseStatusEnum.FILE_IMG_DOWNLOAD_FAILD);
        } else if (!Base64Util.base64IsImage((String)base64codefile)) {
            ExceptionUtil.handle((IRespStatusEnum)ResponseStatusEnum.FILE_IMG_DOWNLOAD_FAILD);
        }
        String fullpath = FileUtil.getSaveFullpath((String)saveRelativePath);
        String savefilename = FileUtil.getUUIDFilename() + fileExtention;
        String destPath = AppPathUtil.getResourceLocalPath() + fullpath;
        File destFilePath = new File(destPath);
        if (!destFilePath.exists()) {
            destFilePath.mkdirs();
        }
        if (base64codefile.indexOf(",") > -1) {
            base64codefile = base64codefile.substring(base64codefile.indexOf(",") + 1);
        }
        byte[] filebytes = Base64Util.decode((String)base64codefile);
        long imagesize = filebytes.length;
        UploadFileDBUtil.checkPermission(filename, imagesize);
        for (int i = 0; i < filebytes.length; ++i) {
            if (filebytes[i] >= 0) continue;
            int n = i;
            filebytes[n] = (byte)(filebytes[n] + 256);
        }
        FileOutputStream out = new FileOutputStream(destPath + "/" + savefilename);
        ((OutputStream)out).write(filebytes);
        out.flush();
        ((OutputStream)out).close();
        IFilesPlusService filesPlusService = (IFilesPlusService)SpringUtil.getBean(FilesPlusService.class);
        Files files = filesPlusService.insert(savefilename, filename, fileExtention, fullpath, Long.valueOf(filebytes.length), fileTypeEnum.getIndex());
        if (uploadOss.booleanValue()) {
            UploadFileDBUtil.handleOss(fullpath + savefilename);
        }
        return UploadFileDBUtil.getUploadFile(files.getFileId(), filename, savefilename, fileExtention, fullpath + savefilename);
    }

    public static UploadFile upload(File srcfile, String saveRelativePath, FileTypeEnum fileTypeEnum, Boolean uploadOss) throws Exception {
        if (srcfile == null || saveRelativePath == null || fileTypeEnum == null) {
            return null;
        }
        if (saveRelativePath.lastIndexOf("/") != saveRelativePath.length() - 1) {
            saveRelativePath = saveRelativePath + "/";
        }
        String originfilename = srcfile.getName();
        String fileExtention = FileUtil.getFileExtention((String)originfilename).toLowerCase();
        UploadFileDBUtil.checkPermission(originfilename, srcfile.length());
        String fullpath = FileUtil.getSaveFullpath((String)saveRelativePath);
        String savefilename = FileUtil.getUUIDFilename() + fileExtention;
        String destPath = AppPathUtil.getResourceLocalPath() + fullpath;
        File destFilePath = new File(destPath);
        if (!destFilePath.exists()) {
            destFilePath.mkdirs();
        }
        File destFile = new File(destPath + savefilename);
        FileUtil.copyFile((File)srcfile, (File)destFile);
        IFilesPlusService filesPlusService = (IFilesPlusService)SpringUtil.getBean(FilesPlusService.class);
        Files files = null;
        files = filesPlusService.insert(savefilename, originfilename, fileExtention, fullpath, srcfile.length(), fileTypeEnum.getIndex());
        if (uploadOss.booleanValue()) {
            UploadFileDBUtil.handleOss(fullpath + savefilename);
        }
        return UploadFileDBUtil.getUploadFile(files.getFileId(), originfilename, savefilename, fileExtention, fullpath + savefilename);
    }

    private static void checkPermission(String filename, Long filesize) {
        SecurityUtil.checkUploadFilePermission((String)filename, (Long)filesize);
    }

    private static void handleOss(String fullpathfilename) {
        AppCommonConfig config = (AppCommonConfig)SpringUtil.getBean(AppCommonConfig.class);
        if (config.getOssEnable()) {
            IOssService ossService = (IOssService)SpringUtil.getBean((String)config.getOssServiceName());
            ossService.uploadFile(AppPathUtil.getResourceLocalPath(), fullpathfilename);
        }
    }

    private static UploadFile getUploadFile(Long fileId, String srcfilename, String destfilename, String fileExtention, String fullpath) {
        UploadFile uploadFile = new UploadFile();
        uploadFile.setFileId(fileId);
        uploadFile.setSavefilename(destfilename);
        uploadFile.setSrcfilename(srcfilename);
        uploadFile.setFileNameExt(fileExtention);
        uploadFile.setFullpath(fullpath);
        return uploadFile;
    }
}

