/*
 * Decompiled with CFR 0.152.
 */
package com.peak.oss.service.imple;

import com.peak.common.util.HttpUtil;
import com.peak.common.util.StringUtil;
import com.peak.oss.util.OssConfigUtil;
import com.peak.oss.util.OssUtil;
import com.peak.prd.base.service.IOssService;
import com.peak.prd.common.appconfig.util.AppconfigUtil;
import java.io.File;
import org.springframework.stereotype.Service;

@Service
public class OssService
implements IOssService {
    public Boolean uploadFile(String localPath, String fileFullPathName) {
        Boolean uploadStatus = true;
        if (!OssConfigUtil.getOssEnable()) {
            return false;
        }
        String uploadFileSaveType = AppconfigUtil.getValueByConfigkey("UPLOADFILE_SAVE_TYPE");
        String key = OssUtil.uploadFile((String)localPath, (String)fileFullPathName);
        if (StringUtil.isNullorEmptyStr((String)key)) {
            uploadStatus = false;
        }
        if (uploadFileSaveType.equals("2")) {
            try {
                File destFile = new File(localPath + fileFullPathName);
                destFile.delete();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return uploadStatus;
    }

    public String getUrl(String url) {
        if (OssConfigUtil.getOssEnable()) {
            if (url.indexOf(OssConfigUtil.getWebstaticBasedir()) >= 0) {
                url = url.substring(url.indexOf(OssConfigUtil.getWebstaticBasedir()));
            } else {
                if (url.startsWith("http")) {
                    return url;
                }
                url = OssConfigUtil.getWebstaticBasedir() + "/" + url;
                url = HttpUtil.formatURL((String)url);
            }
            url = OssUtil.getObjectUrl((String)url);
            return url;
        }
        return url;
    }

    public String getUrlUnTreatedKey(String url) {
        if (OssConfigUtil.getOssEnable()) {
            if (url.startsWith("http")) {
                return url;
            }
            url = HttpUtil.formatURL((String)url);
            url = OssUtil.getObjectUrlUnTreatedKey((String)url);
            return url;
        }
        return url;
    }

    public String getDownloadUrl(String url) {
        if (OssConfigUtil.getOssEnable()) {
            if (url.indexOf(OssConfigUtil.getWebstaticBasedir()) >= 0) {
                url = url.substring(url.indexOf(OssConfigUtil.getWebstaticBasedir()));
            } else {
                if (url.startsWith("http")) {
                    return url;
                }
                url = OssConfigUtil.getWebstaticBasedir() + "/" + url;
                url = HttpUtil.formatURL((String)url);
            }
            url = OssUtil.getDownloadUrl((String)url);
            return url;
        }
        return url;
    }

    public void download(File file, String url) {
        if (OssConfigUtil.getOssEnable()) {
            if (url.indexOf(OssConfigUtil.getWebstaticBasedir()) >= 0) {
                url = url.substring(url.indexOf(OssConfigUtil.getWebstaticBasedir()));
            } else {
                if (url.startsWith("http")) {
                    return;
                }
                url = OssConfigUtil.getWebstaticBasedir() + "/" + url;
                url = HttpUtil.formatURL((String)url);
            }
            OssUtil.download((File)file, (String)url);
        }
    }
}

