/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.appsecurity.domain.service.imple;

import com.alibaba.fastjson.JSONObject;
import com.peak.common.util.ConvertUtil;
import com.peak.common.util.FormatUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.JsonUtil;
import com.peak.common.util.ListUtil;
import com.peak.common.util.RedisService;
import com.peak.common.util.StringUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.appsecurity.domain.bo.DomainBO;
import com.peak.prd.appsecurity.domain.dao.IDomainPlusDao;
import com.peak.prd.appsecurity.domain.model.Domain;
import com.peak.prd.appsecurity.domain.service.IDomainPlusService;
import com.peak.prd.appsecurity.domain.vo.DomainQuery;
import com.peak.prd.appsecurity.domain.vo.DomainUpdateVO;
import com.peak.prd.appsecurity.org.model.Org;
import com.peak.prd.appsecurity.org.model.Orgexpand;
import com.peak.prd.appsecurity.org.service.IOrgPlusService;
import com.peak.prd.appsecurity.org.service.IOrgexpandPlusService;
import com.peak.prd.appsecurity.org.service.IOrgtreePlusService;
import com.peak.prd.appsecurity.org.service.IOrgtreechangePlusService;
import com.peak.prd.appsecurity.user.service.IUserOrgPlusService;
import com.peak.prd.base.annotation.ClearCache;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.common.appdict.service.IAppdictPlusService;
import com.peak.prd.common.appdict.vo.AppdictVO;
import com.peak.prd.common.rule.UserFilterRuleUtil;
import com.peak.prd.enums.OrgtreeCreatewayEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@CacheConfig(cacheNames={"prd"})
public class DomainPlusService
extends PrdBaseService<Domain, Long, DomainQuery>
implements IDomainPlusService {
    @Resource
    private IOrgexpandPlusService orgexpandPlusService;
    @Resource
    @Lazy
    private IOrgPlusService orgPlusService;
    @Resource
    private IOrgtreechangePlusService orgtreechangePlusService;
    @Resource
    @Lazy
    private IUserOrgPlusService userOrgPlusService;
    @Resource
    private IOrgtreePlusService orgtreePlusService;
    @Resource
    @Lazy
    private IDomainPlusService self;
    @Resource
    private IAppdictPlusService appdictPlusService;
    @Resource
    private RedisService redisService;
    private IDomainPlusDao domainPlusDao;
    private static ExecutorService persistThreadExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(0x7FFFFFFE));

    public void setDomainPlusDao(IDomainPlusDao dao) {
        this.domainPlusDao = dao;
    }

    public IDomainPlusDao getDomainPlusDao() {
        return this.domainPlusDao;
    }

    public IEntityDao<Domain, Long, DomainQuery> getEntityDao() {
        return this.domainPlusDao;
    }

    @Override
    public String findUpAndSelfIds(Long domainId) {
        List<Long> domainIdList = this.self.findUpAndSelfIdList(domainId);
        if (ListUtil.isNullorEmpty(domainIdList)) {
            return domainId + "";
        }
        return StringUtils.join(domainIdList, (String)",");
    }

    @Override
    @Cacheable
    public List<Long> findUpAndSelfIdList(Long domainId) {
        List<Orgexpand> orgexpandList = this.orgexpandPlusService.findUpAndSelfIds(domainId);
        List domainIdList = IdUtil.getIds(orgexpandList, Orgexpand::getBeginorgId);
        return domainIdList;
    }

    @Override
    public void freshDomain(Long domainId) {
        Domain domain = (Domain)this.getById(domainId);
        Org org = (Org)this.orgPlusService.findById(domainId);
        this.refreshNoFilteruserDomain(org.getEnterpriseId());
        if (domain.getFilteruseron() != null && domain.getFilteruseron() == 1) {
            this.userOrgPlusService.txFreshFilteruserDomain(domainId);
        }
        this.freshSelectAddDomain(domainId);
    }

    @Override
    public void freshSelectAddDomain(Long domainId) {
        Org org = (Org)this.orgPlusService.findById(domainId);
        Long enterpriseId = org.getEnterpriseId();
        long countnum = this.orgtreechangePlusService.count(enterpriseId, OrgtreeCreatewayEnum.SELECTADD.getValue());
        if (countnum == 0L) {
            return;
        }
        int levels = this.orgtreechangePlusService.getMaxlevels(enterpriseId, OrgtreeCreatewayEnum.SELECTADD.getValue());
        this.orgexpandPlusService.updateIncrSelectAddDomain(enterpriseId, levels);
        this.orgtreechangePlusService.deleteByEnterpriseId(enterpriseId, OrgtreeCreatewayEnum.SELECTADD.getValue());
    }

    @Override
    public void insert(Long orgId) {
        Domain domain = new Domain(orgId);
        domain.setFilteruseron(0);
        this.domainPlusDao.insertSelective((BaseEntity)domain);
    }

    @Override
    public void refreshSysAllDomain() {
        List<Org> orgList = this.orgPlusService.findCorpDomainList();
        for (Org org : orgList) {
            this.refreshEnterpriseAllDomain(org.getOrgId());
        }
    }

    @Override
    public void refreshEnterpriseAllDomain(Long enterpriseId) {
        this.refreshNoFilteruserDomain(enterpriseId);
        this.refreshFilteruserDomain(enterpriseId);
    }

    @Override
    public void refreshNoFilteruserDomain(Long enterpriseId) {
        long countnum = this.orgtreechangePlusService.count(enterpriseId, OrgtreeCreatewayEnum.NEWADD.getValue());
        if (countnum == 0L) {
            return;
        }
        int levels = this.orgtreechangePlusService.getMaxlevels(enterpriseId, OrgtreeCreatewayEnum.NEWADD.getValue());
        this.orgexpandPlusService.deleteByIncrHisData(enterpriseId);
        this.orgexpandPlusService.updateIncr(enterpriseId, levels);
        this.orgtreechangePlusService.deleteByEnterpriseId(enterpriseId, OrgtreeCreatewayEnum.NEWADD.getValue());
    }

    @Override
    public void refreshFilteruserDomain(Long enterpriseId) {
        int pagenum = 0;
        int pagesize = 100;
        int totalTimes = 5000;
        while (pagenum <= totalTimes) {
            DomainQuery query = new DomainQuery(++pagenum, pagesize);
            query.setFilteruseron(1);
            query.setEnterpriseId(enterpriseId);
            List domainList = this.domainPlusDao.findList(query, "getByFilteruseronEnterpriseId");
            if (ListUtil.isNullorEmpty((List)domainList)) break;
            for (Domain domain : domainList) {
                try {
                    this.userOrgPlusService.txFreshFilteruserDomain(domain.getDomainId());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (domainList.size() >= pagesize) continue;
            break;
        }
    }

    @Override
    public List<Long> findMngRangeOrgIds(Long domainId) {
        return this.orgtreePlusService.findMngRealorgIds(domainId);
    }

    @Override
    @ClearCache(value="#domainBO.orgId")
    public int updateSelective(DomainBO domainBO) {
        Domain domain = (Domain)ConvertUtil.convert((Object)domainBO, Domain.class);
        domain.setDomainId(domainBO.getOrgId());
        if (domain.getFilteruseron() == 1) {
            domain.setRulesql(UserFilterRuleUtil.getSQL(domain.getFilteruserrule()));
        }
        return this.domainPlusDao.updateSelective(domain);
    }

    @Override
    public String findUpIds(Long domainId) {
        List<Long> domainIdList = this.self.findUpAndSelfIdList(domainId);
        if (ListUtil.isNullorEmpty(domainIdList)) {
            return "-1";
        }
        domainIdList.remove(domainId);
        if (ListUtil.isNullorEmpty(domainIdList)) {
            return "-1";
        }
        return StringUtils.join(domainIdList, (String)",");
    }

    @Override
    public void updateTableDomainId(final Long sourceDomainId, final Long targetDomainId) {
        final List<AppdictVO> appdictVOList = this.appdictPlusService.getVOTreeList((Long)4000L, (Long)0L, 9002L);
        if (ListUtil.isNullorEmpty(appdictVOList)) {
            this.reloadRedisUpdateTableDomainIdData(100.0, 0L, 0L, new ArrayList<AppdictVO>());
            return;
        }
        this.reloadRedisUpdateTableDomainIdData(0.0, appdictVOList.size(), 0L, new ArrayList<AppdictVO>());
        persistThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                long totalnum = appdictVOList.size();
                double progress = 0.0;
                long updatenum = 0L;
                ArrayList<AppdictVO> errorAppdictVOList = new ArrayList<AppdictVO>();
                for (AppdictVO appdictVO : appdictVOList) {
                    String[] tableNameColumn = DomainPlusService.this.getTableNameColumn(appdictVO);
                    if (tableNameColumn != null) {
                        try {
                            DomainPlusService.this.domainPlusDao.updateTableDomainId(tableNameColumn[0], tableNameColumn[1], sourceDomainId, targetDomainId);
                        }
                        catch (Exception e) {
                            errorAppdictVOList.add(appdictVO);
                        }
                    } else {
                        errorAppdictVOList.add(appdictVO);
                    }
                    progress = FormatUtil.toScale((double)((double)(++updatenum / totalnum) * 100.0), (int)2);
                    DomainPlusService.this.reloadRedisUpdateTableDomainIdData(progress, totalnum, updatenum, errorAppdictVOList);
                }
            }
        });
    }

    @Override
    public DomainUpdateVO getDomainUpdateVOInfo() {
        String redisKey = "domainService:updateTableDomainId";
        String redisValue = this.redisService.get(redisKey);
        return (DomainUpdateVO)JsonUtil.JsonToObject((String)redisValue, DomainUpdateVO.class);
    }

    private String[] getTableNameColumn(AppdictVO appdictVO) {
        if (appdictVO == null || StringUtil.isNullorEmptyStr((String)appdictVO.getCode())) {
            return null;
        }
        String[] tableName_column = appdictVO.getCode().split(",");
        if (tableName_column.length > 2) {
            return null;
        }
        if (tableName_column.length == 1) {
            return new String[]{tableName_column[0], "domain_id"};
        }
        return tableName_column;
    }

    private void reloadRedisUpdateTableDomainIdData(double progress, long totalnum, long updatenum, List<AppdictVO> errorAppdictVOList) {
        String redisKey = "domainService:updateTableDomainId";
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("progress", (Object)progress);
        jsonObject.put("totalnum", (Object)totalnum);
        jsonObject.put("updatenum", (Object)updatenum);
        jsonObject.put("errorAppdictVOList", errorAppdictVOList);
        this.redisService.set(redisKey, jsonObject.toJSONString());
    }

    @Caching(evict={@CacheEvict(cacheNames={"prd"}, key="'DomainPlusService:' + #orgId")})
    public void clearCache(Long orgId) {
    }
}

