/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.appsecurity.domain.service.imple;

import com.peak.common.util.SpringUtil;
import com.peak.prd.appsecurity.domain.model.Domain;
import com.peak.prd.appsecurity.domain.service.IDomainPlusService;
import com.peak.prd.appsecurity.org.model.Org;
import com.peak.prd.appsecurity.org.model.Orgtree;
import com.peak.prd.appsecurity.org.service.IOrgPlusService;
import com.peak.prd.appsecurity.org.service.IOrgexpandPlusService;
import com.peak.prd.appsecurity.org.service.IOrgtreePlusService;
import com.peak.prd.appsecurity.org.vo.OrgtreeQuery;
import com.peak.prd.appsecurity.user.model.UserOrg;
import com.peak.prd.appsecurity.user.model.UserOrgRole;
import com.peak.prd.appsecurity.user.service.IUserOrgPlusService;
import com.peak.prd.appsecurity.user.vo.UserOrgQuery;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
@CacheConfig(cacheNames={"user"})
public class DomainUtilService {
    private static final Long RoleEnumStudent = 1000L;
    private static final Long DomainRoot = 9002L;
    @Autowired
    IUserOrgPlusService userOrgPlusService;
    @Autowired
    IOrgtreePlusService orgtreePlusService;
    @Autowired
    IOrgPlusService orgPlusService;
    @Autowired
    IDomainPlusService domainPlusService;
    @Autowired
    IOrgexpandPlusService orgexpandPlusService;

    private DomainUtilService getSelf() {
        return (DomainUtilService)SpringUtil.getBean(DomainUtilService.class);
    }

    public List<UserOrg> getUserOrgs(Long userId) {
        if (userId == null) {
            return null;
        }
        UserOrgQuery userOrgQuery = new UserOrgQuery();
        userOrgQuery.setUserId(userId);
        userOrgQuery.getPage().setSortColumns("domain_id, org_id");
        List userOrgs = this.userOrgPlusService.findAll(userOrgQuery);
        return userOrgs;
    }

    public List<Long> findUserFrontDomains(Long userId) {
        List<UserOrgRole> uors = this.findUserDomainRoleAll(userId, this.getUserOrgs(userId), true);
        if (uors == null || uors.isEmpty()) {
            return null;
        }
        ArrayList<Long> list = new ArrayList<Long>();
        for (int i = 0; i < uors.size(); ++i) {
            UserOrgRole uor = uors.get(i);
            if (uor == null || uor.getOrgId() == null) continue;
            list.add(uor.getOrgId());
        }
        return list;
    }

    public List<UserOrgRole> findUserDomainRoleAll(Long userId, List<UserOrg> userOrgs, boolean front) {
        if (userId == null) {
            return null;
        }
        ArrayList<UserOrgRole> list = new ArrayList<UserOrgRole>();
        List<UserOrgRole> tmplist = null;
        if (front) {
            tmplist = this.getSelf().getUORs(userOrgs);
            if (tmplist != null && !tmplist.isEmpty()) {
                list.addAll(tmplist);
            }
            if (list.isEmpty()) {
                list.add(new UserOrgRole(userId, DomainRoot, RoleEnumStudent));
            }
        }
        return list;
    }

    public List<UserOrgRole> getUORs(List<UserOrg> userOrgs) {
        ArrayList<UserOrgRole> list = new ArrayList<UserOrgRole>();
        List<UserOrgRole> tmplist = this.getSelf().getUORsByReal(userOrgs);
        if (tmplist != null && !tmplist.isEmpty()) {
            list.addAll(tmplist);
        }
        if ((tmplist = this.getSelf().getUORsByVirtualFilter(userOrgs)) != null && !tmplist.isEmpty()) {
            list.addAll(tmplist);
        }
        if ((tmplist = this.getSelf().getUORsByVirtualNoFilter(userOrgs)) != null && !tmplist.isEmpty()) {
            list.addAll(tmplist);
        }
        if (list.isEmpty()) {
            list.add(new UserOrgRole(0L, DomainRoot, RoleEnumStudent));
        }
        return list;
    }

    public List<UserOrgRole> getUORsByVirtualNoFilter(List<UserOrg> userOrgs) {
        int i;
        List<Long> directReals = this.getSelf().getDirectReals(userOrgs);
        ArrayList<Long> treeReals = new ArrayList<Long>();
        for (int i2 = 0; directReals != null && i2 < directReals.size(); ++i2) {
            List<Long> tmplist = this.getSelf().getTreeIds(directReals.get(i2));
            if (tmplist == null || tmplist.isEmpty()) continue;
            treeReals.addAll(tmplist);
        }
        if (treeReals == null || treeReals.isEmpty()) {
            return null;
        }
        List<Orgtree> orgtrees = this.getSelf()._cacheMgrOrgtreesByReals(treeReals);
        if (orgtrees == null || orgtrees.isEmpty()) {
            return null;
        }
        List<Object> list = new ArrayList<UserOrgRole>();
        ArrayList<Long> parents = new ArrayList<Long>();
        for (i = 0; i < orgtrees.size(); ++i) {
            Orgtree ot = orgtrees.get(i);
            Long domainId = ot.getParentId();
            if (!this.getSelf()._isVirtualDomain(domainId) || this.getSelf()._hasFilter(domainId)) continue;
            parents.add(domainId);
        }
        if (parents == null || parents.isEmpty()) {
            return null;
        }
        if (parents.size() == 1) {
            list.add(new UserOrgRole(0L, (Long)parents.get(0), RoleEnumStudent));
            return list;
        }
        list = this.getSelf()._cacheLeafs(parents);
        if (list.isEmpty()) {
            for (i = 0; i < parents.size(); ++i) {
                list.add(new UserOrgRole(0L, (Long)parents.get(i), RoleEnumStudent));
            }
        }
        return list;
    }

    @Cacheable(key="'dm:leafv_' + #parents")
    public List<UserOrgRole> _cacheLeafs(List<Long> parents) {
        ArrayList<UserOrgRole> list = new ArrayList<UserOrgRole>();
        for (int i = 0; i < parents.size(); ++i) {
            ArrayList<Long> beginOrgIds = new ArrayList<Long>();
            beginOrgIds.add(parents.get(i));
            boolean isLeaf = true;
            for (int j = 0; j < parents.size(); ++j) {
                boolean b;
                if (i == j || !(b = this.orgexpandPlusService.hasBeginEnd(beginOrgIds, parents.get(j)))) continue;
                isLeaf = false;
                break;
            }
            if (!isLeaf) continue;
            list.add(new UserOrgRole(0L, parents.get(i), RoleEnumStudent));
        }
        return list;
    }

    @Cacheable(key="'dm:Ot_' + #reals")
    public List<Orgtree> _cacheMgrOrgtreesByReals(List<Long> reals) {
        return this._innerGetMgrOrgtrees(reals);
    }

    public List<Orgtree> _innerGetMgrOrgtrees(List<Long> reals) {
        if (reals == null || reals.isEmpty()) {
            return new ArrayList<Orgtree>();
        }
        OrgtreeQuery orgtreeQuery = new OrgtreeQuery();
        orgtreeQuery.setLinktype(1);
        orgtreeQuery.setOrgIdList(reals);
        List<Orgtree> list = this.orgtreePlusService.getAll(orgtreeQuery);
        if (list == null) {
            list = new ArrayList<Orgtree>();
        }
        return list;
    }

    public List<UserOrgRole> getUORsByReal(List<UserOrg> userOrgs) {
        if (userOrgs == null || userOrgs.isEmpty()) {
            return null;
        }
        List<Long> directReals = this.getDirectReals(userOrgs);
        if (directReals == null || directReals.isEmpty()) {
            return null;
        }
        if (directReals.size() == 1) {
            return this.getSelf()._cacheGetUORsByReal(directReals.get(0));
        }
        ArrayList<UserOrgRole> list = new ArrayList<UserOrgRole>();
        for (int i = 0; i < directReals.size(); ++i) {
            List<UserOrgRole> tmplist = this.getSelf()._cacheGetUORsByReal(directReals.get(i));
            if (tmplist == null || tmplist.isEmpty()) continue;
            list.addAll(tmplist);
        }
        if (list.isEmpty()) {
            list.add(new UserOrgRole(0L, DomainRoot, RoleEnumStudent));
        }
        return list;
    }

    public List<Long> getDirectReals(List<UserOrg> userOrgs) {
        if (userOrgs == null || userOrgs.isEmpty()) {
            return null;
        }
        ArrayList<Long> directReals = new ArrayList<Long>();
        for (int i = 0; i < userOrgs.size(); ++i) {
            UserOrg uo = userOrgs.get(i);
            if (uo == null || uo.getDomainId() != null && uo.getDomainId() != 0L || uo.getOrgId() == null) continue;
            directReals.add(uo.getOrgId());
        }
        return directReals;
    }

    @Cacheable(key="'dm:ReaL_UORs_' + #real")
    public List<UserOrgRole> _cacheGetUORsByReal(Long real) {
        return this._innerGetUORsByReal(real);
    }

    public String getCacheKey(List<Long> reals) {
        if (reals == null || reals.isEmpty()) {
            return "_EMPTY_";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < reals.size(); ++i) {
            sb.append(reals.get(i)).append("_");
        }
        return sb.toString();
    }

    public List<UserOrgRole> _innerGetUORsByReal(Long real) {
        ArrayList<UserOrgRole> list = new ArrayList<UserOrgRole>();
        List<Long> realTreeIds = this.getSelf().getTreeIds(real);
        for (int i = 0; realTreeIds != null && i < realTreeIds.size(); ++i) {
            Long orgId = realTreeIds.get(i);
            boolean isRealDomain = this.getSelf()._isRealDomain(orgId);
            if (!isRealDomain) continue;
            list.add(new UserOrgRole(0L, orgId, RoleEnumStudent));
            break;
        }
        return list;
    }

    public List<Long> innerGetTreeIds(Long orgId) {
        if (orgId == null) {
            return null;
        }
        ArrayList<Long> treeIds = new ArrayList<Long>();
        treeIds.add(orgId);
        OrgtreeQuery orgtreeQuery = new OrgtreeQuery();
        orgtreeQuery.setLinktype(0);
        orgtreeQuery.setOrgId(orgId);
        List orgtrees = this.orgtreePlusService.findAll(orgtreeQuery);
        if (orgtrees == null || orgtrees.isEmpty()) {
            return treeIds;
        }
        Long parentId = ((Orgtree)orgtrees.get(0)).getParentId();
        if (parentId == null || parentId.longValue() == orgId.longValue() || parentId <= 0L) {
            return treeIds;
        }
        if (parentId.longValue() == DomainRoot.longValue()) {
            treeIds.add(DomainRoot);
        } else {
            treeIds.addAll(this.getSelf().getTreeIds(parentId));
        }
        return treeIds;
    }

    @Cacheable(key="'dm:Otree_' + #orgId")
    public List<Long> getTreeIds(Long orgId) {
        if (orgId == null) {
            return null;
        }
        return this.innerGetTreeIds(orgId);
    }

    public List<UserOrgRole> getUORsByVirtualFilter(List<UserOrg> userOrgs) {
        if (userOrgs == null) {
            return null;
        }
        ArrayList<UserOrgRole> list = null;
        for (int i = 0; i < userOrgs.size(); ++i) {
            UserOrg uo = userOrgs.get(i);
            if (uo == null || uo.getDomainId() == null || uo.getDomainId() == 0L) continue;
            if (list == null) {
                list = new ArrayList<UserOrgRole>();
            }
            UserOrgRole uor = new UserOrgRole(uo.getUserId(), uo.getDomainId(), RoleEnumStudent);
            list.add(uor);
        }
        return list;
    }

    public String findSupIds(List<Long> domainIds) {
        if (domainIds == null || domainIds.isEmpty()) {
            return null;
        }
        return this.findSupIds(domainIds.toArray(new Long[domainIds.size()]));
    }

    public String findSupIds(Long[] domainIds) {
        if (domainIds == null || domainIds.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean b = false;
        for (int i = 0; i < domainIds.length; ++i) {
            String str = this.findSupIds(domainIds[i]);
            if (str == null || str.isEmpty()) continue;
            if (!b) {
                sb.append(str);
                b = true;
                continue;
            }
            sb.append(",").append(str);
        }
        return sb.toString();
    }

    public String findSupIds(Long domainId) {
        if (domainId == null) {
            return null;
        }
        OrgtreeQuery orgtreeQuery = new OrgtreeQuery();
        orgtreeQuery.setOrgId(domainId);
        orgtreeQuery.setLinktype(1);
        List list = this.orgtreePlusService.findAll(orgtreeQuery);
        if (list == null || list.isEmpty()) {
            return domainId.toString();
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            Orgtree ot = (Orgtree)list.get(i);
            if (ot == null || ot.getParentId() == null) continue;
            sb.append(ot.getParentId()).append(",");
        }
        sb.append(domainId);
        return sb.toString();
    }

    public String findMgrIds(List<Long> domainIds) {
        if (domainIds == null || domainIds.isEmpty()) {
            return null;
        }
        return this.findMgrIds(domainIds.toArray(new Long[domainIds.size()]));
    }

    public String findMgrIds(Long[] domainIds) {
        if (domainIds == null || domainIds.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean b = false;
        for (int i = 0; i < domainIds.length; ++i) {
            String str = this.findMgrIds(domainIds[i]);
            if (str == null || str.isEmpty()) continue;
            if (!b) {
                sb.append(str);
                b = true;
                continue;
            }
            sb.append(",").append(str);
        }
        return sb.toString();
    }

    public String findMgrIds(Long domainId) {
        if (domainId == null) {
            return null;
        }
        OrgtreeQuery orgtreeQuery = new OrgtreeQuery();
        orgtreeQuery.setParentId(domainId);
        orgtreeQuery.setLinktype(1);
        List list = this.orgtreePlusService.findAll(orgtreeQuery);
        if (list == null || list.isEmpty()) {
            return domainId.toString();
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            Orgtree ot = (Orgtree)list.get(i);
            if (ot == null || ot.getOrgId() == null) continue;
            sb.append(ot.getOrgId()).append(",");
        }
        sb.append(domainId);
        return sb.toString();
    }

    public List<Long> toIdList(String ids) {
        String[] ary = ids.split(",");
        ArrayList<Long> list = new ArrayList<Long>();
        for (String s : ary) {
            list.add(new Long(s));
        }
        return list;
    }

    public boolean isMgr(Long superOrgId, Long subOrgId) {
        if (superOrgId == null || subOrgId == null) {
            return false;
        }
        if (superOrgId.longValue() == DomainRoot.longValue()) {
            return true;
        }
        return this.orgexpandPlusService.hasBeginEnd(this.toIdList(this.findMgrIds(superOrgId)), subOrgId);
    }

    public boolean _hasFilter(Long domainId) {
        if (domainId == null) {
            return false;
        }
        Domain domain = (Domain)this.domainPlusService.findById(domainId);
        if (domain == null) {
            return false;
        }
        return domain.getFilteruseron() != null && domain.getFilteruseron() != 0;
    }

    public boolean hasFilter(Object domainId) {
        if (domainId == null) {
            return false;
        }
        String str = domainId.toString();
        if (str.isEmpty() || str.trim().isEmpty()) {
            return false;
        }
        Long id = new Long(str);
        return this._hasFilter(id);
    }

    public boolean _isVirtualDomain(Long domainId) {
        if (domainId == null) {
            return false;
        }
        if (domainId.longValue() == DomainRoot.longValue()) {
            return false;
        }
        Org org = (Org)this.orgPlusService.findById(domainId);
        if (org == null) {
            return false;
        }
        Integer d = org.getIsdomain();
        if (d == null || d != 1) {
            return false;
        }
        Integer v = org.getIsvirtual();
        return v != null && v == 1;
    }

    public boolean isVirtualDomain(Object domainId) {
        if (domainId == null) {
            return false;
        }
        String str = domainId.toString();
        if (str.isEmpty() || str.trim().isEmpty()) {
            return false;
        }
        Long id = new Long(str);
        return this._isVirtualDomain(id);
    }

    public boolean _isRealDomain(Long domainId) {
        if (domainId == null) {
            return false;
        }
        if (domainId.longValue() == DomainRoot.longValue()) {
            return true;
        }
        Org org = (Org)this.orgPlusService.findById(domainId);
        if (org == null) {
            return false;
        }
        Integer d = org.getIsdomain();
        if (d == null || d == 0) {
            return false;
        }
        Integer v = org.getIsvirtual();
        return v == null || v != 1;
    }

    public boolean isRealDomain(Object domainId) {
        if (domainId == null) {
            return false;
        }
        String str = domainId.toString();
        if (str.isEmpty() || str.trim().isEmpty()) {
            return false;
        }
        Long id = new Long(str);
        return this._isRealDomain(id);
    }

    public boolean isReal(Object domainId) {
        return this.isRealDomain(domainId);
    }

    public boolean isVirtual(Object domainId) {
        return this.isVirtualDomain(domainId);
    }

    @Deprecated
    public String findManagedDomainIds(Long domainId) {
        return this.findMgrIds(domainId);
    }

    public Long getDirectRealDomainId(Long userId) {
        return this.getDirectRealDomainId(userId, this.getSelf().getUserOrgs(userId));
    }

    public Long getDirectRealDomainId(Long userId, List<UserOrg> userOrgs) {
        if (userId == null) {
            return null;
        }
        if (userOrgs == null || userOrgs.isEmpty()) {
            return DomainRoot;
        }
        List<Long> directReals = this.getDirectReals(userOrgs);
        if (directReals == null || directReals.isEmpty()) {
            return DomainRoot;
        }
        List<UserOrgRole> uors = this.getSelf()._cacheGetUORsByReal(directReals.get(0));
        if (uors == null || uors.isEmpty()) {
            return DomainRoot;
        }
        return uors.get(0).getOrgId();
    }

    public class LinkType {
        public static final int ParentChild = 0;
        public static final int Contain = 1;
    }
}

