/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.appsecurity.domain.util;

import com.peak.common.util.ListUtil;
import com.peak.common.util.SpringUtil;
import com.peak.common.util.StringUtil;
import com.peak.prd.appsecurity.domain.model.Domain;
import com.peak.prd.appsecurity.domain.service.IDomainPlusService;
import com.peak.prd.appsecurity.domain.service.imple.DomainPlusService;
import com.peak.prd.appsecurity.domain.service.imple.DomainUtilService;
import com.peak.prd.appsecurity.domain.util.DomainCoreUtil;
import com.peak.prd.appsecurity.org.model.Org;
import com.peak.prd.appsecurity.org.model.Orgtree;
import com.peak.prd.appsecurity.org.service.IOrgPlusService;
import com.peak.prd.appsecurity.org.service.IOrgtreePlusService;
import com.peak.prd.appsecurity.org.service.imple.OrgPlusService;
import com.peak.prd.appsecurity.org.service.imple.OrgtreePlusService;
import com.peak.prd.common.appconfig.util.AppconfigUtil;
import com.peak.prd.enums.AppconfigEnum;
import com.peak.prd.enums.SysInitData;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class DomainUtil
extends DomainCoreUtil {
    public static List<Long> getUserFrontDomainIds(Long userId) {
        DomainUtilService domainUtilService = (DomainUtilService)SpringUtil.getBean(DomainUtilService.class);
        return domainUtilService.findUserFrontDomains(userId);
    }

    public static String findMgrIds(Long domainId) {
        return domainId + "";
    }

    public static String findMgrIds(Long[] domainIds) {
        return StringUtils.join((Object[])domainIds, (String)",");
    }

    public static String findMgrIds(List<Long> domainIds) {
        return StringUtils.join(domainIds, (String)",");
    }

    public static String findUpAndSelfIds(Long domainId) {
        if (domainId == null) {
            return "";
        }
        IDomainPlusService domainPlusService = (IDomainPlusService)SpringUtil.getBean(DomainPlusService.class);
        return domainPlusService.findUpAndSelfIds(domainId);
    }

    public static Long findDirectParentId(Long domainId) {
        if (domainId == null) {
            return null;
        }
        IOrgtreePlusService orgtreePlusService = (IOrgtreePlusService)SpringUtil.getBean(OrgtreePlusService.class);
        List<Orgtree> orgtreeList = orgtreePlusService.findRealByOrgId(domainId);
        if (orgtreeList.size() > 0) {
            return orgtreeList.get(0).getParentId();
        }
        return null;
    }

    public static List<Long> findMngRangeOrgIds(Long domainId) {
        if (domainId == null) {
            return new ArrayList<Long>();
        }
        IDomainPlusService domainPlusService = (IDomainPlusService)SpringUtil.getBean(DomainPlusService.class);
        return domainPlusService.findMngRangeOrgIds(domainId);
    }

    public static boolean isHasFilter(Long orgId) {
        if (orgId == null) {
            return false;
        }
        IDomainPlusService domainPlusService = (IDomainPlusService)SpringUtil.getBean(DomainPlusService.class);
        Domain domain = (Domain)domainPlusService.findById(orgId);
        if (domain == null) {
            return false;
        }
        if (domain.getFilteruseron() == null) {
            return false;
        }
        return domain.getFilteruseron() != 0;
    }

    public static boolean isRealOrg(Long orgId) {
        if (orgId == null) {
            return false;
        }
        IOrgPlusService orgPlusService = (IOrgPlusService)SpringUtil.getBean(OrgPlusService.class);
        Org org = (Org)orgPlusService.findById(orgId);
        if (org == null) {
            return true;
        }
        if (org.getIsvirtual() == null) {
            return true;
        }
        return org.getIsvirtual() != 1;
    }

    public static boolean isEnterpriseRootOrgId(Long orgId) {
        if (orgId == null) {
            return false;
        }
        String orgRootId = AppconfigUtil.getValueByConfigkey(AppconfigEnum.ENTERPRISE_ROOT_ORGID.getValue());
        if (StringUtil.isNullorEmptyStr((String)orgRootId)) {
            return false;
        }
        return Long.parseLong(orgRootId) == orgId;
    }

    public static boolean isContainRootOrgId(List<Long> domainIds) {
        if (ListUtil.isNullorEmpty(domainIds)) {
            return false;
        }
        return domainIds.contains(SysInitData.ORG_ROOT.getValue());
    }

    public static String findUpIds(Long domainId) {
        if (domainId == null) {
            return "";
        }
        IDomainPlusService domainPlusService = (IDomainPlusService)SpringUtil.getBean(DomainPlusService.class);
        return domainPlusService.findUpIds(domainId);
    }
}

