/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.appsecurity.group.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.ListUtil;
import com.peak.common.util.StringUtil;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.appsecurity.group.bo.GroupMemberBO;
import com.peak.prd.appsecurity.group.dao.IGroupMemberPlusDao;
import com.peak.prd.appsecurity.group.model.GroupMember;
import com.peak.prd.appsecurity.group.service.IGroupMemberPlusService;
import com.peak.prd.appsecurity.group.vo.GroupMemberQuery;
import com.peak.prd.appsecurity.user.util.UserCoreUtil;
import com.peak.prd.appsecurity.user.vo.UserVO;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.enums.GroupMemberTypeEnum;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class GroupMemberPlusService
extends PrdBaseService<GroupMember, Map<String, Object>, GroupMemberQuery>
implements IGroupMemberPlusService {
    private IGroupMemberPlusDao groupMemberPlusDao;

    public void setGroupMemberPlusDao(IGroupMemberPlusDao dao) {
        this.groupMemberPlusDao = dao;
    }

    public IGroupMemberPlusDao getGroupMemberPlusDao() {
        return this.groupMemberPlusDao;
    }

    public IEntityDao<GroupMember, Map<String, Object>, GroupMemberQuery> getEntityDao() {
        return this.groupMemberPlusDao;
    }

    @Override
    public int batchInsertBO(List<GroupMemberBO> groupMemberBOList, Long groupId, Long userId) {
        if (groupMemberBOList.isEmpty()) {
            return 0;
        }
        Date now = new Date();
        return this.getGroupMemberPlusDao().insertBatch(groupMemberBOList.stream().map(groupMemberBO -> {
            GroupMember groupMember = (GroupMember)ConvertUtil.convert((Object)groupMemberBO, GroupMember.class);
            groupMember.setGroupId(groupId);
            groupMember.setCreatorId(userId);
            groupMember.setCreatedate(now);
            return groupMember;
        }).collect(Collectors.toList()));
    }

    @Override
    public int deleteByGroupId(Long groupId) {
        return this.getGroupMemberPlusDao().deleteByGroupId(groupId);
    }

    @Override
    public List<GroupMember> getListByGroupIdAndMemberIdList(Long groupId, List<Long> memberIdList) {
        return this.getGroupMemberPlusDao().getListByGroupIdAndMemberIdList(groupId, memberIdList);
    }

    @Override
    public int batchInsertNotExistList(List<Long> memberIdList, Long groupId, Long userId, Integer membertype) {
        if (ListUtil.isNullorEmpty(memberIdList)) {
            return 0;
        }
        List<GroupMember> existGroupMemberList = this.getListByGroupIdAndMemberIdList(groupId, memberIdList);
        List existMemberIdList = existGroupMemberList.stream().map(groupMember -> groupMember.getMemberId()).collect(Collectors.toList());
        Date now = new Date();
        return this.getGroupMemberPlusDao().insertBatch(memberIdList.stream().filter(memberId -> !existMemberIdList.contains(memberId)).distinct().map(memberId -> {
            GroupMember groupMember = new GroupMember();
            groupMember.setGroupId(groupId);
            groupMember.setMemberId((Long)memberId);
            groupMember.setCreatorId(userId);
            groupMember.setCreatedate(now);
            groupMember.setMembertype(membertype);
            return groupMember;
        }).collect(Collectors.toList()));
    }

    @Override
    public boolean isInScope(Long userId, List<Long> groupIdList) {
        GroupMemberQuery groupMemberQuery = new GroupMemberQuery();
        groupMemberQuery.setMemberId(userId);
        groupMemberQuery.setGroupIdList(groupIdList);
        groupMemberQuery.setMembertype(GroupMemberTypeEnum.USER.getValue());
        long userCount = this.groupMemberPlusDao.count(groupMemberQuery);
        if (userCount > 0L) {
            return true;
        }
        UserVO userVO = UserCoreUtil.getUserVO(userId);
        groupMemberQuery = new GroupMemberQuery();
        groupMemberQuery.setMemberId(userVO.getDeptId());
        groupMemberQuery.setGroupIdList(groupIdList);
        groupMemberQuery.setMembertype(GroupMemberTypeEnum.ORG_NOT_INCLUDE_SUB.getValue());
        long orgNotIncludeSubCount = this.groupMemberPlusDao.count(groupMemberQuery);
        if (orgNotIncludeSubCount > 0L) {
            return true;
        }
        groupMemberQuery = new GroupMemberQuery();
        groupMemberQuery.setGroupIdList(groupIdList);
        groupMemberQuery.setMembertype(GroupMemberTypeEnum.ORG_INCLUDE_SUB.getValue());
        List orgIncludeSubList = this.groupMemberPlusDao.findAll(groupMemberQuery);
        if (ListUtil.isNullorEmpty((List)orgIncludeSubList)) {
            return false;
        }
        List userOrgIdList = StringUtil.splitToLongList((String)userVO.getFullOrgIds(), (String)",");
        if (ListUtil.isNullorEmpty((List)userOrgIdList)) {
            return false;
        }
        for (GroupMember groupMember : orgIncludeSubList) {
            if (!userOrgIdList.contains(groupMember.getMemberId())) continue;
            return true;
        }
        return false;
    }
}

