/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.appsecurity.group.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.appsecurity.group.bo.GroupUserlistBO;
import com.peak.prd.appsecurity.group.dao.IGroupUserlistPlusDao;
import com.peak.prd.appsecurity.group.model.GroupUserlist;
import com.peak.prd.appsecurity.group.service.IGroupUserlistPlusService;
import com.peak.prd.appsecurity.group.vo.GroupUserlistQuery;
import com.peak.prd.base.service.imple.PrdBaseService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class GroupUserlistPlusService
extends PrdBaseService<GroupUserlist, Map<String, Object>, GroupUserlistQuery>
implements IGroupUserlistPlusService {
    private IGroupUserlistPlusDao groupUserlistPlusDao;

    public void setGroupUserlistPlusDao(IGroupUserlistPlusDao dao) {
        this.groupUserlistPlusDao = dao;
    }

    public IGroupUserlistPlusDao getGroupUserlistPlusDao() {
        return this.groupUserlistPlusDao;
    }

    public IEntityDao<GroupUserlist, Map<String, Object>, GroupUserlistQuery> getEntityDao() {
        return this.groupUserlistPlusDao;
    }

    @Override
    public int deleteByGroupIdAndType(Long groupId, Integer type) {
        return this.getGroupUserlistPlusDao().deleteByGroupIdAndType(groupId, type);
    }

    @Override
    public int batchInsert(List<GroupUserlistBO> groupUserlistBOList, Long groupId, Long userId) {
        Date now = new Date();
        return this.getGroupUserlistPlusDao().insertBatch(groupUserlistBOList.stream().map(groupUserlistBO -> {
            GroupUserlist groupUserlist = (GroupUserlist)ConvertUtil.convert((Object)groupUserlistBO, GroupUserlist.class);
            groupUserlist.setGroupId(groupId);
            groupUserlist.setCreatorId(userId);
            groupUserlist.setCreatedate(now);
            return groupUserlist;
        }).collect(Collectors.toList()));
    }

    @Override
    public boolean isInGroupUserlist(Long userId, List<Long> groupIdList, Integer type) {
        GroupUserlistQuery groupUserlistQuery = new GroupUserlistQuery();
        groupUserlistQuery.setUserId(userId);
        groupUserlistQuery.setGroupIdList(groupIdList);
        groupUserlistQuery.setType(type);
        long count = this.groupUserlistPlusDao.count(groupUserlistQuery);
        return count > 0L;
    }
}

