/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.appsecurity.group.service.imple;

import com.peak.common.util.AppPathUtil;
import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.ListUtil;
import com.peak.common.util.StringUtil;
import com.peak.common.util.UploadFileUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.appsecurity.group.bo.GroupBO;
import com.peak.prd.appsecurity.group.bo.GroupQueryBO;
import com.peak.prd.appsecurity.group.bo.GroupUserlistBO;
import com.peak.prd.appsecurity.group.dao.ITgroupPlusDao;
import com.peak.prd.appsecurity.group.imp.GroupMemberOrgImportExcelModel;
import com.peak.prd.appsecurity.group.imp.GroupMemberUserImportExcelModel;
import com.peak.prd.appsecurity.group.model.Group;
import com.peak.prd.appsecurity.group.service.IGroupMemberPlusService;
import com.peak.prd.appsecurity.group.service.IGroupUserlistPlusService;
import com.peak.prd.appsecurity.group.service.ITgroupPlusService;
import com.peak.prd.appsecurity.group.vo.GroupDetailMngVO;
import com.peak.prd.appsecurity.group.vo.GroupMemberQuery;
import com.peak.prd.appsecurity.group.vo.GroupMemberVO;
import com.peak.prd.appsecurity.group.vo.GroupMngVO;
import com.peak.prd.appsecurity.group.vo.GroupQuery;
import com.peak.prd.appsecurity.group.vo.GroupUserlistQuery;
import com.peak.prd.appsecurity.group.vo.GroupUserlistVO;
import com.peak.prd.appsecurity.org.dao.IOrgPlusDao;
import com.peak.prd.appsecurity.org.model.Org;
import com.peak.prd.appsecurity.org.util.OrgUtil;
import com.peak.prd.appsecurity.user.dao.IUserPlusDao;
import com.peak.prd.appsecurity.user.model.User;
import com.peak.prd.appsecurity.user.util.UserCoreUtil;
import com.peak.prd.base.model.IRespStatusEnum;
import com.peak.prd.base.model.Paging;
import com.peak.prd.base.model.ResponseStatusEnum;
import com.peak.prd.base.model.UploadFile;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.base.util.ExceptionUtil;
import com.peak.prd.enums.GroupMemberTypeEnum;
import com.peak.prd.enums.GroupUserlistTypeEnum;
import com.peak.prd.exception.PrdBaseException;
import com.peak.tools.easyexcel.model.ExcelResultVO;
import com.peak.tools.easyexcel.util.ExcelReadUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class TgroupPlusService
extends PrdBaseService<Group, Long, GroupQuery>
implements ITgroupPlusService {
    private static final Logger log = LoggerFactory.getLogger(TgroupPlusService.class);
    public static final Integer MAX_WHEREUSED = 3;
    public static final Integer IMMEDIATE_SYNC_MAX_USER_GROUP = 1000;
    @Autowired
    private IGroupMemberPlusService groupMemberPlusService;
    @Autowired
    private IGroupUserlistPlusService groupUserlistPlusService;
    @Autowired
    private IOrgPlusDao orgPlusDao;
    @Autowired
    private IUserPlusDao userPlusDao;
    private ITgroupPlusDao tgroupPlusDao;

    public void setTgroupPlusDao(ITgroupPlusDao tgroupPlusDao) {
        this.tgroupPlusDao = tgroupPlusDao;
    }

    public ITgroupPlusDao getTgroupPlusDao() {
        return this.tgroupPlusDao;
    }

    public IEntityDao<Group, Long, GroupQuery> getEntityDao() {
        return this.tgroupPlusDao;
    }

    @Override
    public Paging<GroupMngVO> getMngVOPage(GroupQueryBO groupQueryBO, Long mngDomainId) {
        GroupQuery groupQuery = new GroupQuery(groupQueryBO.getPageNumber(), groupQueryBO.getPageSize());
        ConvertUtil.copyProperties((Object)((Object)groupQueryBO), (Object)groupQuery);
        groupQuery.setDomainId(mngDomainId);
        groupQuery.setDeleted(0);
        groupQuery.getPage().setSortColumns(" g.createdate desc ");
        return this.queryPage(groupQuery);
    }

    @Override
    public Paging<GroupMngVO> getSelectMngVOPage(GroupQueryBO groupQueryBO, Long mngDomainId) {
        GroupQuery groupQuery = new GroupQuery(groupQueryBO.getPageNumber(), groupQueryBO.getPageSize());
        ConvertUtil.copyProperties((Object)((Object)groupQueryBO), (Object)groupQuery);
        groupQuery.setDomainId(mngDomainId);
        groupQuery.setStatus(1);
        groupQuery.setDeleted(0);
        groupQuery.getPage().setSortColumns(" g.createdate desc ");
        return this.queryPage(groupQuery);
    }

    private Paging<GroupMngVO> queryPage(GroupQuery groupQuery) {
        Paging groupMngVOPaging = this.getTgroupPlusDao().findPaging(groupQuery, GroupMngVO.class);
        if (ListUtil.isNullorEmpty((List)groupMngVOPaging.getList())) {
            return groupMngVOPaging;
        }
        UserCoreUtil.setUserRealname(groupMngVOPaging.getList(), GroupMngVO::getCreatorId, GroupMngVO::setCreatorName);
        return groupMngVOPaging;
    }

    @Override
    public GroupDetailMngVO getMngDetailVO(Long groupId) {
        Group group = (Group)this.getTgroupPlusDao().getById(groupId);
        if (group == null) {
            ExceptionUtil.handle((IRespStatusEnum)ResponseStatusEnum.GROUP_NOT_EXISTS);
        }
        GroupDetailMngVO groupDetailMngVO = (GroupDetailMngVO)ConvertUtil.convert((Object)group, GroupDetailMngVO.class);
        GroupMemberQuery groupMemberQuery = new GroupMemberQuery();
        groupMemberQuery.setGroupId(groupId);
        groupMemberQuery.getPage().setSortColumns(" gm.ORDERNUM ASC ");
        List groupMemberList = this.groupMemberPlusService.findAll(groupMemberQuery);
        if (!ListUtil.isNullorEmpty((List)groupMemberList)) {
            List groupMemberVOList = ConvertUtil.convert((List)groupMemberList, GroupMemberVO.class);
            for (GroupMemberVO groupMemberVO : groupMemberVOList) {
                if (groupMemberVO.getMembertype().intValue() == GroupMemberTypeEnum.USER.getValue().intValue()) {
                    groupMemberVO.setMemberName(UserCoreUtil.getUser(groupMemberVO.getMemberId()).getName());
                    continue;
                }
                if (groupMemberVO.getMembertype().intValue() != GroupMemberTypeEnum.ORG_NOT_INCLUDE_SUB.getValue().intValue() && groupMemberVO.getMembertype().intValue() != GroupMemberTypeEnum.ORG_INCLUDE_SUB.getValue().intValue()) continue;
                groupMemberVO.setMemberName(OrgUtil.getOrgVO(groupMemberVO.getMemberId()).getOrgname());
            }
            groupDetailMngVO.setGroupMemberList(groupMemberVOList);
        }
        GroupUserlistQuery groupUserlistQuery = new GroupUserlistQuery();
        groupUserlistQuery.setGroupId(groupId);
        groupUserlistQuery.getPage().setSortColumns(" gul.ORDERNUM ASC ");
        List groupUserlistList = this.groupUserlistPlusService.findAll(groupUserlistQuery);
        List<GroupUserlistVO> whiteList = groupUserlistList.stream().filter(groupUserlist -> groupUserlist.getType().intValue() == GroupUserlistTypeEnum.WHITE.getValue()).map(groupUserlist -> (GroupUserlistVO)ConvertUtil.convert((Object)groupUserlist, GroupUserlistVO.class)).collect(Collectors.toList());
        List<GroupUserlistVO> blackList = groupUserlistList.stream().filter(groupUserlist -> groupUserlist.getType().intValue() == GroupUserlistTypeEnum.BLACK.getValue()).map(groupUserlist -> (GroupUserlistVO)ConvertUtil.convert((Object)groupUserlist, GroupUserlistVO.class)).collect(Collectors.toList());
        if (!ListUtil.isNullorEmpty(whiteList)) {
            UserCoreUtil.setUserVO(whiteList, GroupUserlistVO::getUserId, GroupUserlistVO::setUserVO);
            groupDetailMngVO.setWhiteList(whiteList);
        }
        if (!ListUtil.isNullorEmpty(blackList)) {
            UserCoreUtil.setUserVO(blackList, GroupUserlistVO::getUserId, GroupUserlistVO::setUserVO);
            groupDetailMngVO.setBlackList(blackList);
        }
        return groupDetailMngVO;
    }

    @Override
    public Long txInsert(GroupBO groupBO, Long userId, Long mngDomainId) {
        if (groupBO.getGroupId() != null) {
            ExceptionUtil.handle((IRespStatusEnum)ResponseStatusEnum.GROUP_INSERT_GROUP_ID_IS_NOT_NULL);
        }
        this.validate(groupBO);
        Group group = (Group)ConvertUtil.convert((Object)groupBO, Group.class);
        group.setGroupId(IdUtil.getSequence((String)"TGROUP"));
        group.setDomainId(mngDomainId);
        group.setCreatorId(userId);
        group.setCreatedate(new Date());
        this.getTgroupPlusDao().insertSelective((BaseEntity)group);
        this.groupMemberPlusService.batchInsertBO(groupBO.getGroupMemberList(), group.getGroupId(), userId);
        this.insertUserList(groupBO, group.getGroupId(), userId);
        return group.getGroupId();
    }

    @Override
    public Integer txUpdate(GroupBO groupBO, Long userId, Long mngDomainId) {
        if (groupBO.getGroupId() == null) {
            ExceptionUtil.handle((IRespStatusEnum)ResponseStatusEnum.GROUP_UPDATE_GROUP_ID_IS_NULL);
        }
        this.validate(groupBO);
        Group oldGroup = (Group)this.getTgroupPlusDao().getById(groupBO.getGroupId());
        if (oldGroup == null) {
            ExceptionUtil.handle((IRespStatusEnum)ResponseStatusEnum.GROUP_NOT_EXISTS);
        }
        Group group = (Group)ConvertUtil.convert((Object)groupBO, Group.class);
        group.setUpdaterId(userId);
        group.setUpdatedate(new Date());
        group.setSyncstatus(0);
        int updateNum = this.getTgroupPlusDao().updateSelective(group);
        this.groupMemberPlusService.deleteByGroupId(group.getGroupId());
        this.groupMemberPlusService.batchInsertBO(groupBO.getGroupMemberList(), group.getGroupId(), userId);
        this.groupUserlistPlusService.deleteByGroupIdAndType(group.getGroupId(), null);
        this.insertUserList(groupBO, group.getGroupId(), userId);
        return updateNum;
    }

    @Override
    public Integer txDelete(Long groupId, Long userId) {
        Group group = (Group)this.getTgroupPlusDao().getById(groupId);
        if (group == null) {
            ExceptionUtil.handle((IRespStatusEnum)ResponseStatusEnum.GROUP_NOT_EXISTS);
        }
        group.setDeleted(1);
        group.setDeletedate(new Date());
        return this.getTgroupPlusDao().updateSelective(group);
    }

    @Override
    public boolean useGroup(Long groupId, String desc, Long userId) {
        Group group = (Group)this.getTgroupPlusDao().getById(groupId);
        String whereused = group.getWhereused();
        if (StringUtil.isNullorEmptyStr((String)whereused)) {
            whereused = desc;
        } else {
            String[] array = whereused.split(",");
            if (array.length >= MAX_WHEREUSED) {
                return false;
            }
            whereused = whereused + "," + desc;
        }
        group.setWhereused(whereused);
        group.setUpdaterId(userId);
        group.setUpdatedate(new Date());
        this.getTgroupPlusDao().updateSelective(group);
        return true;
    }

    @Override
    public ExcelResultVO importGroupMemberOrgList(MultipartFile groupMemberOrgExcelFile, Long groupId, Long userId) throws Exception {
        UploadFile uploadFile = UploadFileUtil.upload((MultipartFile)groupMemberOrgExcelFile, (String)"groupimpexcel/", (boolean)false);
        String excelfilepath = AppPathUtil.getResourceLocalPath() + uploadFile.getFullpath();
        ExcelReadUtil excelReadUtil = new ExcelReadUtil();
        try {
            List readDataList;
            int firstDataRowIndex = 2;
            for (int pageNumber = 1; (readDataList = excelReadUtil.getExcelReadData(excelfilepath, GroupMemberOrgImportExcelModel.class, firstDataRowIndex, pageNumber)) != null && readDataList.size() != 0 && pageNumber <= 5000; ++pageNumber) {
                class ExcelData {
                    GroupMemberOrgImportExcelModel groupMemberOrgImportExcelModel;
                    Integer pageNumber;
                    Integer rowIndex;

                    ExcelData(GroupMemberOrgImportExcelModel groupMemberOrgImportExcelModel, Integer pageNumber, Integer rowIndex) {
                        this.groupMemberOrgImportExcelModel = groupMemberOrgImportExcelModel;
                        this.pageNumber = pageNumber;
                        this.rowIndex = rowIndex;
                    }
                }
                HashMap<String, ArrayList<ExcelData>> orgcodeMap = new HashMap<String, ArrayList<ExcelData>>();
                for (int rowIndex = 0; rowIndex < readDataList.size(); ++rowIndex) {
                    GroupMemberOrgImportExcelModel groupMemberOrgImportExcelModel = (GroupMemberOrgImportExcelModel)((Object)readDataList.get(rowIndex));
                    try {
                        String orgcode = groupMemberOrgImportExcelModel.getOrgcode();
                        ArrayList<ExcelData> excelDataList = (ArrayList<ExcelData>)orgcodeMap.get(orgcode);
                        if (excelDataList == null) {
                            excelDataList = new ArrayList<ExcelData>();
                        }
                        excelDataList.add(new ExcelData(groupMemberOrgImportExcelModel, pageNumber, rowIndex));
                        orgcodeMap.put(orgcode, excelDataList);
                        continue;
                    }
                    catch (Exception e) {
                        groupMemberOrgImportExcelModel.setExcelImportErrorMessage("\u8bfb\u53d6\u90e8\u95e8\u7f16\u7801\u5931\u8d25");
                        excelReadUtil.addReadErrorData((Object)groupMemberOrgImportExcelModel, pageNumber, rowIndex);
                    }
                }
                List<Org> orgList = this.orgPlusDao.getListByOrgCodeList(orgcodeMap.keySet().stream().collect(Collectors.toList()));
                Map<String, Org> orgMap = orgList.stream().collect(Collectors.toMap(Org::getOrgcode, org -> org));
                ArrayList<Long> memberIdList = new ArrayList<Long>();
                for (Map.Entry entry : orgcodeMap.entrySet()) {
                    Org org2 = orgMap.get(entry.getKey());
                    if (org2 == null) {
                        ((List)entry.getValue()).stream().forEach(excelData -> {
                            excelData.groupMemberOrgImportExcelModel.setExcelImportErrorMessage("\u90e8\u95e8\u7f16\u7801\u5bf9\u5e94\u7684\u90e8\u95e8\u4e0d\u5b58\u5728");
                            excelReadUtil.addReadErrorData((Object)excelData.groupMemberOrgImportExcelModel, excelData.pageNumber.intValue(), excelData.rowIndex.intValue());
                        });
                        continue;
                    }
                    memberIdList.add(org2.getOrgId());
                }
                this.groupMemberPlusService.batchInsertNotExistList(memberIdList, groupId, userId, 1);
            }
        }
        catch (PrdBaseException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        ExcelResultVO excelResultVO = excelReadUtil.getExcelResultVO(GroupMemberOrgImportExcelModel.class);
        return excelResultVO;
    }

    @Override
    public ExcelResultVO importGroupMemberUserList(MultipartFile groupMemberUserExcelFile, Long groupId, Long userId) throws Exception {
        UploadFile uploadFile = UploadFileUtil.upload((MultipartFile)groupMemberUserExcelFile, (String)"groupimpexcel/", (boolean)false);
        String excelfilepath = AppPathUtil.getResourceLocalPath() + uploadFile.getFullpath();
        ExcelReadUtil excelReadUtil = new ExcelReadUtil();
        try {
            List readDataList;
            int firstDataRowIndex = 2;
            for (int pageNumber = 1; (readDataList = excelReadUtil.getExcelReadData(excelfilepath, GroupMemberUserImportExcelModel.class, firstDataRowIndex, pageNumber)) != null && readDataList.size() != 0 && pageNumber <= 5000; ++pageNumber) {
                class ExcelData {
                    GroupMemberUserImportExcelModel groupMemberUserImportExcelModel;
                    Integer pageNumber;
                    Integer rowIndex;

                    ExcelData(GroupMemberUserImportExcelModel groupMemberUserImportExcelModel, Integer pageNumber, Integer rowIndex) {
                        this.groupMemberUserImportExcelModel = groupMemberUserImportExcelModel;
                        this.pageNumber = pageNumber;
                        this.rowIndex = rowIndex;
                    }
                }
                HashMap<String, ArrayList<ExcelData>> usernameMap = new HashMap<String, ArrayList<ExcelData>>();
                for (int rowIndex = 0; rowIndex < readDataList.size(); ++rowIndex) {
                    GroupMemberUserImportExcelModel groupMemberUserImportExcelModel = (GroupMemberUserImportExcelModel)((Object)readDataList.get(rowIndex));
                    try {
                        String orgcode = groupMemberUserImportExcelModel.getUsername();
                        ArrayList<ExcelData> excelDataList = (ArrayList<ExcelData>)usernameMap.get(orgcode);
                        if (excelDataList == null) {
                            excelDataList = new ArrayList<ExcelData>();
                        }
                        excelDataList.add(new ExcelData(groupMemberUserImportExcelModel, pageNumber, rowIndex));
                        usernameMap.put(orgcode, excelDataList);
                        continue;
                    }
                    catch (Exception e) {
                        groupMemberUserImportExcelModel.setExcelImportErrorMessage("\u8bfb\u53d6\u7528\u6237\u540d\u5931\u8d25");
                        excelReadUtil.addReadErrorData((Object)groupMemberUserImportExcelModel, pageNumber, rowIndex);
                    }
                }
                List<User> userList = this.userPlusDao.getListByUsernameList(usernameMap.keySet().stream().collect(Collectors.toList()));
                Map<String, User> userMap = userList.stream().collect(Collectors.toMap(User::getUsername, user -> user));
                ArrayList<Long> memberIdList = new ArrayList<Long>();
                for (Map.Entry entry : usernameMap.entrySet()) {
                    User user2 = userMap.get(entry.getKey());
                    if (user2 == null) {
                        ((List)entry.getValue()).stream().forEach(excelData -> {
                            excelData.groupMemberUserImportExcelModel.setExcelImportErrorMessage("\u7528\u6237\u540d\u5bf9\u5e94\u7684\u7528\u6237\u4e0d\u5b58\u5728");
                            excelReadUtil.addReadErrorData((Object)excelData.groupMemberUserImportExcelModel, excelData.pageNumber.intValue(), excelData.rowIndex.intValue());
                        });
                        continue;
                    }
                    memberIdList.add(user2.getUserId());
                }
                this.groupMemberPlusService.batchInsertNotExistList(memberIdList, groupId, userId, 0);
            }
        }
        catch (PrdBaseException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        ExcelResultVO excelResultVO = excelReadUtil.getExcelResultVO(GroupMemberUserImportExcelModel.class);
        return excelResultVO;
    }

    @Override
    public boolean isInGroup(Long userId, List<Long> groupIdList) {
        if (ListUtil.isNullorEmpty(groupIdList)) {
            return false;
        }
        if (this.groupUserlistPlusService.isInGroupUserlist(userId, groupIdList, GroupUserlistTypeEnum.BLACK.getValue())) {
            return false;
        }
        if (this.groupUserlistPlusService.isInGroupUserlist(userId, groupIdList, GroupUserlistTypeEnum.WHITE.getValue())) {
            return true;
        }
        return this.groupMemberPlusService.isInScope(userId, groupIdList);
    }

    private int insertUserList(GroupBO groupBO, Long groupId, Long userId) {
        int updateNum = 0;
        if (!ListUtil.isNullorEmpty(groupBO.getBlackList())) {
            updateNum += this.groupUserlistPlusService.batchInsert(groupBO.getBlackList(), groupId, userId);
        }
        if (groupBO.getType() == 1 && !ListUtil.isNullorEmpty(groupBO.getWhiteList())) {
            updateNum += this.groupUserlistPlusService.batchInsert(groupBO.getWhiteList(), groupId, userId);
        }
        return updateNum;
    }

    private void validate(GroupBO groupBO) {
        if (groupBO == null) {
            return;
        }
        if (!ListUtil.isNullorEmpty(groupBO.getWhiteList())) {
            for (GroupUserlistBO groupUserlistBO : groupBO.getWhiteList()) {
                if (groupUserlistBO.getType() == 0) continue;
                ExceptionUtil.handle((IRespStatusEnum)ResponseStatusEnum.GROUP_WHITELIST_TYPE_INVALID);
            }
        }
        if (!ListUtil.isNullorEmpty(groupBO.getBlackList())) {
            for (GroupUserlistBO groupUserlistBO : groupBO.getBlackList()) {
                if (groupUserlistBO.getType() == 1) continue;
                ExceptionUtil.handle((IRespStatusEnum)ResponseStatusEnum.GROUP_BLACKLIST_TYPE_INVALID);
            }
        }
        if (groupBO.getType() == 0) {
            if (!ListUtil.isNullorEmpty(groupBO.getWhiteList())) {
                ExceptionUtil.handle((IRespStatusEnum)ResponseStatusEnum.GROUP_COMMON_CONTAINS_WHITELIST);
            }
            if (!StringUtil.isNullorEmptyStr((String)groupBO.getMatchrule())) {
                ExceptionUtil.handle((IRespStatusEnum)ResponseStatusEnum.GROUP_COMMON_CONTAINS_MATCHRULE);
            }
        }
    }
}

