/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.appsecurity.org.service.imple;

import com.alibaba.fastjson.JSONObject;
import com.peak.common.util.AppPathUtil;
import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.ListUtil;
import com.peak.common.util.SpringUtil;
import com.peak.common.util.StringUtil;
import com.peak.common.util.UploadFileUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.framework.common.jdbc.IPrimaryKey;
import com.peak.prd.appsecurity.domain.bo.DomainBO;
import com.peak.prd.appsecurity.domain.bo.DomainSelectBO;
import com.peak.prd.appsecurity.domain.model.Domain;
import com.peak.prd.appsecurity.domain.service.IDomainPlusService;
import com.peak.prd.appsecurity.domain.vo.DomainDetailMngVO;
import com.peak.prd.appsecurity.org.bo.OrgBO;
import com.peak.prd.appsecurity.org.dao.IOrgPlusDao;
import com.peak.prd.appsecurity.org.model.Org;
import com.peak.prd.appsecurity.org.model.OrgImportExcelModel;
import com.peak.prd.appsecurity.org.model.Orgexpand;
import com.peak.prd.appsecurity.org.model.Orgtree;
import com.peak.prd.appsecurity.org.service.IOrgPlusService;
import com.peak.prd.appsecurity.org.service.IOrgexpandPlusService;
import com.peak.prd.appsecurity.org.service.IOrgtreePlusService;
import com.peak.prd.appsecurity.org.util.OrgUtil;
import com.peak.prd.appsecurity.org.vo.OrgAddressVO;
import com.peak.prd.appsecurity.org.vo.OrgDetailMngVO;
import com.peak.prd.appsecurity.org.vo.OrgMiniVO;
import com.peak.prd.appsecurity.org.vo.OrgMngVO;
import com.peak.prd.appsecurity.org.vo.OrgQuery;
import com.peak.prd.appsecurity.org.vo.OrgVO;
import com.peak.prd.appsecurity.user.service.IUserOrgPlusService;
import com.peak.prd.appsecurity.user.util.UserCoreUtil;
import com.peak.prd.base.annotation.ClearCache;
import com.peak.prd.base.model.IRespStatusEnum;
import com.peak.prd.base.model.UploadFile;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.base.util.ExceptionUtil;
import com.peak.prd.common.appdict.service.imple.AppdictPlusService;
import com.peak.prd.common.appdict.vo.AppdictVO;
import com.peak.prd.common.rule.UserFilterRuleUtil;
import com.peak.prd.config.AppCommonConfig;
import com.peak.prd.enums.CoreResponseStatusEnum;
import com.peak.prd.enums.CreateWayEnum;
import com.peak.prd.enums.LinktypeEnum;
import com.peak.prd.enums.SysInitData;
import com.peak.prd.enums.UpDownRelationEnum;
import com.peak.prd.exception.PrdBaseException;
import com.peak.prd.messageq.util.MessageQHelper;
import com.peak.tools.easyexcel.model.ExcelResultVO;
import com.peak.tools.easyexcel.util.ExcelReadUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@CacheConfig(cacheNames={"prd"})
public class OrgPlusService
extends PrdBaseService<Org, Long, OrgQuery>
implements IOrgPlusService {
    private static final Logger log = LoggerFactory.getLogger(OrgPlusService.class);
    @Resource
    @Lazy
    private IOrgPlusService self;
    @Autowired
    private IOrgexpandPlusService orgexpandPlusService;
    @Resource
    @Lazy
    private IUserOrgPlusService userOrgPlusService;
    private IOrgPlusDao orgPlusDao;
    @Autowired
    private IOrgtreePlusService orgtreePlusService;
    @Autowired
    private IDomainPlusService domainPlusService;
    @Autowired
    private AppdictPlusService appdictPlusService;

    public void setOrgPlusDao(IOrgPlusDao dao) {
        this.orgPlusDao = dao;
    }

    public IOrgPlusDao getOrgPlusDao() {
        return this.orgPlusDao;
    }

    public IEntityDao<Org, Long, OrgQuery> getEntityDao() {
        return this.orgPlusDao;
    }

    @Override
    public OrgVO getOrgVO(Long orgId) {
        return (OrgVO)this.findVOById(orgId, OrgVO.class);
    }

    @Override
    public void updateSynflag(Integer synflag) {
        this.orgPlusDao.updateSynflag(synflag);
    }

    @Override
    @Cacheable
    public List<Org> findCorpDomainList() {
        OrgQuery query = new OrgQuery();
        query.setIsdomain(1);
        query.setIscorpdomain(1);
        query.setDeleted(0);
        return this.orgPlusDao.findAll(query);
    }

    @Override
    @Cacheable
    public OrgAddressVO getAddressVOById(Long orgId) {
        if (orgId == null) {
            return null;
        }
        Org org = (Org)((IOrgPlusService)SpringUtil.getBean(IOrgPlusService.class)).findById(orgId);
        if (org == null) {
            return null;
        }
        OrgAddressVO vo = (OrgAddressVO)ConvertUtil.convert((Object)org, OrgAddressVO.class);
        vo.setProvince((AppdictVO)this.appdictPlusService.findVOById(org.getProvince(), AppdictVO.class));
        vo.setCity((AppdictVO)this.appdictPlusService.findVOById(org.getCity(), AppdictVO.class));
        return vo;
    }

    @Override
    public Long insertEnterprise(@NotNull String enterpriseName, @NotNull Long parentId) {
        Long enterpriseId;
        Date now = new Date();
        try {
            enterpriseId = IPrimaryKey.DEFAULT.getSequence("TORG");
        }
        catch (SQLException e) {
            throw new RuntimeException("primary key");
        }
        Org org = new Org(enterpriseId);
        org.setGkey(UUID.randomUUID().toString().replaceAll("-", ""));
        org.setOrgcode(enterpriseId.toString());
        org.setOrgname(enterpriseName);
        org.setEnterpriseId(enterpriseId);
        org.setIsdomain(1);
        org.setIsvirtual(0);
        org.setIscorpdomain(1);
        org.setCreatedate(now);
        org.setDeleted(0);
        org.setIscorpdomain(1);
        this.insert((BaseEntity)org);
        Domain dm = new Domain(enterpriseId);
        this.domainPlusService.insert((BaseEntity)dm);
        Orgtree ot = new Orgtree();
        ot.setOrgId(enterpriseId);
        ot.setParentId(parentId);
        ot.setLinktype(0);
        ot.setCreatedate(now);
        this.orgtreePlusService.insert((BaseEntity)ot);
        return enterpriseId;
    }

    @Override
    @Cacheable
    public List<OrgVO> findSon(Long parentId) {
        List<Long> orgIds = this.getSonOrgIds(parentId);
        if (ListUtil.isNullorEmpty(orgIds)) {
            return new ArrayList<OrgVO>();
        }
        List orgVOList = this.findVOsByIds(orgIds, OrgVO.class);
        Org org = (Org)this.findById(parentId);
        if (org.getIsvirtual() == 0) {
            orgVOList = orgVOList.stream().filter(e -> e.getIsvirtual() == 0).collect(Collectors.toList());
        }
        ConvertUtil.setProperties((List)orgVOList, e -> e.setIsleaf(e.getIsqueryorgleaf()));
        return orgVOList;
    }

    private Integer getIsleafOrg(Long orgId) {
        List<Long> orgIds = this.getSonOrgIds(orgId);
        if (ListUtil.isNullorEmpty(orgIds)) {
            return 1;
        }
        return 0;
    }

    private List<Long> getSonOrgIds(Long parentId) {
        Domain domain;
        Org org = (Org)this.getById(parentId);
        ArrayList<Long> orgIds = new ArrayList();
        if (org.getIsvirtual() == 1 && ((domain = (Domain)this.domainPlusService.getById(parentId)).getFilteruseron() == null || domain.getFilteruseron() == 0)) {
            orgIds = this.orgtreePlusService.findMngRealorgIds(parentId);
        }
        List<Orgtree> orgtrees = this.orgtreePlusService.findAllSon(parentId);
        List sonOrgIds = IdUtil.getIds(orgtrees, Orgtree::getOrgId);
        orgIds.addAll(sonOrgIds);
        orgIds = ListUtil.removeDuplicate(orgIds);
        return orgIds;
    }

    @Override
    public List<OrgMiniVO> miniSearch(Long domainId, String orgname) {
        Org org = (Org)this.findById(domainId);
        List<Orgexpand> orgexpands = org.getIsvirtual() == 1 ? this.orgexpandPlusService.getIdPath(domainId, orgname) : this.orgexpandPlusService.getRealOrgIdPath(domainId, orgname);
        return this.getOrgMiniVOS(domainId, orgexpands);
    }

    private List<OrgMiniVO> getOrgMiniVOS(Long domainId, List<Orgexpand> orgexpands) {
        if (ListUtil.isNullorEmpty(orgexpands)) {
            return new ArrayList<OrgMiniVO>();
        }
        List orgIds = new ArrayList();
        for (Orgexpand orgexpand : orgexpands) {
            String idpath = orgexpand.getIdpath();
            orgIds.addAll(StringUtil.splitToLongList((String)idpath, (String)","));
        }
        orgIds = ListUtil.removeDuplicate(orgIds);
        List<Orgtree> orgtrees = this.orgtreePlusService.getByOrgIds(orgIds);
        List orgMiniVOS = ConvertUtil.convert(orgtrees, OrgMiniVO.class);
        orgIds = IdUtil.getIds(orgtrees, Orgtree::getOrgId);
        List orgs = this.findByIds(orgIds);
        ConvertUtil.setProperties((List)orgMiniVOS, (List)orgs, (e, p) -> e.setOrgname(p.getOrgname()));
        OrgVO orgVO = this.getVOById(domainId, OrgVO.class);
        return ListUtil.convertToTree((List)orgMiniVOS, (Long)orgVO.getParentId(), OrgMiniVO::getOrgId, OrgMiniVO::getParentId, OrgMiniVO::getChildren, OrgMiniVO::setChildren);
    }

    @Override
    public List<OrgMngVO> getRealSon(Long parentId) {
        List<Orgtree> orgtrees = this.orgtreePlusService.getSon(parentId, 0);
        if (ListUtil.isNullorEmpty(orgtrees)) {
            return new ArrayList<OrgMngVO>();
        }
        List orgIds = IdUtil.getIds(orgtrees, Orgtree::getOrgId);
        List orgs = this.findByIds(orgIds);
        if (ListUtil.isNullorEmpty(orgs = orgs.stream().filter(e -> e.getIsvirtual() == 0).collect(Collectors.toList()))) {
            return new ArrayList<OrgMngVO>();
        }
        List orgMngVOS = ConvertUtil.convert(orgs, OrgMngVO.class);
        this.setOrgMngVOParentIdOrdernum(orgMngVOS, orgtrees);
        UserCoreUtil.setUserVO(orgMngVOS, OrgMngVO::getCreatorId, OrgMngVO::setUserVO);
        ConvertUtil.setProperties((List)orgMngVOS, orgs, (e, p) -> e.setIsleaf(p.getIsrealorgleaf()));
        return orgMngVOS;
    }

    private Integer getIsleafRealOrg(Long orgId) {
        List<Orgtree> orgtrees = this.orgtreePlusService.getSon(orgId, 0);
        if (ListUtil.isNullorEmpty(orgtrees)) {
            return 1;
        }
        List orgIds = IdUtil.getIds(orgtrees, Orgtree::getOrgId);
        List orgs = this.getByIds(orgIds);
        if (ListUtil.isNullorEmpty(orgs = orgs.stream().filter(e -> e.getIsvirtual() == 0).collect(Collectors.toList()))) {
            return 1;
        }
        return 0;
    }

    @Override
    public OrgMngVO getOrgMngVO(Long orgId) {
        Org org = (Org)this.getById(orgId);
        return (OrgMngVO)ConvertUtil.convert((Object)org, OrgMngVO.class);
    }

    @Override
    public List<OrgVO> getCurMngDomainOrgRoot(Long domainId) {
        ArrayList<Long> orgIds = new ArrayList<Long>();
        Org org = (Org)this.findById(domainId);
        if (org.getMngorgId() == null) {
            orgIds.add(domainId);
        } else {
            orgIds.add(org.getMngorgId());
        }
        return this.findVOsByIds(orgIds, OrgVO.class);
    }

    @Override
    public List<OrgMngVO> searchRealOrg(Long domainId, String orgname) {
        List<Orgexpand> orgexpands = this.orgexpandPlusService.getRealOrgIdPath(domainId, orgname);
        if (ListUtil.isNullorEmpty(orgexpands)) {
            return new ArrayList<OrgMngVO>();
        }
        List orgIds = new ArrayList();
        for (Orgexpand orgexpand : orgexpands) {
            String idpath = orgexpand.getIdpath();
            orgIds.addAll(StringUtil.splitToLongList((String)idpath, (String)","));
        }
        orgIds = ListUtil.removeDuplicate(orgIds);
        List<Orgtree> orgtrees = this.orgtreePlusService.getByOrgIds(orgIds);
        List orgMngVOS = ConvertUtil.convert(orgtrees, OrgMngVO.class);
        orgIds = IdUtil.getIds(orgtrees, Orgtree::getOrgId);
        List orgs = this.findByIds(orgIds);
        ConvertUtil.setProperties((List)orgMngVOS, (List)orgs, (e, p) -> e.setOrgname(p.getOrgname()));
        ConvertUtil.setProperties((List)orgMngVOS, (List)orgs, (e, p) -> e.setOrgcode(p.getOrgcode()));
        ConvertUtil.setProperties((List)orgMngVOS, (List)orgs, (e, p) -> e.setIsvirtual(p.getIsvirtual()));
        orgMngVOS = orgMngVOS.stream().filter(e -> e.getIsvirtual() == 0).collect(Collectors.toList());
        OrgVO orgVO = this.getVOById(domainId, OrgVO.class);
        return ListUtil.convertToTree(orgMngVOS, (Long)orgVO.getParentId(), OrgMngVO::getOrgId, OrgMngVO::getParentId, OrgMngVO::getChildren, OrgMngVO::setChildren);
    }

    @Override
    @ClearCache(value="#orgBO.parentId")
    public Long txInsert(Long userId, OrgBO orgBO) {
        Long orgId = this.insertOrg(userId, orgBO, 0);
        this.domainPlusService.insert(orgId);
        this.orgtreePlusService.txInsertSelective(userId, orgId, orgBO.getParentId(), orgBO.getOrdernum(), LinktypeEnum.FATHER_AND_SON.getValue());
        Org orgParent = (Org)this.getById(orgBO.getParentId());
        this.setIsleaf(orgParent);
        return orgId;
    }

    private Long insertOrg(Long userId, OrgBO orgBO, Integer isVirtual) {
        this.checkOrgcode(orgBO.getOrgcode());
        Org orgParent = (Org)this.getById(orgBO.getParentId());
        if (orgBO.getParentcode() == null) {
            orgBO.setParentcode(orgParent.getOrgcode());
        }
        Org org = (Org)ConvertUtil.convert((Object)orgBO, Org.class);
        Long orgId = orgBO.getOrgId();
        if (orgId == null) {
            orgId = IdUtil.getSequence((String)"TORG");
        }
        org.setOrgId(orgId);
        org.setGkey(IdUtil.getGkey());
        org.setCreatorId(userId);
        org.setCreatedate(new Date());
        org.setDeleted(0);
        if (orgBO.getParentId().longValue() == SysInitData.ORG_ROOT.getValue() && orgBO.getParentId().longValue() != OrgUtil.getOrgRootId().longValue()) {
            org.setIscorpdomain(1);
            org.setEnterpriseId(orgId);
        } else {
            org.setEnterpriseId(orgParent.getEnterpriseId());
            org.setIscorpdomain(0);
        }
        org.setIsvirtual(isVirtual);
        org.setSynflag(0);
        org.setIsrealorgleaf(1);
        org.setIsdomainleaf(1);
        org.setIsqueryorgleaf(1);
        this.getOrgPlusDao().insertSelective((BaseEntity)org);
        return orgId;
    }

    private void checkOrgcode(String orgcode) {
        Org org = this.findOrgByOrgcode(orgcode);
        if (org != null) {
            ExceptionUtil.handle((IRespStatusEnum)CoreResponseStatusEnum.ORGCODE_SAME);
        }
    }

    @Override
    @ClearCache(keys={"#orgBO.orgId", "#orgBO.parentId"})
    public Integer txUpdate(Long userId, OrgBO orgBO) {
        Org oldOrg = (Org)this.getById(orgBO.getOrgId());
        if (oldOrg == null) {
            return 0;
        }
        Org org = (Org)ConvertUtil.convert((Object)orgBO, Org.class);
        String orgcode = orgBO.getOrgcode();
        if (!oldOrg.getOrgcode().equals(orgcode)) {
            this.checkOrgcode(orgcode);
        }
        this.orgtreePlusService.txUpdateSelective(org.getOrgId(), orgBO.getParentId(), orgBO.getOrdernum());
        OrgPlusService.handleZhonghuibaoxian(oldOrg, org);
        int row = this.getOrgPlusDao().updateSelective(org);
        if (org.getIsdomain() != null && oldOrg.getIsdomain().intValue() != org.getIsdomain().intValue()) {
            this.setIsleaf((Org)this.getById(orgBO.getParentId()));
        }
        return row;
    }

    private static void handleZhonghuibaoxian(Org oldOrg, Org org) {
        String oldcontack;
        AppCommonConfig config = (AppCommonConfig)SpringUtil.getBean(AppCommonConfig.class);
        String projectname = config.getProjectname();
        if (!projectname.trim().equals("zhonghuibaoxian")) {
            return;
        }
        String string = oldcontack = oldOrg.getContact() == null ? "" : oldOrg.getContact();
        if (oldcontack.equals(org.getContact())) {
            return;
        }
        if (org.getCreateway() == null || org.getCreateway().intValue() != CreateWayEnum.SYNC.getValue()) {
            org.setEmail("1");
        } else if (org.getCreateway().intValue() == CreateWayEnum.SYNC.getValue() && "1".equals(oldOrg.getEmail())) {
            org.setContact(oldOrg.getContact());
        }
    }

    @Override
    @ClearCache(value="#orgId")
    public Integer delete(Long orgId) {
        Org orgparent = this.getParentOrg(orgId);
        this.self.clearCache(orgparent.getOrgId());
        Org org = new Org();
        org.setOrgId(orgId);
        org.setDeleted(1);
        org.setDeletedate(new Date());
        int row = this.getOrgPlusDao().updateSelective(org);
        this.setIsleaf(orgparent);
        return row;
    }

    @Override
    public List<OrgMiniVO> searchDomainMini(Long domainId, String orgname) {
        List<Orgexpand> orgexpands = this.orgexpandPlusService.getDomainIdPath(domainId, orgname);
        return this.getOrgMiniVOS(domainId, orgexpands);
    }

    @Override
    @Cacheable
    public List<OrgMiniVO> findSonDomainMini(Long parentId) {
        List<Orgtree> orgtrees = this.orgtreePlusService.getDomainSon(parentId);
        if (ListUtil.isNullorEmpty(orgtrees)) {
            return new ArrayList<OrgMiniVO>();
        }
        List orgIds = IdUtil.getIds(orgtrees, Orgtree::getOrgId);
        List orgs = this.findByIds(orgIds);
        if (ListUtil.isNullorEmpty(orgs = orgs.stream().filter(e -> e.getIsdomain() == 1).collect(Collectors.toList()))) {
            return new ArrayList<OrgMiniVO>();
        }
        List orgMiniVOS = ConvertUtil.convert(orgs, OrgMiniVO.class);
        this.setOrgMiniVOParentId(orgMiniVOS, orgtrees);
        ConvertUtil.setProperties((List)orgMiniVOS, orgs, (e, p) -> e.setIsleaf(p.getIsdomainleaf()));
        return orgMiniVOS;
    }

    @Override
    public List<OrgMngVO> getSonDomain(Long parentId) {
        List<Orgtree> orgtrees = this.orgtreePlusService.getDomainSon(parentId);
        if (ListUtil.isNullorEmpty(orgtrees)) {
            return new ArrayList<OrgMngVO>();
        }
        List orgIds = IdUtil.getIds(orgtrees, Orgtree::getOrgId);
        List orgs = this.findByIds(orgIds);
        if (ListUtil.isNullorEmpty(orgs = orgs.stream().filter(e -> e.getIsdomain() == 1).collect(Collectors.toList()))) {
            return new ArrayList<OrgMngVO>();
        }
        List orgMngVOS = ConvertUtil.convert(orgs, OrgMngVO.class);
        this.setOrgMngVOParentIdOrdernum(orgMngVOS, orgtrees);
        UserCoreUtil.setUserVO(orgMngVOS, OrgMngVO::getCreatorId, OrgMngVO::setUserVO);
        Org parentOrg = (Org)this.findById(parentId);
        if (parentOrg.getIsvirtual() == 1) {
            ConvertUtil.setProperties((List)orgMngVOS, e -> e.setIsdelete(1));
        }
        ConvertUtil.setProperties((List)orgMngVOS, orgs, (e, p) -> e.setIsleaf(p.getIsdomainleaf()));
        return orgMngVOS;
    }

    private Integer getIsleafDomain(Long orgId) {
        List<Orgtree> orgtrees = this.orgtreePlusService.getDomainSon(orgId);
        if (ListUtil.isNullorEmpty(orgtrees)) {
            return 1;
        }
        List orgIds = IdUtil.getIds(orgtrees, Orgtree::getOrgId);
        List orgs = this.getByIds(orgIds);
        if (ListUtil.isNullorEmpty(orgs = orgs.stream().filter(e -> e.getIsdomain() == 1).collect(Collectors.toList()))) {
            return 1;
        }
        return 0;
    }

    @Override
    public List<OrgMngVO> searchDomain(Long domainId, String orgname) {
        List<Orgexpand> orgexpands = this.orgexpandPlusService.getDomainIdPath(domainId, orgname);
        if (ListUtil.isNullorEmpty(orgexpands)) {
            return new ArrayList<OrgMngVO>();
        }
        List orgIds = new ArrayList();
        for (Orgexpand orgexpand : orgexpands) {
            String idpath = orgexpand.getIdpath();
            orgIds.addAll(StringUtil.splitToLongList((String)idpath, (String)","));
        }
        orgIds = ListUtil.removeDuplicate(orgIds);
        List<Orgtree> orgtrees = this.orgtreePlusService.getByOrgIds(orgIds);
        List orgMngVOS = ConvertUtil.convert(orgtrees, OrgMngVO.class);
        orgIds = IdUtil.getIds(orgtrees, Orgtree::getOrgId);
        List orgs = this.findByIds(orgIds);
        ConvertUtil.setProperties((List)orgMngVOS, (List)orgs, (e, p) -> e.setOrgname(p.getOrgname()));
        ConvertUtil.setProperties((List)orgMngVOS, (List)orgs, (e, p) -> e.setOrgcode(p.getOrgcode()));
        ConvertUtil.setProperties((List)orgMngVOS, (List)orgs, (e, p) -> e.setIsvirtual(p.getIsvirtual()));
        UserCoreUtil.setUserVO(orgMngVOS, OrgMngVO::getCreatorId, OrgMngVO::setUserVO);
        OrgVO orgVO = this.getVOById(domainId, OrgVO.class);
        return ListUtil.convertToTree((List)orgMngVOS, (Long)orgVO.getParentId(), OrgMngVO::getOrgId, OrgMngVO::getParentId, OrgMngVO::getChildren, OrgMngVO::setChildren);
    }

    @Override
    public OrgDetailMngVO getMngInfo(Long orgId) {
        Org orgparent;
        Org org = (Org)this.getById(orgId);
        if (org == null) {
            return new OrgDetailMngVO();
        }
        OrgDetailMngVO orgDetailMngVO = (OrgDetailMngVO)ConvertUtil.convert((Object)org, OrgDetailMngVO.class);
        List<Orgtree> orgtrees = this.orgtreePlusService.getByOrgIdLinktype(orgId, 0);
        if (ListUtil.notNullorEmpty(orgtrees)) {
            orgDetailMngVO.setParentId(orgtrees.get(0).getParentId());
            orgDetailMngVO.setOrdernum(orgtrees.get(0).getOrdernum());
        }
        if ((orgparent = (Org)this.findById(orgDetailMngVO.getParentId())) != null) {
            orgDetailMngVO.setParentname(orgparent.getOrgname());
        }
        if (org.getMngorgId() != null) {
            Org mngOrg = (Org)this.findById(org.getMngorgId());
            orgDetailMngVO.setMngorgname(mngOrg.getOrgname());
        }
        return orgDetailMngVO;
    }

    @Override
    @Cacheable
    public Org findParentDomain(Long orgId) {
        Org org = this.getParentOrg(orgId);
        if (org == null) {
            return null;
        }
        if (org.getIsdomain() == 1) {
            return org;
        }
        return this.findParentDomain(org.getOrgId());
    }

    private Org getParentOrg(Long orgId) {
        if (orgId.longValue() == SysInitData.ORG_ROOT.getValue()) {
            return null;
        }
        List<Orgtree> orgtreeList = this.orgtreePlusService.getByOrgIdLinktype(orgId, LinktypeEnum.FATHER_AND_SON.getValue());
        if (!ListUtil.notNullorEmpty(orgtreeList)) {
            return null;
        }
        Orgtree orgtree = orgtreeList.get(0);
        Org org = (Org)this.getById(orgtree.getParentId());
        return org;
    }

    @Override
    @ClearCache(value="#domainBO.parentId")
    public Long insertDomain(Long userId, DomainBO domainBO) {
        OrgBO orgBO = (OrgBO)ConvertUtil.convert((Object)domainBO, OrgBO.class);
        orgBO.setIsdomain(1);
        Long orgId = this.insertOrg(userId, orgBO, 1);
        this.orgtreePlusService.txInsertSelective(userId, orgId, domainBO.getParentId(), domainBO.getOrdernum(), LinktypeEnum.FATHER_AND_SON.getValue());
        Domain domain = (Domain)ConvertUtil.convert((Object)domainBO, Domain.class);
        domain.setDomainId(orgId);
        if (domain.getFilteruseron() == 1) {
            domain.setRulesql(UserFilterRuleUtil.getSQL(domain.getFilteruserrule()));
        }
        this.domainPlusService.insertSelective((BaseEntity)domain);
        AtomicInteger ordernum = new AtomicInteger();
        domainBO.getMngOrgIdList().forEach(mngOrgId -> {
            ordernum.getAndIncrement();
            this.orgtreePlusService.txInsertSelective(userId, (Long)mngOrgId, orgId, ordernum.intValue(), LinktypeEnum.CONTAIN.getValue());
        });
        Org org = (Org)this.getById(orgId);
        this.setIsleaf(org);
        Org orgParent = (Org)this.getById(orgBO.getParentId());
        this.setIsleaf(orgParent);
        JSONObject jObj = new JSONObject();
        jObj.put("domainId", (Object)orgId);
        MessageQHelper.send("domain", orgId, "add", jObj);
        return orgId;
    }

    @Override
    @ClearCache(value="#domainSelectBO.parentId")
    public void insertSelectDomain(Long userId, DomainSelectBO domainSelectBO) {
        this.orgtreePlusService.txInsertSelectDomain(userId, domainSelectBO.getOrgId(), domainSelectBO.getParentId(), domainSelectBO.getOrdernum(), LinktypeEnum.SELECT_SON.getValue());
        Org orgParent = (Org)this.getById(domainSelectBO.getParentId());
        this.setIsleaf(orgParent);
        JSONObject jObj = new JSONObject();
        jObj.put("domainId", (Object)domainSelectBO.getOrgId());
        MessageQHelper.send("domain", domainSelectBO.getOrgId(), "selectadd", jObj);
    }

    @Override
    public Org findOrgByOrgcode(String orgcode) {
        return this.getOrgPlusDao().findOrgByOrgcode(orgcode);
    }

    @Override
    @ClearCache(value="#domainBO.orgId")
    public Integer updateDomain(Long userId, DomainBO domainBO) {
        boolean isSendMQ;
        Domain oldDomain = (Domain)this.domainPlusService.getById(domainBO.getOrgId());
        if (oldDomain == null) {
            return 0;
        }
        OrgBO orgBO = (OrgBO)ConvertUtil.convert((Object)domainBO, OrgBO.class);
        this.txUpdate(userId, orgBO);
        int updateNum = this.domainPlusService.updateSelective(domainBO);
        int rowUpdateDomainRange = this.orgtreePlusService.txUpdateDomainRange(userId, domainBO.getOrgId(), domainBO.getMngOrgIdList());
        Org org = (Org)this.getById(orgBO.getOrgId());
        this.setIsleaf(org);
        boolean bl = isSendMQ = oldDomain.getFilteruseron().intValue() != domainBO.getFilteruseron().intValue() || oldDomain.getFilteruserrule() == null && domainBO.getFilteruserrule() != null || oldDomain.getFilteruserrule() != null && !oldDomain.getFilteruserrule().equals(domainBO.getFilteruserrule()) || rowUpdateDomainRange > 0;
        if (isSendMQ) {
            JSONObject jObj = new JSONObject();
            jObj.put("domainId", (Object)domainBO.getOrgId());
            MessageQHelper.send("domain", domainBO.getOrgId(), "update", jObj);
        }
        return updateNum;
    }

    @Override
    @ClearCache(value="#orgId")
    public Integer txDeleteDomain(Long orgId) {
        Org parentOrg = this.getParentOrg(orgId);
        this.self.clearCache(parentOrg.getOrgId());
        Org org = new Org();
        org.setOrgId(orgId);
        org.setDeleted(1);
        org.setDeletedate(new Date());
        int row = this.getOrgPlusDao().updateSelective(org);
        this.setIsleaf(parentOrg);
        return row;
    }

    @Override
    public DomainDetailMngVO getDomainMngInfo(Long orgId) {
        OrgDetailMngVO orgDetailMngVO = this.getMngInfo(orgId);
        DomainDetailMngVO domainDetailMngVO = (DomainDetailMngVO)ConvertUtil.convert((Object)orgDetailMngVO, DomainDetailMngVO.class);
        Domain domain = (Domain)this.domainPlusService.getById(orgId);
        ConvertUtil.copyProperties((Object)domain, (Object)domainDetailMngVO);
        List<Orgtree> orgtreeList = this.orgtreePlusService.getSon(orgId, LinktypeEnum.CONTAIN.getValue());
        List orgIdList = IdUtil.getIds(orgtreeList, Orgtree::getOrgId);
        domainDetailMngVO.setOrgVOList(this.self.findVOsByIds(orgIdList, OrgVO.class));
        return domainDetailMngVO;
    }

    private void setOrgMngVOParentIdOrdernum(List<OrgMngVO> orgMngVOS, List<Orgtree> orgtrees) {
        Map OrgtreeMap = ConvertUtil.listToMap(orgtrees, Orgtree::getOrgId);
        for (OrgMngVO orgMngVO : orgMngVOS) {
            orgMngVO.setParentId(((Orgtree)OrgtreeMap.get(orgMngVO.getOrgId())).getParentId());
            orgMngVO.setOrdernum(((Orgtree)OrgtreeMap.get(orgMngVO.getOrgId())).getOrdernum());
        }
    }

    private void setOrgMiniVOParentId(List<OrgMiniVO> orgMiniVOS, List<Orgtree> orgtrees) {
        Map OrgtreeMap = ConvertUtil.listToMap(orgtrees, Orgtree::getOrgId);
        for (OrgMiniVO orgMiniVO : orgMiniVOS) {
            orgMiniVO.setParentId(((Orgtree)OrgtreeMap.get(orgMiniVO.getOrgId())).getParentId());
        }
    }

    @Override
    public long count(Long enterpriseId) {
        OrgQuery query = new OrgQuery();
        query.setEnterpriseId(enterpriseId);
        query.setDeleted(0);
        return this.getOrgPlusDao().count(query);
    }

    @Override
    public Integer insertCheckOrgcode(String orgcode) {
        Org org = this.findOrgByOrgcode(orgcode);
        if (org != null) {
            return 0;
        }
        return 1;
    }

    @Override
    public Integer updateCheckOrgcode(Long orgId, String orgcode) {
        Org org = this.findOrgByOrgcode(orgcode);
        if (org != null && org.getOrgId().longValue() != orgId.longValue()) {
            return 0;
        }
        return 1;
    }

    @Caching(evict={@CacheEvict(cacheNames={"prd"}, key="'OrgPlusService:' + #orgId"), @CacheEvict(cacheNames={"prd"}, key="'OrgPlusService:OrgVO:' + #orgId"), @CacheEvict(cacheNames={"prd"}, key="'OrgPlusService:OrgMiniVO:' + #orgId"), @CacheEvict(cacheNames={"prd"}, key="'OrgPlusService:findCorpDomainList:'"), @CacheEvict(cacheNames={"prd"}, key="'OrgPlusService:findSon:' + #orgId"), @CacheEvict(cacheNames={"prd"}, key="'OrgPlusService:getRealSon:' + #orgId"), @CacheEvict(cacheNames={"prd"}, key="'OrgPlusService:findSonDomainMini:' + #orgId"), @CacheEvict(cacheNames={"prd"}, key="'OrgPlusService:getSonDomain:' + #orgId"), @CacheEvict(cacheNames={"prd"}, key="'OrgPlusService:findParentDomain:' + #orgId"), @CacheEvict(cacheNames={"prd"}, key="'OrgPlusService:getOrgIdFullpath:' + #orgId"), @CacheEvict(cacheNames={"prd"}, key="'OrgPlusService:getAllUpOrgIds:' + #orgId")})
    public void clearCache(Long orgId) {
    }

    public <VO> VO getVOById(Long orgId, Class<VO> clazz) {
        Org org = (Org)this.findById(orgId);
        if (org == null) {
            return null;
        }
        Object vo = ConvertUtil.convert((Object)org, clazz);
        List<Orgtree> orgtrees = this.orgtreePlusService.getByOrgIdLinktype(orgId, LinktypeEnum.FATHER_AND_SON.getValue());
        if (ListUtil.notNullorEmpty(orgtrees)) {
            if (clazz.equals(OrgVO.class)) {
                ((OrgVO)vo).setParentId(orgtrees.get(0).getParentId());
            } else if (clazz.equals(OrgMiniVO.class)) {
                ((OrgMiniVO)vo).setParentId(orgtrees.get(0).getParentId());
            }
        }
        if (clazz.equals(OrgVO.class)) {
            String fulldeptpath = this.getOrgFullpath(orgId);
            ((OrgVO)vo).setOrgfullname(fulldeptpath);
        }
        return (VO)vo;
    }

    @Override
    public String getOrgFullpath(Long orgId) {
        Long orgRootId = OrgUtil.getOrgRootId();
        Orgexpand orgexpand = this.orgexpandPlusService.getRealOrgexpand(orgRootId, orgId);
        if (orgexpand == null) {
            log.error("Orgplusservice-getOrgFullpath orgexpand is fail,org_id=" + orgId);
            Org org = (Org)this.getById(orgId);
            return org.getOrgname();
        }
        String fulldeptpath = orgexpand.getNamepath();
        String str = "\u6839\u673a\u6784";
        int pos = fulldeptpath.indexOf(str);
        int subpos = fulldeptpath.indexOf("/");
        if (pos > -1) {
            fulldeptpath = fulldeptpath.substring(subpos + 1);
        }
        return fulldeptpath;
    }

    @Override
    @Cacheable
    public String getOrgIdFullpath(Long orgId) {
        Long orgRootId = OrgUtil.getOrgRootId();
        Orgexpand orgexpand = this.orgexpandPlusService.getRealOrgexpand(orgRootId, orgId);
        if (orgexpand == null) {
            log.error("Orgplusservice-getOrgIdFullpath orgexpand is fail,org_id=" + orgId + "=====orgRootId====" + orgRootId);
            return this.getOrgIdFullpathByOrgtree(orgId);
        }
        String fullOrgIdpath = orgexpand.getIdpath();
        if (fullOrgIdpath.indexOf(",") == 0) {
            fullOrgIdpath = fullOrgIdpath.substring(1);
        }
        if (fullOrgIdpath.lastIndexOf(",") == fullOrgIdpath.length() - 1) {
            fullOrgIdpath = fullOrgIdpath.substring(0, fullOrgIdpath.length() - 1);
        }
        return fullOrgIdpath;
    }

    private String getOrgIdFullpathByOrgtree(Long orgId) {
        if (orgId.equals(SysInitData.ORG_ROOT.getValue())) {
            return orgId + "";
        }
        List<Orgtree> orgtreeList = this.orgtreePlusService.findRealByOrgId(orgId);
        Orgtree orgtree = orgtreeList.get(0);
        Long orgRootId = OrgUtil.getOrgRootId();
        if (orgtree.getParentId().longValue() == orgRootId.longValue() || orgtree.getParentId().longValue() == SysInitData.ORG_ROOT.getValue()) {
            return orgtree.getParentId() + "," + orgId;
        }
        return this.getOrgIdFullpathByOrgtree(orgtree.getParentId()) + "," + orgId;
    }

    @Override
    public void setFullorgIsleaf() {
        List<Org> orgList;
        int pageNumber = 0;
        int pageSize = 500;
        while (pageNumber < 5000 && !ListUtil.isNullorEmpty(orgList = this.getList(++pageNumber, pageSize))) {
            for (Org org : orgList) {
                try {
                    this.setIsleaf(org);
                }
                catch (Exception e) {
                    log.error("setFullorgIsleaf=====erorr============", (Object)e.getMessage(), (Object)e);
                }
            }
            if (orgList.size() >= pageSize) continue;
            break;
        }
    }

    @Override
    public void setIsleaf(Org org) {
        Org orgUpdate = new Org(org.getOrgId());
        boolean isupdate = false;
        Integer isrealorgleaf = this.getIsleafRealOrg(org.getOrgId());
        if (org.getIsrealorgleaf().intValue() != isrealorgleaf.intValue()) {
            orgUpdate.setIsrealorgleaf(isrealorgleaf);
            isupdate = true;
        }
        Integer isdomainleaf = this.getIsleafDomain(org.getOrgId());
        if (org.getIsdomainleaf().intValue() != isdomainleaf.intValue()) {
            orgUpdate.setIsdomainleaf(isdomainleaf);
            isupdate = true;
        }
        Integer isqueryorgleaf = this.getIsleafOrg(org.getOrgId());
        if (org.getIsqueryorgleaf().intValue() != isqueryorgleaf.intValue()) {
            orgUpdate.setIsqueryorgleaf(isqueryorgleaf);
            isupdate = true;
        }
        if (isupdate) {
            this.orgPlusDao.updateSelective(orgUpdate);
        }
    }

    private List<Org> getList(int pageNumber, int pageSize) {
        OrgQuery query = new OrgQuery(pageNumber, pageSize);
        query.setDeleted(0);
        query.getPage().setSortColumns("o.createdate");
        return this.orgPlusDao.findList(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExcelResultVO importOrg(Long userId, MultipartFile orgExcelFile) throws Exception {
        ExcelResultVO excelResultVO;
        UploadFile uploadFile = UploadFileUtil.upload((MultipartFile)orgExcelFile, (String)"orgimport/", (boolean)true);
        String excelfilepath = AppPathUtil.getTempLocalPath() + uploadFile.getFullpath();
        ExcelReadUtil excelReadUtil = new ExcelReadUtil();
        try {
            List readDataList;
            int firstDataRowIndex = 2;
            int pageNumber = 1;
            while ((readDataList = excelReadUtil.getExcelReadData(excelfilepath, OrgImportExcelModel.class, firstDataRowIndex, pageNumber)) != null && !readDataList.isEmpty()) {
                if (pageNumber > 5000) {
                    break;
                }
                for (int rowIndex = 0; rowIndex < readDataList.size(); ++rowIndex) {
                    OrgImportExcelModel orgImportExcelModel = (OrgImportExcelModel)((Object)readDataList.get(rowIndex));
                    try {
                        OrgBO orgBO = (OrgBO)ConvertUtil.convert((Object)((Object)orgImportExcelModel), OrgBO.class);
                        orgBO.setCreateway(CreateWayEnum.SYNC.getValue());
                        Org parentOrg = this.findOrgByOrgcode(orgBO.getParentcode());
                        if (parentOrg == null) {
                            orgImportExcelModel.setExcelImportErrorMessage("\u7236\u673a\u6784\u7f16\u53f7\u4e0d\u5b58\u5728\uff01");
                            excelReadUtil.addReadErrorData((Object)orgImportExcelModel, pageNumber, rowIndex);
                            continue;
                        }
                        orgBO.setParentId(parentOrg.getOrgId());
                        orgBO.setIsdomain(0);
                        Org org = this.findOrgByOrgcode(orgBO.getOrgcode());
                        if (org == null) {
                            this.self.txInsert(userId, orgBO);
                            continue;
                        }
                        orgBO.setOrgId(org.getOrgId());
                        this.self.txUpdate(userId, orgBO);
                        continue;
                    }
                    catch (Exception e) {
                        orgImportExcelModel.setExcelImportErrorMessage("\u4e1a\u52a1\u5904\u7406\u5931\u8d25\u4e86\uff01\uff01");
                        excelReadUtil.addReadErrorData((Object)orgImportExcelModel, pageNumber, rowIndex);
                    }
                }
                ++pageNumber;
            }
        }
        catch (PrdBaseException prdBaseException) {
        }
        finally {
            excelResultVO = excelReadUtil.getExcelResultVO(OrgImportExcelModel.class);
        }
        return excelResultVO;
    }

    @Override
    public OrgVO getRootOrg() {
        Long rootId = OrgUtil.getOrgRootId();
        return (OrgVO)this.findVOById(rootId, OrgVO.class);
    }

    @Override
    @Cacheable
    public Integer getUpDownRelation(Long oneOrgId, Long twoOrgId) {
        if (oneOrgId.longValue() == twoOrgId.longValue()) {
            return UpDownRelationEnum.SELF.getValue();
        }
        Orgexpand orgexpand = this.orgexpandPlusService.getRealOrgexpand(oneOrgId, twoOrgId);
        if (orgexpand != null) {
            return UpDownRelationEnum.UP.getValue();
        }
        orgexpand = this.orgexpandPlusService.getRealOrgexpand(twoOrgId, oneOrgId);
        if (orgexpand != null) {
            return UpDownRelationEnum.DOWN.getValue();
        }
        return UpDownRelationEnum.NO_RELATION.getValue();
    }

    @Override
    public List<Long> getOrgIdFullpathList(Long orgId) {
        String orgIds = this.self.getOrgIdFullpath(orgId);
        return StringUtil.splitToLongList((String)orgIds, (String)",");
    }

    @Override
    @Cacheable
    public List<Long> getAllUpOrgIds(Long orgId) {
        List<Orgexpand> orgexpands = this.orgexpandPlusService.getOrgexpand(SysInitData.ORG_ROOT.getValue(), orgId);
        ArrayList<Long> orgIds = new ArrayList();
        for (Orgexpand orgexpand : orgexpands) {
            String idpath = orgexpand.getIdpath();
            orgIds.addAll(StringUtil.splitToLongList((String)idpath, (String)","));
        }
        orgIds = ListUtil.removeDuplicate(orgIds);
        return orgIds;
    }
}

