/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.appsecurity.org.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.StringUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.framework.common.page.IQuery;
import com.peak.prd.appsecurity.domain.service.IDomainPlusService;
import com.peak.prd.appsecurity.org.dao.IOrgPlusDao;
import com.peak.prd.appsecurity.org.dao.IOrgexpandPlusDao;
import com.peak.prd.appsecurity.org.model.Org;
import com.peak.prd.appsecurity.org.model.Orgexpand;
import com.peak.prd.appsecurity.org.service.IOrgPlusService;
import com.peak.prd.appsecurity.org.service.IOrgexpandPlusService;
import com.peak.prd.appsecurity.org.service.IOrgtreePlusService;
import com.peak.prd.appsecurity.org.service.IOrgtreechangePlusService;
import com.peak.prd.appsecurity.org.util.OrgUtil;
import com.peak.prd.appsecurity.org.vo.OrgQuery;
import com.peak.prd.appsecurity.org.vo.OrgexpandQuery;
import com.peak.prd.appsecurity.org.vo.OrgtreeQuery;
import com.peak.prd.appsecurity.org.vo.OrgtreeVO;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.enums.LinktypeEnum;
import com.peak.prd.enums.OrgtreeCreatewayEnum;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@CacheConfig(cacheNames={"prd"})
public class OrgexpandPlusService
extends PrdBaseService<Orgexpand, Map<String, Object>, OrgexpandQuery>
implements IOrgexpandPlusService {
    private static final Logger log = LoggerFactory.getLogger(OrgexpandPlusService.class);
    @Autowired
    private IOrgtreePlusService orgtreePlusService;
    @Autowired
    private IOrgPlusDao orgPlusDao;
    @Resource
    @Lazy
    private IOrgPlusService orgPlusService;
    @Resource
    @Lazy
    private IDomainPlusService domainPlusService;
    @Resource
    private IOrgtreechangePlusService orgtreechangePlusService;
    @Resource
    @Lazy
    private IOrgexpandPlusService self;
    private IOrgexpandPlusDao orgexpandPlusDao;
    int PAGESIZE = 20;

    public void setOrgexpandPlusDao(IOrgexpandPlusDao dao) {
        this.orgexpandPlusDao = dao;
    }

    public IOrgexpandPlusDao getOrgexpandPlusDao() {
        return this.orgexpandPlusDao;
    }

    public IEntityDao<Orgexpand, Map<String, Object>, OrgexpandQuery> getEntityDao() {
        return this.orgexpandPlusDao;
    }

    @Override
    public boolean hasBeginEnd(List<Long> beginOrgIds, Long endOrgId) {
        return this.orgexpandPlusDao.hasBeginEnd(beginOrgIds, endOrgId);
    }

    @Override
    public int deleteExpandBySingle(Long orgId) {
        if (orgId == null) {
            return 0;
        }
        OrgexpandQuery query = new OrgexpandQuery();
        query.setContainOrgId(orgId);
        return this.orgexpandPlusDao.deleteByQuery(query);
    }

    @Override
    public int expandAllSelf() {
        return this.orgexpandPlusDao.expandAllSelf();
    }

    @Override
    public int expandSelf(Org org) {
        Orgexpand oe = new Orgexpand();
        oe.setBeginorgId(org.getOrgId());
        oe.setEndorgId(org.getOrgId());
        oe.setDepth(0);
        oe.setIdpath("," + org.getOrgId() + ",");
        oe.setNamepath(org.getOrgname());
        oe.setCreatedate(new Date());
        oe.setLinktype(0);
        oe.setCreateway(0);
        return this.insert((BaseEntity)oe);
    }

    @Override
    public int expandDown(Org org) {
        if (org == null) {
            return 0;
        }
        String prefixIdPath = "," + org.getOrgId() + ",";
        String prefixNamePath = org.getOrgname() + " / ";
        return this.expandDown(org, org.getOrgId(), prefixIdPath, prefixNamePath);
    }

    @Override
    public int expandUp(Org org) {
        if (org == null) {
            return 0;
        }
        String appendIdPath = "," + org.getOrgId() + ",";
        String appendNamePath = " / " + org.getOrgname();
        return this.expandUp(org, org.getOrgId(), appendIdPath, appendNamePath);
    }

    private int expandDown(Org startOrg, Long thisOrgId, String prefixIdPath, String prefixNamePath) {
        if (thisOrgId == null) {
            return 0;
        }
        Date now = new Date();
        int counter = 0;
        OrgtreeQuery query = new OrgtreeQuery();
        query.setParentId(thisOrgId);
        query.setLinktype(0);
        query.getPage().setSortColumns("org_id");
        query.getPage().setPageSize(this.PAGESIZE);
        int pageNo = 1;
        for (int aa = 0; aa < 99999; ++aa) {
            int j;
            query.getPage().setPageNumber(pageNo++);
            List children = this.orgtreePlusService.getPrdEntityDao().findList((IQuery)query, "findAllVO", OrgtreeVO.class);
            if (children == null || children.isEmpty()) break;
            ArrayList<Orgexpand> oes = new ArrayList<Orgexpand>();
            for (j = 0; j < children.size(); ++j) {
                Orgexpand oe = new Orgexpand();
                oe.setBeginorgId(startOrg.getOrgId());
                oe.setEndorgId(((OrgtreeVO)children.get(j)).getOrgId());
                oe.setIdpath(prefixIdPath + ((OrgtreeVO)children.get(j)).getOrgId() + ",");
                oe.setNamepath(prefixNamePath + ((OrgtreeVO)children.get(j)).getOrgname());
                oe.setLinktype(0);
                oe.setCreatedate(now);
                oe.setDepth(oe.getIdpath().split(",", -1).length - 3);
                oe.setCreateway(0);
                oes.add(oe);
            }
            this.insertBatch(oes);
            counter += oes.size();
            for (j = 0; j < children.size(); ++j) {
                counter += this.expandDown(startOrg, ((OrgtreeVO)children.get(j)).getOrgId(), prefixIdPath + ((OrgtreeVO)children.get(j)).getOrgId() + ",", prefixNamePath + ((OrgtreeVO)children.get(j)).getOrgname() + " / ");
            }
        }
        return counter;
    }

    int expandUp(Org endOrg, Long thisOrgId, String appendIdPath, String appendNamePath) {
        if (thisOrgId == null) {
            return 0;
        }
        Date now = new Date();
        int counter = 0;
        OrgtreeQuery query = new OrgtreeQuery();
        query.setOrgId(thisOrgId);
        query.setLinktype(0);
        query.getPage().setSortColumns("parent_id");
        query.getPage().setPageSize(this.PAGESIZE);
        int pageNo = 1;
        for (int aa = 0; aa < 99999; ++aa) {
            int j;
            query.getPage().setPageNumber(pageNo++);
            List parents = this.orgtreePlusService.getPrdEntityDao().findList((IQuery)query, "findAllVO", OrgtreeVO.class);
            if (parents == null || parents.isEmpty() || parents.size() == 1 && (((OrgtreeVO)parents.get(0)).getParentId() == null || ((OrgtreeVO)parents.get(0)).getParentId() <= 0L || ((OrgtreeVO)parents.get(0)).getParentId().longValue() == thisOrgId.longValue())) break;
            ArrayList<Orgexpand> oes = new ArrayList<Orgexpand>();
            block1: for (j = 0; j < parents.size(); ++j) {
                Orgexpand oe = new Orgexpand();
                oe.setBeginorgId(((OrgtreeVO)parents.get(j)).getParentId());
                oe.setEndorgId(endOrg.getOrgId());
                oe.setIdpath("," + ((OrgtreeVO)parents.get(j)).getParentId() + appendIdPath);
                oe.setNamepath(((OrgtreeVO)parents.get(j)).getParentname() + appendNamePath);
                oe.setLinktype(0);
                oe.setCreatedate(now);
                oe.setDepth(oe.getIdpath().split(",", -1).length - 3);
                oe.setCreateway(0);
                oes.add(oe);
                OrgexpandQuery oeQuery = new OrgexpandQuery();
                oeQuery.setBeginorgId(endOrg.getOrgId());
                oeQuery.getPage().setSortColumns("idpath");
                oeQuery.getPage().setPageSize(this.PAGESIZE);
                int oePageNo = 1;
                for (int bb = 0; bb < 99999; ++bb) {
                    oeQuery.getPage().setPageNumber(oePageNo++);
                    List children = this.orgexpandPlusDao.findList(oeQuery);
                    if (children == null || children.isEmpty()) continue block1;
                    ArrayList<Orgexpand> oess = new ArrayList<Orgexpand>();
                    for (int k = 0; k < children.size(); ++k) {
                        Orgexpand child = (Orgexpand)children.get(k);
                        Orgexpand oe2 = new Orgexpand();
                        oe2.setBeginorgId(((OrgtreeVO)parents.get(j)).getParentId());
                        oe2.setEndorgId(child.getEndorgId());
                        String tmp1 = "," + endOrg.getOrgId() + ",";
                        String tmp2 = endOrg.getOrgname();
                        oe2.setIdpath(oe.getIdpath() + child.getIdpath().substring(tmp1.length()));
                        oe2.setNamepath(oe.getNamepath() + child.getNamepath().substring(tmp2.length()));
                        oe2.setLinktype(0);
                        oe2.setCreatedate(now);
                        oe2.setDepth(child.getDepth() + oe.getDepth());
                        oe2.setCreateway(0);
                        oess.add(oe2);
                    }
                    if (oess.size() > 0) {
                        this.insertBatch(oess);
                    }
                    counter += oess.size();
                }
            }
            if (oes.size() > 0) {
                this.insertBatch(oes);
            }
            counter += oes.size();
            for (j = 0; j < parents.size(); ++j) {
                counter += this.expandUp(endOrg, ((OrgtreeVO)parents.get(j)).getParentId(), "," + ((OrgtreeVO)parents.get(j)).getParentId() + appendIdPath, " / " + ((OrgtreeVO)parents.get(j)).getParentname() + appendNamePath);
            }
        }
        return counter;
    }

    @Override
    public int expandBySingle(Long orgId) {
        return this.expandBySingle((Org)this.orgPlusDao.getById(orgId));
    }

    @Override
    public int expandBySingle(Org org) {
        if (org == null) {
            return 0;
        }
        Long orgId = org.getOrgId();
        this.deleteExpandBySingle(orgId);
        int counter = 0;
        counter += this.expandDown(org);
        counter += this.expandUp(org);
        return counter += this.expandSelf(org);
    }

    @Override
    public int updateAllPro() {
        OrgQuery orgQuery = new OrgQuery();
        List rootOrgs = this.orgPlusDao.findList(orgQuery, "findAllRoot");
        if (rootOrgs == null || rootOrgs.isEmpty()) {
            return 0;
        }
        this.orgexpandPlusDao.truncate();
        int counter = 0;
        for (int i = 0; i < rootOrgs.size(); ++i) {
            counter += this.expandRootExcludeSelf((Org)rootOrgs.get(i));
        }
        return counter += this.expandAllSelf();
    }

    int expandRootExcludeSelf(Org rootOrg) {
        return this.expandDownDeep(rootOrg);
    }

    private int expandDownDeep(Org startOrg) {
        int counter = 0;
        counter += this.expandDown(startOrg);
        OrgtreeQuery query = new OrgtreeQuery();
        query.setParentId(startOrg.getOrgId());
        query.setLinktype(0);
        query.getPage().setSortColumns("org_id");
        query.getPage().setPageSize(this.PAGESIZE);
        int pageNo = 1;
        for (int aa = 0; aa < 99999; ++aa) {
            query.getPage().setPageNumber(pageNo++);
            List children = this.orgtreePlusService.getPrdEntityDao().findList((IQuery)query, "findAllVO", OrgtreeVO.class);
            if (children == null || children.isEmpty()) break;
            for (int j = 0; j < children.size(); ++j) {
                Org tmp = (Org)ConvertUtil.convert(children.get(j), Org.class);
                counter += this.expandDownDeep(tmp);
            }
        }
        return counter;
    }

    @Override
    public List<Orgexpand> endByIds(List<Long> ids) {
        return this.orgexpandPlusDao.endByIds(ids);
    }

    @Override
    public List<Orgexpand> getIdPath(List<Long> beginOrgIds, String orgname) {
        OrgexpandQuery query = new OrgexpandQuery(1, 200);
        query.setBeginOrgIds(beginOrgIds);
        query.setOrgname(orgname);
        return this.orgexpandPlusDao.findList(query, "getIdPath");
    }

    @Override
    public List<Orgexpand> getIdPath(Long beginOrgId, String orgname) {
        return this.getIdPath(Collections.singletonList(beginOrgId), orgname);
    }

    @Override
    public List<Orgexpand> getRealOrgIdPath(Long beginOrgId, String orgname) {
        OrgexpandQuery query = new OrgexpandQuery(1, 200);
        query.setBeginorgId(beginOrgId);
        query.setOrgname(orgname);
        return this.orgexpandPlusDao.findList(query, "getRealOrgIdPath");
    }

    @Override
    public List<Orgexpand> getDomainIdPath(Long beginOrgId, String orgname) {
        OrgexpandQuery query = new OrgexpandQuery(1, 200);
        query.setBeginorgId(beginOrgId);
        query.setOrgname(orgname);
        return this.orgexpandPlusDao.findList(query, "getDomainOrgIdPath");
    }

    @Override
    public Orgexpand getRealOrgexpand(long beginOrgId, Long endOrgId) {
        OrgexpandQuery query = new OrgexpandQuery();
        query.setBeginorgId(beginOrgId);
        query.setEndorgId(endOrgId);
        query.setCreateway(OrgtreeCreatewayEnum.NEWADD.getValue());
        query.setLinktype(LinktypeEnum.FATHER_AND_SON.getValue());
        return (Orgexpand)this.orgexpandPlusDao.findOne(query);
    }

    @Override
    @Cacheable
    public Orgexpand findRealOrgexpand(long beginOrgId, Long endOrgId) {
        return this.getRealOrgexpand(beginOrgId, endOrgId);
    }

    @Override
    @Cacheable
    public List<Orgexpand> findUpAndSelfIds(Long endOrgId) {
        OrgexpandQuery query = new OrgexpandQuery();
        query.setEndorgId(endOrgId);
        query.setLinktype(LinktypeEnum.FATHER_AND_SON.getValue());
        query.getPage().setSortColumns("oe.createdate");
        return this.getOrgexpandPlusDao().findAll(query);
    }

    @Override
    public void updateIncr(Long enterpriseId, Integer levels) {
        this.getOrgexpandPlusDao().updateIncr(enterpriseId, levels);
    }

    @Override
    public void updateIncrSelectAddDomain(Long enterpriseId, Integer levels) {
        this.getOrgexpandPlusDao().updateIncrSelectAddDomain(enterpriseId, levels);
    }

    @Override
    public void updateAllPlus(Long enterpriseId) {
        this.getOrgexpandPlusDao().truncate();
        this.getOrgexpandPlusDao().updateAllPlus(enterpriseId);
        this.orgexpandPlusDao.updateAllPlusSelectDomain(enterpriseId);
        this.orgtreechangePlusService.deleteByEnterpriseId(enterpriseId, OrgtreeCreatewayEnum.SELECTADD.getValue());
        this.orgtreechangePlusService.deleteByEnterpriseId(enterpriseId, OrgtreeCreatewayEnum.NEWADD.getValue());
    }

    @Override
    public void deleteByIncrHisData(Long enterpriseId) {
        this.getOrgexpandPlusDao().deleteByIncrHisData(enterpriseId);
    }

    @Override
    public void updateAll() {
        this.orgexpandPlusDao.updateAll();
    }

    @Override
    public int deleteByParentIdEndorgId(Long parentId, Long endOrgId) {
        return this.orgexpandPlusDao.deleteByParentIdEndorgId(parentId, endOrgId);
    }

    @Override
    public void fullRefreshAllDomain() {
        this.orgexpandPlusDao.truncate();
        try {
            this.updateAllPlus(OrgUtil.getOrgRootId());
            this.domainPlusService.refreshFilteruserDomain(OrgUtil.getOrgRootId());
        }
        catch (Exception e) {
            log.error(e.toString());
        }
    }

    @Override
    public int deleteByBeginOrEndOrgId(Long orgId) {
        return this.orgexpandPlusDao.deleteByBeginOrEndOrgId(orgId);
    }

    @Override
    public int deleteByIdpath(Long orgId) {
        return this.orgexpandPlusDao.deleteByIdpath(orgId);
    }

    @Override
    public List<Long> getRealIdPathList(Long beginOrgId, Long endOrgId) {
        Orgexpand orgexpand = this.self.findRealOrgexpand(beginOrgId, endOrgId);
        if (orgexpand == null) {
            log.error("OrgexpandPlusService-getIdPathList orgexpand is fail,beginOrgId=" + beginOrgId + "=====endOrgId====" + endOrgId);
            return new ArrayList<Long>();
        }
        String fullOrgIdpath = orgexpand.getIdpath();
        return StringUtil.splitToLongList((String)fullOrgIdpath, (String)",");
    }

    @Override
    public List<Orgexpand> getOrgexpand(Long beginOrgId, Long endOrgId) {
        OrgexpandQuery query = new OrgexpandQuery(1, 1000);
        query.setBeginorgId(beginOrgId);
        query.setEndorgId(endOrgId);
        return this.orgexpandPlusDao.findList(query);
    }
}

