/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.appsecurity.org.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.ListUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.appsecurity.org.bo.OrgOrderNumBO;
import com.peak.prd.appsecurity.org.dao.IOrgtreePlusDao;
import com.peak.prd.appsecurity.org.model.Org;
import com.peak.prd.appsecurity.org.model.Orgexpand;
import com.peak.prd.appsecurity.org.model.Orgtree;
import com.peak.prd.appsecurity.org.model.Orgtreechange;
import com.peak.prd.appsecurity.org.service.IOrgPlusService;
import com.peak.prd.appsecurity.org.service.IOrgexpandPlusService;
import com.peak.prd.appsecurity.org.service.IOrgtreePlusService;
import com.peak.prd.appsecurity.org.service.IOrgtreechangePlusService;
import com.peak.prd.appsecurity.org.vo.OrgtreeQuery;
import com.peak.prd.base.model.IRespStatusEnum;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.base.util.ExceptionUtil;
import com.peak.prd.enums.CoreResponseStatusEnum;
import com.peak.prd.enums.LinktypeEnum;
import com.peak.prd.enums.OrgtreeCreatewayEnum;
import com.peak.prd.enums.SysInitData;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@CacheConfig(cacheNames={"prd"})
public class OrgtreePlusService
extends PrdBaseService<Orgtree, Map<String, Object>, OrgtreeQuery>
implements IOrgtreePlusService {
    @Autowired
    @Lazy
    private IOrgtreePlusService self;
    @Autowired
    @Lazy
    private IOrgPlusService orgPlusService;
    @Autowired
    private IOrgtreechangePlusService orgtreechangePlusService;
    @Resource
    @Lazy
    private IOrgexpandPlusService orgexpandPlusService;
    private IOrgtreePlusDao orgtreePlusDao;

    public void setOrgtreePlusDao(IOrgtreePlusDao dao) {
        this.orgtreePlusDao = dao;
    }

    public IOrgtreePlusDao getOrgtreePlusDao() {
        return this.orgtreePlusDao;
    }

    public IEntityDao<Orgtree, Map<String, Object>, OrgtreeQuery> getEntityDao() {
        return this.orgtreePlusDao;
    }

    @Override
    public List<Orgtree> getAll(OrgtreeQuery query) {
        return this.orgtreePlusDao.getAll(query);
    }

    @Override
    public List<Orgtree> findSon(Long parentId) {
        return this.self.findSon(parentId, 0);
    }

    @Override
    @Cacheable
    public List<Orgtree> findSon(Long parentId, Integer linktype) {
        return this.getSon(parentId, linktype);
    }

    @Override
    public List<Orgtree> getSon(Long parentId, Integer linktype) {
        return this.orgtreePlusDao.getSon(parentId, linktype);
    }

    @Override
    public List<Long> findMngRealorgIds(Long domainId) {
        List<Orgtree> orgtreeList = this.self.findSon(domainId, LinktypeEnum.CONTAIN.getValue());
        return IdUtil.getIds(orgtreeList, Orgtree::getOrgId);
    }

    @Override
    public List<Orgtree> getByOrgIdLinktype(Long orgId, Integer linktype) {
        OrgtreeQuery query = new OrgtreeQuery();
        query.setOrgId(orgId);
        query.setLinktype(linktype);
        query.getPage().setSortColumns("ot.org_id");
        return this.getOrgtreePlusDao().findAll(query);
    }

    @Override
    public List<Orgtree> getByOrgIds(List<Long> orgIdList) {
        return this.getOrgtreePlusDao().getByOrgIds(orgIdList);
    }

    @Override
    @Caching(evict={@CacheEvict(cacheNames={"prd"}, key="'OrgtreePlusService:findSon:' + #parentId + ',' + #linktype")})
    public void txInsertSelective(Long userId, Long orgId, Long parentId, Integer ordernum, Integer linktype) {
        Integer createway = OrgtreeCreatewayEnum.NEWADD.getValue();
        if (linktype.intValue() == LinktypeEnum.CONTAIN.getValue()) {
            createway = OrgtreeCreatewayEnum.SELECTADD.getValue();
        }
        Orgtree orgtree = this.insertOrgtree(userId, orgId, parentId, ordernum, linktype, createway);
        Orgtreechange orgtreechange = new Orgtreechange();
        ConvertUtil.copyProperties((Object)orgtree, (Object)orgtreechange);
        orgtreechange.setChangeway(1);
        orgtreechange.setCreateway(createway);
        orgtreechange.setCreatedate(new Date());
        this.orgtreechangePlusService.insertSelective((BaseEntity)orgtreechange);
    }

    @Override
    @Caching(evict={@CacheEvict(cacheNames={"prd"}, key="'OrgtreePlusService:findSon:' + #parentId + ',' + #linktype")})
    public void txInsertSelectDomain(Long userId, Long orgId, Long parentId, Integer ordernum, Integer linktype) {
        Orgtree orgtreeold = this.getInfo(orgId, parentId, linktype);
        if (orgtreeold != null) {
            ExceptionUtil.handle((IRespStatusEnum)CoreResponseStatusEnum.DOMAIN_ALREADY_ADDED);
        }
        Orgtree orgtree = this.insertOrgtree(userId, orgId, parentId, ordernum, linktype, OrgtreeCreatewayEnum.SELECTADD.getValue());
        Orgtreechange orgtreechange = new Orgtreechange();
        ConvertUtil.copyProperties((Object)orgtree, (Object)orgtreechange);
        orgtreechange.setChangeway(1);
        orgtreechange.setCreateway(OrgtreeCreatewayEnum.SELECTADD.getValue());
        this.orgtreechangePlusService.insertSelective((BaseEntity)orgtreechange);
    }

    private Orgtree insertOrgtree(Long userId, Long orgId, Long parentId, Integer ordernum, Integer linktype, Integer createway) {
        List<Orgtree> parentOrgtrees = this.getByOrgIdLinktype(parentId, LinktypeEnum.FATHER_AND_SON.getValue());
        if (ListUtil.isNullorEmpty(parentOrgtrees)) {
            return null;
        }
        Orgtree parentOrgtree = parentOrgtrees.get(0);
        Orgtree orgtree = new Orgtree();
        orgtree.setOrgId(orgId);
        orgtree.setParentId(parentId);
        orgtree.setCreateway(createway);
        Integer parentlevels = parentOrgtree.getLevels();
        if (parentlevels == null) {
            Orgexpand orgexpand = this.orgexpandPlusService.getRealOrgexpand(SysInitData.ORG_ROOT.getValue(), parentId);
            parentlevels = orgexpand.getDepth();
        }
        orgtree.setLevels(parentlevels + 1);
        orgtree.setOrdernum(ordernum);
        orgtree.setLinktype(linktype);
        orgtree.setCreatorId(userId);
        Org org = (Org)this.orgPlusService.getById(orgId);
        orgtree.setEnterpriseId(org.getEnterpriseId());
        orgtree.setCreatedate(new Date());
        this.getOrgtreePlusDao().insertSelective((BaseEntity)orgtree);
        return orgtree;
    }

    @Override
    @Caching(evict={@CacheEvict(cacheNames={"prd"}, key="'OrgtreePlusService:findSon:' + #parentId + ',0'"), @CacheEvict(cacheNames={"prd"}, key="'OrgtreePlusService:findRealByOrgId:' + #parentId")})
    public Integer txUpdateSelective(Long orgId, Long parentId, Integer ordernum) {
        List<Orgtree> orgtrees = this.getByOrgIdLinktype(orgId, LinktypeEnum.FATHER_AND_SON.getValue());
        if (ListUtil.isNullorEmpty(orgtrees)) {
            return 0;
        }
        Orgtree orgtreeOld = orgtrees.get(0);
        if (orgtreeOld.getParentId().longValue() == parentId.longValue()) {
            if (ordernum == null) {
                return 0;
            }
            OrgtreeQuery query = new OrgtreeQuery();
            query.setOrgId(orgId);
            query.setParentId(parentId);
            query.setOrdernum(ordernum);
            query.setLinktype(LinktypeEnum.FATHER_AND_SON.getValue());
            return this.getOrgtreePlusDao().updateSelective(query);
        }
        this.orgtreechangePlusService.deleteTreeData(orgId);
        List<Orgtree> parentOrgtrees = this.getByOrgIdLinktype(parentId, LinktypeEnum.FATHER_AND_SON.getValue());
        Orgtree parentOrgtree = parentOrgtrees.get(0);
        Integer parentLevel = parentOrgtree.getLevels();
        if (parentLevel == null) {
            Orgexpand orgexpand = this.orgexpandPlusService.getRealOrgexpand(SysInitData.ORG_ROOT.getValue(), parentId);
            parentLevel = orgexpand.getDepth();
        }
        int intparentLevel = parentLevel;
        Integer levels = orgtreeOld.getLevels();
        if (levels == null) {
            Orgexpand orgexpand = this.orgexpandPlusService.getRealOrgexpand(SysInitData.ORG_ROOT.getValue(), orgtreeOld.getOrgId());
            levels = orgexpand.getDepth();
        }
        int intLevels = levels;
        int row = 0;
        row = this.getOrgtreePlusDao().updateInfo(orgId, parentId, ordernum);
        if (intLevels != intparentLevel + 1) {
            int levelsDiffer = intLevels - (intparentLevel + 1);
            this.getOrgtreePlusDao().updateLevels(orgId, levelsDiffer);
        }
        this.orgtreechangePlusService.insertTreeData(orgId, parentLevel + 1);
        return row;
    }

    @Override
    @Caching(evict={@CacheEvict(cacheNames={"prd"}, key="'OrgtreePlusService:findSon:' + #parentId + ',' + #linktype")})
    public void txDeleteDomainRange(Long orgId, Long parentId, Integer linktype) {
        this.orgexpandPlusService.deleteByParentIdEndorgId(parentId, orgId);
        HashMap<String, Number> pk = new HashMap<String, Number>();
        pk.put("orgId", orgId);
        pk.put("parentId", parentId);
        pk.put("linktype", linktype);
        this.getOrgtreePlusDao().deleteById(pk);
    }

    @Override
    @Caching(evict={@CacheEvict(cacheNames={"prd"}, key="'OrgtreePlusService:findSon:' + #parentId + ',' + #linktype"), @CacheEvict(cacheNames={"prd"}, key="'OrgtreePlusService:findRealByOrgId:' + #parentId")})
    public int txDeleteSelectDomain(Long orgId, Long parentId, Integer linktype) {
        this.orgexpandPlusService.deleteByParentIdEndorgId(parentId, orgId);
        Org orgParent = (Org)this.orgPlusService.getById(parentId);
        this.orgPlusService.setIsleaf(orgParent);
        this.orgPlusService.clearCache(parentId);
        HashMap<String, Number> pk = new HashMap<String, Number>();
        pk.put("orgId", orgId);
        pk.put("parentId", parentId);
        pk.put("linktype", linktype);
        return this.getOrgtreePlusDao().deleteById(pk);
    }

    @Override
    public Orgtree getInfo(Long orgId, Long parentId, Integer linktype) {
        HashMap<String, Number> pk = new HashMap<String, Number>();
        pk.put("orgId", orgId);
        pk.put("parentId", parentId);
        pk.put("linktype", linktype);
        return (Orgtree)this.getOrgtreePlusDao().getById(pk);
    }

    @Override
    public int txUpdateDomainRange(Long userId, Long orgId, List<Long> mngOrgIdList) {
        List<Orgtree> orgtreeList = this.getOrgtreePlusDao().getSon(orgId, LinktypeEnum.CONTAIN.getValue());
        List oldMngOrgIdList = IdUtil.getIds(orgtreeList, Orgtree::getOrgId);
        List oldSubtractList = ListUtil.subtract((List)oldMngOrgIdList, mngOrgIdList);
        List newSubtractList = ListUtil.subtract(mngOrgIdList, (List)oldMngOrgIdList);
        if (ListUtil.isNullorEmpty((List)oldSubtractList) && ListUtil.isNullorEmpty((List)newSubtractList)) {
            return 0;
        }
        if (ListUtil.notNullorEmpty((List)oldSubtractList)) {
            oldSubtractList.forEach(oldOrgId -> this.self.txDeleteDomainRange((Long)oldOrgId, orgId, LinktypeEnum.CONTAIN.getValue()));
        }
        AtomicInteger ordernum = new AtomicInteger(oldMngOrgIdList.size());
        if (ListUtil.notNullorEmpty((List)newSubtractList)) {
            newSubtractList.forEach(newOrgId -> {
                ordernum.getAndIncrement();
                this.self.txInsertSelective(userId, (Long)newOrgId, orgId, ordernum.intValue(), LinktypeEnum.CONTAIN.getValue());
            });
        }
        return oldSubtractList.size() + newSubtractList.size();
    }

    @Override
    public Integer getMaxOrdernum(Long parentId) {
        OrgtreeQuery query = new OrgtreeQuery();
        query.setParentId(parentId);
        Integer maxOrdernum = (Integer)this.getOrgtreePlusDao().selectOne(query, "getMaxOrdernum");
        return maxOrdernum == null ? 0 : maxOrdernum;
    }

    @Override
    public Integer updateOrderNum(List<OrgOrderNumBO> orgOrderNumBOList) {
        int updateNum = 0;
        for (OrgOrderNumBO orgOrderNumBO : orgOrderNumBOList) {
            updateNum += this.getOrgtreePlusDao().updateOrdernum(orgOrderNumBO.getOrgId(), orgOrderNumBO.getOrdernum());
        }
        return updateNum;
    }

    @Override
    @Cacheable
    public List<Orgtree> findRealByOrgId(Long orgId) {
        return this.getByOrgIdLinktype(orgId, LinktypeEnum.FATHER_AND_SON.getValue());
    }

    @Override
    public Integer deleteRubbishOrgtree() {
        return this.getOrgtreePlusDao().deleteRubbishOrgtree();
    }

    @Override
    public List<Orgtree> getDomainSon(Long parentId) {
        return this.orgtreePlusDao.getDomainSon(parentId);
    }

    @Override
    public List<Orgtree> findAllSon(Long parentId) {
        return this.orgtreePlusDao.findAllSon(parentId);
    }

    @Override
    public List<Orgtree> getMngRangeContain(List<Long> orgIdList) {
        OrgtreeQuery query = new OrgtreeQuery();
        query.setOrgIdList(orgIdList);
        query.setLinktype(LinktypeEnum.CONTAIN.getValue());
        query.getPage().setSortColumns("ot.createdate desc");
        return this.orgtreePlusDao.findAll(query);
    }

    @Override
    public List<Orgtree> getSelectContain(List<Long> orgIdList) {
        OrgtreeQuery query = new OrgtreeQuery();
        query.setOrgIdList(orgIdList);
        query.setLinktype(LinktypeEnum.SELECT_SON.getValue());
        query.getPage().setSortColumns("ot.createdate desc");
        return this.orgtreePlusDao.findAll(query);
    }
}

