/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.appsecurity.org.util;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.ListUtil;
import com.peak.common.util.SpringUtil;
import com.peak.prd.appsecurity.org.model.Org;
import com.peak.prd.appsecurity.org.model.Orgexpand;
import com.peak.prd.appsecurity.org.service.IOrgPlusService;
import com.peak.prd.appsecurity.org.service.IOrgexpandPlusService;
import com.peak.prd.appsecurity.org.service.imple.OrgPlusService;
import com.peak.prd.appsecurity.org.vo.OrgVO;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class OrgCoreUtil {
    public static <VO> void setOrgFullname(List<VO> vos, Function<VO, Long> getIdFunc, BiConsumer<VO, String> setOrgFullnameFunc) {
        List<Orgexpand> orgs = OrgCoreUtil.findOrgexpands(vos, getIdFunc);
        if (orgs == null || orgs.isEmpty()) {
            return;
        }
        for (int i = 0; i < vos.size(); ++i) {
            VO vo = vos.get(i);
            Orgexpand oe = orgs.get(i);
            if (vo == null || oe == null) continue;
            setOrgFullnameFunc.accept(vo, oe.getNamepath());
        }
    }

    private static <T> List<Orgexpand> findOrgexpands(List<T> vos, Function<T, Long> getIdFunc) {
        if (vos == null) {
            return null;
        }
        IOrgexpandPlusService orgexpandPlusService = (IOrgexpandPlusService)SpringUtil.getBean(IOrgexpandPlusService.class);
        List orgIds = ConvertUtil.removeNull((List)IdUtil.getIds(vos, vo -> (Long)getIdFunc.apply(vo)));
        orgIds = ListUtil.removeDuplicate((List)orgIds);
        List<Orgexpand> orgs = orgexpandPlusService.endByIds(orgIds);
        List sortedList = ConvertUtil.refact(vos, orgs, (vo, o) -> {
            Long itemId = (Long)getIdFunc.apply(vo);
            return itemId != null && itemId.equals(o.getEndorgId());
        });
        return sortedList;
    }

    public static <VO> void setOrgName(List<VO> vos, Function<VO, Long> getIdFunc, BiConsumer<VO, String> setOrgNameFunc) {
        List<Org> orgs = OrgCoreUtil.findOrgs(vos, getIdFunc);
        if (orgs == null || orgs.isEmpty()) {
            return;
        }
        for (int i = 0; i < vos.size(); ++i) {
            VO vo = vos.get(i);
            Org o = orgs.get(i);
            if (vo == null || o == null) continue;
            setOrgNameFunc.accept(vo, o.getOrgname());
        }
    }

    private static <T> List<Org> findOrgs(List<T> vos, Function<T, Long> getIdFunc) {
        if (vos == null) {
            return null;
        }
        IOrgPlusService orgPlusService = (IOrgPlusService)SpringUtil.getBean(IOrgPlusService.class);
        List orgIds = ConvertUtil.removeNull((List)IdUtil.getIds(vos, vo -> (Long)getIdFunc.apply(vo)));
        orgIds = ListUtil.removeDuplicate((List)orgIds);
        List orgs = orgPlusService.findByIds(orgIds);
        List sortedList = ConvertUtil.refact(vos, (List)orgs, (vo, o) -> {
            Long itemId = (Long)getIdFunc.apply(vo);
            return itemId != null && itemId.equals(o.getOrgId());
        });
        return sortedList;
    }

    public static <VO> void setOrgVO(List<VO> originVOList, Function<VO, Long> getOrgIdFunc, BiConsumer<VO, OrgVO> setOrgVOFunc) {
        if (ListUtil.isNullorEmpty(originVOList)) {
            return;
        }
        List orgIdList = IdUtil.getIds(originVOList, getOrgIdFunc);
        orgIdList = ListUtil.removeDuplicate((List)orgIdList);
        IOrgPlusService orgPlusService = (IOrgPlusService)SpringUtil.getBean(OrgPlusService.class);
        List orgVOList = orgPlusService.findVOsByIds(orgIdList, OrgVO.class);
        Map orgVOMap = ConvertUtil.listToMap((List)orgVOList, OrgVO::getOrgId);
        for (VO vo : originVOList) {
            OrgVO orgVO;
            if (vo == null || (orgVO = (OrgVO)orgVOMap.get(getOrgIdFunc.apply(vo))) == null) continue;
            setOrgVOFunc.accept(vo, orgVO);
        }
    }
}

