/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.appsecurity.position.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.ListUtil;
import com.peak.common.util.StringUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.appsecurity.position.bo.PositionBO;
import com.peak.prd.appsecurity.position.bo.PositionOrderNumBO;
import com.peak.prd.appsecurity.position.dao.IPositionPlusDao;
import com.peak.prd.appsecurity.position.model.Position;
import com.peak.prd.appsecurity.position.service.IPositionPlusService;
import com.peak.prd.appsecurity.position.vo.PositionDetailVO;
import com.peak.prd.appsecurity.position.vo.PositionMiniVO;
import com.peak.prd.appsecurity.position.vo.PositionQuery;
import com.peak.prd.appsecurity.position.vo.PositionVO;
import com.peak.prd.appsecurity.user.util.UserCoreUtil;
import com.peak.prd.base.model.IRespStatusEnum;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.base.util.ExceptionUtil;
import com.peak.prd.enums.CoreResponseStatusEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Service;

@Service
public class PositionPlusService
extends PrdBaseService<Position, Long, PositionQuery>
implements IPositionPlusService {
    private IPositionPlusDao positionPlusDao;

    public void setPositionPlusDao(IPositionPlusDao dao) {
        this.positionPlusDao = dao;
    }

    public IPositionPlusDao getPositionPlusDao() {
        return this.positionPlusDao;
    }

    public IEntityDao<Position, Long, PositionQuery> getEntityDao() {
        return this.positionPlusDao;
    }

    @Override
    public List<String> getLables(Long positionId) {
        Position position = (Position)this.getById(positionId);
        if (position != null && !StringUtil.isNullorEmptyStr((String)position.getLabel())) {
            String[] labels = StringUtil.splitToStrings((String)position.getLabel(), (String)",");
            return Arrays.asList(labels);
        }
        return null;
    }

    @Override
    public List<String> getLables(List<Long> positionIds) {
        List positions = this.findByIds(positionIds);
        HashSet<String> set = new HashSet<String>();
        for (Position position : positions) {
            if (StringUtil.isNullorEmptyStr((String)position.getLabel())) continue;
            String[] labels = StringUtil.splitToStrings((String)position.getLabel(), (String)",");
            set.addAll(Arrays.asList(labels));
        }
        if (set.size() == 0) {
            return null;
        }
        return new ArrayList<String>(set);
    }

    @Override
    public Long insert(@NotNull Long userId, @NotNull Long domainId, @NotNull PositionBO positionBO) {
        Position validposition = this.getByCode(positionBO.getCode());
        if (validposition != null) {
            ExceptionUtil.handle((IRespStatusEnum)CoreResponseStatusEnum.ORGCODE_SAME);
        }
        Position position = (Position)ConvertUtil.convert((Object)positionBO, Position.class);
        Long positionId = IdUtil.getSequence((String)"TPOSITION");
        position.setPositionId(positionId);
        position.setDomainId(domainId);
        position.setEnterpriseId(domainId);
        position.setCreatorId(userId);
        position.setCreatedate(new Date());
        position.setDeleted(0);
        Position parentPosition = (Position)this.getById(positionBO.getParentId());
        position.setFullpath(parentPosition.getFullpath() + positionId + ",,");
        this.positionPlusDao.insertSelective((BaseEntity)position);
        return positionId;
    }

    @Override
    public Integer update(@NotNull PositionBO positionBO) {
        Position oldPosition;
        Position validposition = this.getByCode(positionBO.getCode());
        if (validposition != null) {
            ExceptionUtil.handle((IRespStatusEnum)CoreResponseStatusEnum.ORGCODE_SAME);
        }
        if ((oldPosition = (Position)this.getById(positionBO.getPositionId())) == null) {
            return 0;
        }
        Position position = (Position)ConvertUtil.convert((Object)positionBO, Position.class);
        if (oldPosition.getParentId().longValue() != positionBO.getParentId().longValue()) {
            Position parentPosition = (Position)this.getById(positionBO.getParentId());
            position.setFullpath(parentPosition.getFullpath() + position.getParentId() + ",,");
            this.positionPlusDao.updateChildrenFullpath(oldPosition.getFullpath(), position.getFullpath());
        }
        return this.positionPlusDao.updateSelective(position);
    }

    @Override
    public Integer delete(@NotNull Long positionId) {
        return this.positionPlusDao.deleteAndChildren(positionId);
    }

    @Override
    public Integer getMaxOrderNum(@NotNull Long parentId) {
        PositionQuery query = new PositionQuery();
        query.setParentId(parentId);
        Integer maxOrdernum = (Integer)this.positionPlusDao.selectOne(query, "getMaxOrdernum");
        return maxOrdernum == null ? 0 : maxOrdernum;
    }

    @Override
    public Integer updateOrderNum(@NotEmpty List<PositionOrderNumBO> positionOrderNumBOList) {
        int updateNum = 0;
        for (PositionOrderNumBO positionOrderNumBO : positionOrderNumBOList) {
            Position position = new Position(positionOrderNumBO.getPositionId());
            position.setOrdernum(positionOrderNumBO.getOrdernum());
            updateNum += this.positionPlusDao.updateSelective(position);
        }
        return updateNum;
    }

    @Override
    public PositionDetailVO getInfo(@NotNull Long positionId) {
        Position Position2 = (Position)this.getById(positionId);
        PositionDetailVO positionDetailVO = (PositionDetailVO)ConvertUtil.convert((Object)Position2, PositionDetailVO.class);
        Position parentPosition = (Position)this.getById(Position2.getParentId());
        if (parentPosition != null) {
            positionDetailVO.setParentName(parentPosition.getName());
        }
        return positionDetailVO;
    }

    private List<Position> getList(Long domainId) {
        PositionQuery query = new PositionQuery();
        query.setDeleted(0);
        query.setDomainId(domainId);
        query.getPage().setSortColumns("p.PARENT_ID, p.ORDERNUM, p.CREATEDATE");
        return this.positionPlusDao.findList(query);
    }

    @Override
    public List<PositionMiniVO> getChildrenMiniVOList(@NotNull Long parentId) {
        PositionQuery query = new PositionQuery();
        query.setParentId(parentId);
        query.setDeleted(0);
        query.setColumns("p.POSITION_ID, p.NAME, p.ORDERNUM");
        query.getPage().setSortColumns("p.ORDERNUM, p.CREATEDATE");
        List positionList = this.positionPlusDao.findAll(query);
        return ConvertUtil.convert((List)positionList, PositionMiniVO.class);
    }

    @Override
    public List<PositionVO> getChildrenVOList(@NotNull Long parentId) {
        PositionQuery query = new PositionQuery();
        query.setParentId(parentId);
        query.setDeleted(0);
        query.getPage().setSortColumns("p.ORDERNUM, p.CREATEDATE");
        List positionList = this.positionPlusDao.findAll(query);
        List positionVOList = ConvertUtil.convert((List)positionList, PositionVO.class);
        UserCoreUtil.setUserRealname(positionVOList, PositionVO::getCreatorId, PositionVO::setCreatorname);
        return positionVOList;
    }

    @Override
    public List<PositionVO> searchPosition(@NotNull Long domainId, @NotNull String name) {
        PositionQuery query = new PositionQuery(1, 30);
        query.setDomainId(domainId);
        query.setDeleted(0);
        query.setName(name);
        query.setColumns("p.FULLPATH");
        List idpathList = this.positionPlusDao.findList(query);
        if (ListUtil.isNullorEmpty((List)idpathList)) {
            return new ArrayList<PositionVO>();
        }
        ArrayList<Long> positionIds = new ArrayList();
        for (Position idpathPosition : idpathList) {
            String idpath = idpathPosition.getFullpath();
            positionIds.addAll(StringUtil.splitToLongList((String)idpath, (String)","));
        }
        positionIds = ListUtil.removeDuplicate(positionIds);
        PositionQuery allQuery = new PositionQuery();
        allQuery.setPositionIds(positionIds);
        allQuery.getPage().setSortColumns("p.PARENT_ID, p.ORDERNUM, p.CREATEDATE");
        List positionList = this.positionPlusDao.findAll(allQuery);
        List positionVOS = ConvertUtil.convert((List)positionList, PositionVO.class);
        UserCoreUtil.setUserRealname(positionVOS, PositionVO::getCreatorId, PositionVO::setCreatorname);
        return ListUtil.convertToTree((List)positionVOS, (Long)0L, PositionVO::getPositionId, PositionVO::getParentId, PositionVO::getChildren, PositionVO::setChildren);
    }

    @Override
    public long count(Long enterpriseId) {
        PositionQuery query = new PositionQuery();
        query.setEnterpriseId(enterpriseId);
        query.setDeleted(0);
        return this.getPositionPlusDao().count(query);
    }

    public <VO> VO getVOById(Long positionId, Class<VO> clazz) {
        Position position = (Position)this.findById(positionId);
        if (position == null) {
            return null;
        }
        Object vo = ConvertUtil.convert((Object)position, clazz);
        return (VO)vo;
    }

    @Override
    public Position getByCode(String code) {
        PositionQuery query = new PositionQuery(1, 1);
        query.setCode(code);
        query.setDeleted(0);
        return (Position)this.positionPlusDao.findOne(query);
    }

    @Override
    public Position getByMatchCode(String matchCode) {
        PositionQuery query = new PositionQuery(1, 1);
        query.setMatchCode(matchCode);
        query.setDeleted(0);
        return (Position)this.positionPlusDao.findOne(query);
    }

    @Override
    public List<PositionMiniVO> getChildrenMiniVOList(@NotNull Long domainId, @NotNull Long parentId) {
        PositionQuery query = new PositionQuery();
        query.setParentId(parentId);
        query.setDeleted(0);
        query.setColumns("p.POSITION_ID, p.NAME, p.ORDERNUM");
        query.getPage().setSortColumns("p.ORDERNUM, p.CREATEDATE");
        List positionList = this.positionPlusDao.findAll(query);
        return ConvertUtil.convert((List)positionList, PositionMiniVO.class);
    }

    @Override
    public List<PositionVO> getChildrenVOList(@NotNull Long domainId, @NotNull Long parentId) {
        PositionQuery query = new PositionQuery();
        query.setParentId(parentId);
        query.setDeleted(0);
        query.getPage().setSortColumns("p.ORDERNUM, p.CREATEDATE");
        List positionList = this.positionPlusDao.findAll(query);
        List positionVOList = ConvertUtil.convert((List)positionList, PositionVO.class);
        UserCoreUtil.setUserRealname(positionVOList, PositionVO::getCreatorId, PositionVO::setCreatorname);
        return positionVOList;
    }
}

