/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.appsecurity.rbac.service.imple;

import com.peak.common.util.ListUtil;
import com.peak.common.util.SpringUtil;
import com.peak.prd.appsecurity.domain.model.Domain;
import com.peak.prd.appsecurity.domain.service.IDomainPlusService;
import com.peak.prd.appsecurity.org.dao.IOrgtreePlusDao;
import com.peak.prd.appsecurity.org.model.Org;
import com.peak.prd.appsecurity.org.model.Orgtree;
import com.peak.prd.appsecurity.org.service.IOrgPlusService;
import com.peak.prd.appsecurity.org.vo.OrgtreeQuery;
import com.peak.prd.appsecurity.rbac.service.IRbacStuService;
import com.peak.prd.appsecurity.user.model.UserOrg;
import com.peak.prd.appsecurity.user.service.IUserOrgPlusService;
import com.peak.prd.appsecurity.user.service.IUserPlusService;
import com.peak.prd.appsecurity.user.vo.UserOrgQuery;
import com.peak.prd.appsecurity.user.vo.UserVO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
@CacheConfig(cacheNames={"prd"})
public class RbacStuService
implements IRbacStuService {
    private static final Logger log = LoggerFactory.getLogger(RbacStuService.class);
    @Autowired
    IUserPlusService userPlusService;
    @Autowired
    IOrgtreePlusDao orgtreePlusDao;
    @Autowired
    IOrgPlusService orgPlusService;
    @Autowired
    IDomainPlusService domainPlusService;
    @Autowired
    IUserOrgPlusService userOrgPlusService;

    @Cacheable
    public List<Long> getUpOrgIds(Long orgId) {
        List<Long> list = this.getUpOrgIds(orgId, 0);
        if (list != null && list.size() >= 15) {
            log.warn("getUpOrgIds--list too long--{}", list);
        }
        return list;
    }

    private List<Long> getUpOrgIds(Long orgId, int callDepth) {
        if (orgId == null) {
            return null;
        }
        if (callDepth > 15) {
            log.warn("getUpOrgIds callDepth: {} by orgId: {}", (Object)callDepth, (Object)orgId);
            return null;
        }
        ArrayList<Long> treeIds = new ArrayList<Long>();
        treeIds.add(orgId);
        Long upId = ((IRbacStuService)SpringUtil.getBean(IRbacStuService.class)).getUpOrgId(orgId);
        if (upId == null) {
            return treeIds;
        }
        List<Long> upOrgIds = this.getUpOrgIds(upId, callDepth + 1);
        if (upOrgIds != null) {
            treeIds.addAll(upOrgIds);
        }
        return treeIds;
    }

    @Cacheable
    public Long getUpOrgId(Long orgId) {
        if (orgId == null) {
            return null;
        }
        OrgtreeQuery query = new OrgtreeQuery();
        query.setOrgId(orgId);
        query.setLinktype(0);
        Orgtree ot = (Orgtree)this.orgtreePlusDao.findOne(query);
        if (ot == null || ot.getParentId() == null || ot.getParentId().intValue() == 0) {
            return null;
        }
        if (ot.getParentId().longValue() == orgId.longValue()) {
            return null;
        }
        return ot.getParentId();
    }

    public Long getDeptId(Long userId) {
        if (userId == null) {
            log.warn("getDeptId[empty userId]");
            return null;
        }
        UserVO vo = (UserVO)this.userPlusService.findVOById(userId, UserVO.class);
        if (vo == null) {
            log.warn("userPlusService.findVOById return null");
            return null;
        }
        return vo.getDeptId();
    }

    @Cacheable
    public List<Long> getStuAllRealDomainIds(Long userId) {
        Long deptId = this.getDeptId(userId);
        if (deptId == null) {
            log.warn("deptId is null [userId:" + userId + "]");
            return null;
        }
        List upOrgIds = ((IRbacStuService)SpringUtil.getBean(IRbacStuService.class)).getUpOrgIds(deptId);
        if (upOrgIds == null) {
            log.warn("upOrgIds is null [userId:" + userId + ", deptId:" + deptId + "]");
            return null;
        }
        List<Long> ret = this.getUpDomainIds(upOrgIds);
        if (ret == null || ret.isEmpty()) {
            log.warn("getStuAllRealDomainIds empty [userId:" + userId + ", deptId:" + deptId + "]");
        }
        return ret;
    }

    private List<Long> getUpDomainIds(List<Long> upOrgIds) {
        Org org;
        ArrayList<Long> domainIds = new ArrayList<Long>();
        for (int i = 0; i < upOrgIds.size() && (org = (Org)this.orgPlusService.findById(upOrgIds.get(i))) != null; ++i) {
            if (org.getIsdomain() == null || org.getIsdomain() == 0) continue;
            domainIds.add(org.getOrgId());
        }
        return domainIds;
    }

    @Cacheable
    public List<Long> getStuDirectVirtualDomainIds(Long userId) {
        List<Long> ds2;
        ArrayList<Long> list = new ArrayList<Long>();
        List<Long> ds1 = this.getDirectVirtualDomainIdsByFilter(userId);
        if (ds1 != null && !ds1.isEmpty()) {
            list.addAll(ds1);
        }
        if ((ds2 = this.getDirectVirtualDomainIdsByNoFilter(userId)) != null && !ds2.isEmpty()) {
            list.addAll(ds2);
        }
        return list;
    }

    private List<Long> getDirectVirtualDomainIdsByFilter(Long userId) {
        if (userId == null) {
            return null;
        }
        UserOrgQuery userOrgQuery = new UserOrgQuery();
        userOrgQuery.setUserId(userId);
        List userOrgs = this.userOrgPlusService.findAll(userOrgQuery);
        if (userOrgs == null || userOrgs.isEmpty()) {
            return null;
        }
        ArrayList<Long> list = new ArrayList<Long>();
        for (int i = 0; i < userOrgs.size(); ++i) {
            UserOrg uo = (UserOrg)userOrgs.get(i);
            if (uo.getDomainId() == null || uo.getDomainId() == 0L) continue;
            list.add(uo.getDomainId());
        }
        return list.isEmpty() ? null : list;
    }

    private List<Long> getDirectVirtualDomainIdsByNoFilter(Long userId) {
        if (userId == null) {
            return null;
        }
        Long deptId = this.getDeptId(userId);
        if (deptId == null) {
            return null;
        }
        List<Long> upOrgIds = this.getUpOrgIds(deptId);
        if (upOrgIds == null) {
            return null;
        }
        OrgtreeQuery orgtreeQuery = new OrgtreeQuery();
        orgtreeQuery.setLinktype(1);
        orgtreeQuery.setOrgIdList(upOrgIds);
        List<Orgtree> orgtrees = this.orgtreePlusDao.getAll(orgtreeQuery);
        if (orgtrees == null || orgtrees.isEmpty()) {
            return null;
        }
        ArrayList<Long> parents = new ArrayList<Long>();
        for (int i = 0; i < orgtrees.size(); ++i) {
            boolean hasFilter;
            Domain domain;
            Orgtree ot = orgtrees.get(i);
            Long domainId = ot.getParentId();
            Org org = (Org)this.orgPlusService.findById(domainId);
            if (org == null || org.getIsdomain() == null || org.getIsdomain() == 0 || (domain = (Domain)this.domainPlusService.findById(domainId)) == null) continue;
            boolean bl = hasFilter = domain.getFilteruseron() != null && domain.getFilteruseron() == 1;
            if (hasFilter) continue;
            parents.add(domainId);
        }
        return parents;
    }

    @Cacheable
    public List<Long> getStuAllDomainIds(Long userId) {
        IRbacStuService self = (IRbacStuService)SpringUtil.getBean(IRbacStuService.class);
        ArrayList list = new ArrayList();
        List rList = self.getStuAllRealDomainIds(userId);
        if (rList != null && !rList.isEmpty()) {
            list.addAll(rList);
        }
        List vList = self.getStuDirectVirtualDomainIds(userId);
        for (int i = 0; vList != null && i < vList.size(); ++i) {
            Long vid = (Long)vList.get(i);
            List upOrgIds = self.getUpOrgIds(vid);
            if (upOrgIds == null) continue;
            list.addAll(upOrgIds);
        }
        return ListUtil.removeDuplicate(list);
    }
}

