/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.appsecurity.resource.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.ListUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.appsecurity.resource.bo.ResourceBO;
import com.peak.prd.appsecurity.resource.bo.ResourceOrderNumBO;
import com.peak.prd.appsecurity.resource.dao.IResourcePlusDao;
import com.peak.prd.appsecurity.resource.model.Resource;
import com.peak.prd.appsecurity.resource.service.IResourcePlusService;
import com.peak.prd.appsecurity.resource.vo.ResourceDetailVO;
import com.peak.prd.appsecurity.resource.vo.ResourceMiniVO;
import com.peak.prd.appsecurity.resource.vo.ResourceQuery;
import com.peak.prd.appsecurity.resource.vo.ResourceSelectedVO;
import com.peak.prd.appsecurity.resource.vo.ResourceVO;
import com.peak.prd.base.annotation.ClearCache;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.enums.MenuTypeEnum;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.stereotype.Service;

@Service
@CacheConfig(cacheNames={"prd"})
public class ResourcePlusService
extends PrdBaseService<Resource, Long, ResourceQuery>
implements IResourcePlusService {
    private IResourcePlusDao resourcePlusDao;

    public void setResourcePlusDao(IResourcePlusDao dao) {
        this.resourcePlusDao = dao;
    }

    public IResourcePlusDao getResourcePlusDao() {
        return this.resourcePlusDao;
    }

    public IEntityDao<Resource, Long, ResourceQuery> getEntityDao() {
        return this.resourcePlusDao;
    }

    @Override
    @Cacheable
    public List<Resource> findMgnNavResource() {
        ResourceQuery query = new ResourceQuery();
        return this.getResourcePlusDao().findAll(query, "findMgnNavResource");
    }

    @Override
    @Cacheable
    public List<Long> findMgnNavResourceIds() {
        ResourceQuery query = new ResourceQuery();
        query.setColumns("re.resource_id");
        List resources = this.getResourcePlusDao().findAll(query, "findMgnNavResource");
        return IdUtil.getIds((List)resources, Resource::getResourceId);
    }

    @Override
    public Long txInsert(@NotNull Long userId, @NotNull ResourceBO resourceBO) {
        Resource resource = (Resource)ConvertUtil.convert((Object)resourceBO, Resource.class);
        Long resourceId = IdUtil.getSequence((String)"TRESOURCE");
        resource.setResourceId(resourceId);
        resource.setGkey(IdUtil.getGkey());
        resource.setCreatorId(userId);
        resource.setCreatedate(new Date());
        resource.setIsleaf(resource.getType() == 5 ? 0 : 1);
        this.resourcePlusDao.insert((BaseEntity)resource);
        if (resource.getType() != 5) {
            Resource parentResource = new Resource(resource.getParentId());
            parentResource.setIsleaf(0);
            this.resourcePlusDao.updateSelective(parentResource);
        }
        return resourceId;
    }

    @Override
    @ClearCache(value="#resourceBO.resourceId")
    public Integer txUpdate(@NotNull ResourceBO resourceBO) {
        Resource oldResource = (Resource)this.getById(resourceBO.getResourceId());
        if (oldResource == null) {
            return 0;
        }
        Resource resource = (Resource)ConvertUtil.convert((Object)resourceBO, Resource.class);
        int updateNum = this.resourcePlusDao.updateSelective(resource);
        this.updateIsleaf(resource.getResourceId());
        this.updateIsleaf(resource.getParentId());
        if (oldResource.getParentId().longValue() != resource.getParentId().longValue()) {
            this.updateIsleaf(oldResource.getParentId());
        }
        return updateNum;
    }

    @Override
    public Long findChildrenNum(@NotNull Long parentId, Integer type) {
        ResourceQuery query = new ResourceQuery();
        query.setParentId(parentId);
        query.setValId(1);
        if (type != null) {
            query.setType(type);
        }
        return this.resourcePlusDao.count(query);
    }

    @Override
    @ClearCache(value="#resourceId")
    public Integer txDelete(@NotNull Long resourceId) {
        Resource resource = (Resource)this.getById(resourceId);
        if (resource == null) {
            return 0;
        }
        int deleteNum = this.deleteById(resourceId);
        if (deleteNum > 0) {
            this.updateIsleaf(resource.getParentId());
        }
        return deleteNum;
    }

    @Override
    public Integer getMaxOrderNum(@NotNull Long parentId) {
        ResourceQuery query = new ResourceQuery();
        query.setParentId(parentId);
        Integer maxOrdernum = (Integer)this.resourcePlusDao.selectOne(query, "getMaxOrdernum");
        return maxOrdernum == null ? 0 : maxOrdernum;
    }

    @Override
    @ClearCache(value="#resourceId")
    public Integer txUpdateValId(@NotNull Long resourceId, @NotNull Integer valId) {
        int updateNum = 0;
        Resource resource = (Resource)this.getById(resourceId);
        if (resource == null) {
            return updateNum;
        }
        if (resource.getValId().intValue() != valId.intValue()) {
            Resource updateResource = new Resource(resourceId);
            updateResource.setValId(valId);
            updateNum = this.resourcePlusDao.updateSelective(updateResource);
            if (updateNum > 0) {
                this.updateIsleaf(resource.getParentId());
            }
        }
        return updateNum;
    }

    @Override
    public List<ResourceMiniVO> getChildrenMiniVOList(@NotNull Long parentId) {
        ResourceQuery query = new ResourceQuery();
        query.setParentId(parentId);
        query.setColumns("re.RESOURCE_ID, re.NAME, re.ORDERNUM");
        query.getPage().setSortColumns("re.ORDERNUM, re.CREATEDATE");
        List resourceList = this.resourcePlusDao.findAll(query);
        return ConvertUtil.convert((List)resourceList, ResourceMiniVO.class);
    }

    @Override
    public Integer updateOrderNum(@NotEmpty List<ResourceOrderNumBO> resourceOrderNumBOList) {
        int updateNum = 0;
        for (ResourceOrderNumBO resourceOrderNumBO : resourceOrderNumBOList) {
            Resource resource = new Resource(resourceOrderNumBO.getResourceId());
            resource.setOrdernum(resourceOrderNumBO.getOrdernum());
            updateNum += this.resourcePlusDao.updateSelective(resource);
        }
        return updateNum;
    }

    @Override
    public ResourceDetailVO getInfo(@NotNull Long resourceId) {
        Resource resource = (Resource)this.getById(resourceId);
        return (ResourceDetailVO)ConvertUtil.convert((Object)resource, ResourceDetailVO.class);
    }

    @Override
    public List<ResourceVO> getMngList() {
        List<Resource> resourceList = this.getList(null);
        List resourceVOList = ListUtil.convertToTree((List)ConvertUtil.convert(resourceList, ResourceVO.class), (Long)0L, ResourceVO::getResourceId, ResourceVO::getParentId, ResourceVO::getChildren, ResourceVO::setChildren);
        return resourceVOList;
    }

    @Override
    public List<ResourceSelectedVO> getSelectedList() {
        List<Resource> resourceList = this.getList(1);
        List resourceVOList = ListUtil.convertToTree((List)ConvertUtil.convert(resourceList, ResourceSelectedVO.class), (Long)0L, ResourceMiniVO::getResourceId, ResourceSelectedVO::getParentId, ResourceSelectedVO::getChildren, ResourceSelectedVO::setChildren);
        return resourceVOList;
    }

    @Override
    public List<Resource> getList(Integer valId) {
        ResourceQuery query = new ResourceQuery();
        if (valId != null) {
            query.setValId(valId);
        }
        query.getPage().setSortColumns("re.PARENT_ID, re.ORDERNUM, re.CREATEDATE");
        return this.resourcePlusDao.findAll(query);
    }

    @Override
    @Cacheable
    public List<Resource> getAllOperateList() {
        ResourceQuery query = new ResourceQuery();
        query.setValId(1);
        query.setType(MenuTypeEnum.OPERATE.getValue());
        query.getPage().setSortColumns("re.RESOURCE_ID");
        return this.resourcePlusDao.findAll(query);
    }

    private int updateIsleaf(Long resourceId) {
        Resource parentResource = (Resource)this.getById(resourceId);
        if (parentResource == null) {
            return 0;
        }
        int parentIsleaf = 0;
        if (parentResource.getType() != 5) {
            parentIsleaf = this.findChildrenNum(resourceId, 4) == 0L ? 1 : 0;
        }
        parentResource.setIsleaf(parentIsleaf);
        return this.resourcePlusDao.updateSelective(parentResource);
    }

    @Caching(evict={@CacheEvict(cacheNames={"prd"}, key="'ResourcePlusService:' + #resourceId"), @CacheEvict(cacheNames={"prd"}, key="'ResourcePlusService:findMgnNavResourceIds:'"), @CacheEvict(cacheNames={"prd"}, key="'ResourcePlusService:findMgnNavResource:'"), @CacheEvict(cacheNames={"prd"}, key="'ResourcePlusService:getAllOperateList:'")})
    public void clearCache(Long resourceId) {
    }
}

