/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.appsecurity.role.service.imple;

import com.alibaba.fastjson.JSONObject;
import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.ListUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.appsecurity.role.bo.RoleBO;
import com.peak.prd.appsecurity.role.bo.RoleQueryBO;
import com.peak.prd.appsecurity.role.dao.IRolePlusDao;
import com.peak.prd.appsecurity.role.model.Role;
import com.peak.prd.appsecurity.role.service.IRolePlusService;
import com.peak.prd.appsecurity.role.vo.RoleDetailVO;
import com.peak.prd.appsecurity.role.vo.RoleQuery;
import com.peak.prd.appsecurity.role.vo.RoleVO;
import com.peak.prd.appsecurity.user.service.IUserOrgRolePlusService;
import com.peak.prd.appsecurity.user.util.UserCoreUtil;
import com.peak.prd.base.annotation.ClearCache;
import com.peak.prd.base.model.Paging;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.messageq.util.MessageQHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Caching;
import org.springframework.stereotype.Service;

@Service
public class RolePlusService
extends PrdBaseService<Role, Long, RoleQuery>
implements IRolePlusService {
    @Resource
    private IUserOrgRolePlusService userOrgRolePlusService;
    private IRolePlusDao rolePlusDao;

    public void setRolePlusDao(IRolePlusDao dao) {
        this.rolePlusDao = dao;
    }

    public IRolePlusDao getRolePlusDao() {
        return this.rolePlusDao;
    }

    public IEntityDao<Role, Long, RoleQuery> getEntityDao() {
        return this.rolePlusDao;
    }

    @Override
    public Long insert(@NotNull Long userId, @NotNull Long domainId, RoleBO roleBO) {
        Role role = (Role)ConvertUtil.convert((Object)roleBO, Role.class);
        Long roleId = IdUtil.getSequence((String)"TROLE");
        role.setRoleId(roleId);
        role.setGkey(IdUtil.getGkey());
        role.setDeleted(0);
        role.setDomainId(domainId);
        role.setCreatorId(userId);
        role.setCreatedate(new Date());
        role.setInheritable(1);
        this.rolePlusDao.insert((BaseEntity)role);
        JSONObject jObj = new JSONObject();
        jObj.put("rolecode", (Object)role.getRolecode());
        jObj.put("rolename", (Object)role.getRolename());
        MessageQHelper.send("role", roleId, "add", jObj);
        return roleId;
    }

    @Override
    @ClearCache(value="#roleBO.roleId")
    public Integer update(RoleBO roleBO) {
        Role role = (Role)ConvertUtil.convert((Object)roleBO, Role.class);
        JSONObject jObj = new JSONObject();
        jObj.put("rolecode", (Object)role.getRolecode());
        jObj.put("rolename", (Object)role.getRolename());
        MessageQHelper.send("role", role.getRoleId(), "update", jObj);
        return this.rolePlusDao.updateSelective(role);
    }

    @Override
    @ClearCache(value="#roleId")
    public Integer delete(@NotNull Long roleId) {
        Role role = new Role(roleId);
        role.setDeleted(1);
        role.setDeletedate(new Date());
        JSONObject jObj = new JSONObject();
        jObj.put("rolecode", (Object)role.getRolecode());
        jObj.put("rolename", (Object)role.getRolename());
        MessageQHelper.send("role", role.getRoleId(), "delete", jObj);
        return this.rolePlusDao.updateSelective(role);
    }

    @Override
    public RoleDetailVO getInfo(@NotNull Long roleId) {
        Role role = (Role)this.getById(roleId);
        return (RoleDetailVO)ConvertUtil.convert((Object)role, RoleDetailVO.class);
    }

    @Override
    public Paging<RoleVO> getMngVOList(RoleQueryBO roleQueryBO) {
        RoleQuery query = new RoleQuery(roleQueryBO.getPageNumber(), roleQueryBO.getPageSize());
        ConvertUtil.copyProperties((Object)((Object)roleQueryBO), (Object)query);
        query.setDeleted(0);
        query.getPage().setSortColumns("ro.CREATEDATE DESC");
        Paging roleListVOPaging = this.rolePlusDao.findPaging(query, RoleVO.class);
        List roleVOList = roleListVOPaging.getList();
        if (ListUtil.isNullorEmpty((List)roleVOList)) {
            return roleListVOPaging;
        }
        UserCoreUtil.setUserVO(roleVOList, RoleVO::getCreatorId, RoleVO::setUserVO);
        return roleListVOPaging;
    }

    @Override
    public List<RoleVO> getMayGrantRoleList(Long userId, Long curMngDomainId) {
        List<Long> curdomainRoleIdList = this.getCurdomainRoleIds(curMngDomainId);
        List hasRoleIdList = this.userOrgRolePlusService.getHasRoleIdList(userId);
        List hasRoleList = this.findByIds(hasRoleIdList);
        hasRoleList = hasRoleList.stream().sorted(Comparator.comparing(Role::getCreatedate).reversed()).collect(Collectors.toList());
        hasRoleIdList = IdUtil.getIds(hasRoleList, Role::getRoleId);
        List<Long> mayGrantRoleIdList = new ArrayList<Long>();
        mayGrantRoleIdList.addAll(curdomainRoleIdList);
        mayGrantRoleIdList.addAll(hasRoleIdList);
        mayGrantRoleIdList = ListUtil.removeDuplicate(mayGrantRoleIdList);
        return this.findVOsByIds(mayGrantRoleIdList, RoleVO.class);
    }

    private List<Long> getCurdomainRoleIds(Long curMngDomainId) {
        RoleQuery query = new RoleQuery();
        query.setDomainId(curMngDomainId);
        query.setDeleted(0);
        query.getPage().setSortColumns("ro.CREATEDATE DESC");
        query.setColumns("ro.ROLE_ID");
        List roleList = this.rolePlusDao.findAll(query);
        return IdUtil.getIds((List)roleList, Role::getRoleId);
    }

    @Caching(evict={@CacheEvict(cacheNames={"prd"}, key="'RolePlusService:' + #roleId"), @CacheEvict(cacheNames={"prd"}, key="'RolePlusService:RoleVO:' + #roleId"), @CacheEvict(cacheNames={"prd"}, key="'RolePlusService:RoleDetailVO:' + #roleId")})
    public void clearCache(Long roleId) {
    }

    public <VO> VO getVOById(Long roleId, Class<VO> clazz) {
        Role role = (Role)this.getById(roleId);
        if (role == null) {
            return null;
        }
        Object vo = ConvertUtil.convert((Object)role, clazz);
        return (VO)vo;
    }
}

