/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.appsecurity.role.service.imple;

import com.peak.common.util.IdUtil;
import com.peak.common.util.ListUtil;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.appsecurity.role.bo.RoleResourceBO;
import com.peak.prd.appsecurity.role.dao.IRoleResourcePlusDao;
import com.peak.prd.appsecurity.role.model.RoleResource;
import com.peak.prd.appsecurity.role.service.IRoleResourcePlusService;
import com.peak.prd.appsecurity.role.vo.RoleResourceQuery;
import com.peak.prd.base.annotation.ClearCache;
import com.peak.prd.base.service.imple.PrdBaseService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@CacheConfig(cacheNames={"prd"})
public class RoleResourcePlusService
extends PrdBaseService<RoleResource, Map<String, Object>, RoleResourceQuery>
implements IRoleResourcePlusService {
    private IRoleResourcePlusDao roleResourcePlusDao;
    @Autowired
    @Lazy
    private IRoleResourcePlusService self;

    public void setRoleResourcePlusDao(IRoleResourcePlusDao dao) {
        this.roleResourcePlusDao = dao;
    }

    public IRoleResourcePlusDao getRoleResourcePlusDao() {
        return this.roleResourcePlusDao;
    }

    public IEntityDao<RoleResource, Map<String, Object>, RoleResourceQuery> getEntityDao() {
        return this.roleResourcePlusDao;
    }

    @Override
    public List<Long> getResourceIdsByRoleIds(List<Long> roleIds) {
        ArrayList<Long> resourceIds = new ArrayList<Long>();
        for (Long roleId : roleIds) {
            resourceIds.addAll(this.self.findResourceIdsByRoleId(roleId));
        }
        return ListUtil.removeDuplicate(resourceIds);
    }

    @Override
    @Cacheable
    public List<Long> findResourceIdsByRoleId(Long roleId) {
        RoleResourceQuery query = new RoleResourceQuery();
        query.setRoleId(roleId);
        query.setColumns("rr.resource_id");
        query.getPage().setSortColumns("rr.resource_id");
        List roleResources = this.getRoleResourcePlusDao().findAll(query);
        return IdUtil.getIds((List)roleResources, RoleResource::getResourceId);
    }

    @Override
    public Integer deleteByRoleId(@NotNull Long roleId) {
        return this.getRoleResourcePlusDao().deleteByRoleId(roleId);
    }

    @Override
    @ClearCache(value="#roleResourceBO.roleId")
    public Integer txSave(Long userId, RoleResourceBO roleResourceBO) {
        this.roleResourcePlusDao.deleteByRoleId(roleResourceBO.getRoleId());
        Date now = new Date();
        ArrayList<RoleResource> roleResourceList = new ArrayList<RoleResource>();
        for (Long resourceId : roleResourceBO.getResourceIdList()) {
            RoleResource roleResource = new RoleResource();
            roleResource.setRoleId(roleResourceBO.getRoleId());
            roleResource.setResourceId(resourceId);
            roleResource.setCreatorId(userId);
            roleResource.setCreatedate(now);
            roleResourceList.add(roleResource);
        }
        return this.roleResourcePlusDao.insertBatch(roleResourceList);
    }

    @Override
    @Cacheable
    public List<Long> getRoleIdsByResourceId(Long resourceId) {
        RoleResourceQuery query = new RoleResourceQuery();
        query.setResourceId(resourceId);
        query.setColumns("rr.ROLE_ID");
        query.getPage().setSortColumns("rr.ROLE_ID");
        List roleResources = this.getRoleResourcePlusDao().findAll(query);
        return IdUtil.getIds((List)roleResources, RoleResource::getRoleId);
    }

    @Caching(evict={@CacheEvict(cacheNames={"prd"}, key="'RoleResourcePlusService:findResourceIdsByRoleId:' + #roleId")})
    public void clearCache(Long roleId) {
    }
}

