/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.appsecurity.role.util;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.ListUtil;
import com.peak.common.util.SpringUtil;
import com.peak.prd.appsecurity.role.model.Role;
import com.peak.prd.appsecurity.role.service.IRolePlusService;
import com.peak.prd.appsecurity.role.service.imple.RolePlusService;
import com.peak.prd.appsecurity.role.vo.RoleDetailVO;
import com.peak.prd.appsecurity.role.vo.RoleVO;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class RoleUtil {
    public static <VO> void setRoleVO(List<VO> originVOList, Function<VO, Long> getRoleIdFunc, BiConsumer<VO, RoleVO> setRoleVOFunc) {
        if (ListUtil.isNullorEmpty(originVOList)) {
            return;
        }
        List roleIdList = IdUtil.getIds(originVOList, getRoleIdFunc);
        roleIdList = ListUtil.removeDuplicate((List)roleIdList);
        IRolePlusService rolePlusService = (IRolePlusService)SpringUtil.getBean(RolePlusService.class);
        List roleVOList = rolePlusService.findVOsByIds(roleIdList, RoleVO.class);
        Map roleVOMap = ConvertUtil.listToMap((List)roleVOList, RoleDetailVO::getRoleId);
        for (VO vo : originVOList) {
            RoleVO roleVO;
            if (vo == null || (roleVO = (RoleVO)roleVOMap.get(getRoleIdFunc.apply(vo))) == null) continue;
            setRoleVOFunc.accept(vo, roleVO);
        }
    }

    public static Role getRole(Long roleId) {
        if (roleId == null) {
            return null;
        }
        IRolePlusService rolePlusService = (IRolePlusService)SpringUtil.getBean(RolePlusService.class);
        return (Role)rolePlusService.findById(roleId);
    }
}

