/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.appsecurity.user.dao.imple;

import com.peak.common.util.ListUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.prd.appsecurity.user.dao.IUserPlusDao;
import com.peak.prd.appsecurity.user.model.User;
import com.peak.prd.appsecurity.user.vo.UserQuery;
import com.peak.prd.base.dao.imple.PrdBaseDao;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class UserPlusDao
extends PrdBaseDao<User, Long, UserQuery>
implements IUserPlusDao {
    public int insert(User u) {
        if (u == null) {
            return 0;
        }
        if (u.getUsername() != null) {
            u.setUsername(u.getUsername().trim().toLowerCase());
        }
        if (u.getUsercode() != null) {
            u.setUsercode(u.getUsercode().trim().toUpperCase());
        }
        if (u.getEmail() != null) {
            u.setEmail(u.getEmail().trim().toLowerCase());
        }
        if (u.getCardnum() != null) {
            u.setCardnum(u.getCardnum().trim().toUpperCase());
        }
        return super.insert((BaseEntity)u);
    }

    @Override
    public User getByUsername(String username) {
        return (User)this.getSqlSessionTemplate().selectOne(this.getNamespace() + ".getByUsername", (Object)username);
    }

    @Override
    public User getByUsercode(String usercode) {
        return (User)this.getSqlSessionTemplate().selectOne(this.getNamespace() + ".getByUsercode", (Object)usercode);
    }

    @Override
    public Integer updateUser(User user) {
        return this.getSqlSessionTemplate().update(this.getNamespace() + ".updateUser", (Object)user);
    }

    @Override
    public Integer updateStatusBatch(List<Long> userIds, Integer status) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userIds", userIds);
        params.put("status", status);
        return this.getSqlSessionTemplate().update(this.getNamespace() + ".updateStatusBatch", params);
    }

    @Override
    public Integer deleteBatch(List<Long> userIds) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userIds", userIds);
        params.put("deletedate", new Date());
        return this.getSqlSessionTemplate().update(this.getNamespace() + ".deleteBatch", params);
    }

    @Override
    public List<User> getListByUsernameList(List<String> usernameList) {
        if (ListUtil.isNullorEmpty(usernameList)) {
            return new ArrayList<User>();
        }
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("usernameList", usernameList);
        return this.getSqlSessionTemplate().selectList(this.getNamespace() + ".getListByUsernameList", params);
    }

    @Override
    public List<User> getListByUsercodeList(List<String> usercodeList) {
        if (ListUtil.isNullorEmpty(usercodeList)) {
            return new ArrayList<User>();
        }
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("usercodeList", usercodeList);
        return this.getSqlSessionTemplate().selectList(this.getNamespace() + ".getListByUsercodeList", params);
    }

    @Override
    public List<User> getListByUsercode(String usercode) {
        return this.getSqlSessionTemplate().selectList(this.getNamespace() + ".getByUsercode", (Object)usercode);
    }
}

