/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.appsecurity.user.service.imple;

import com.peak.common.util.IdUtil;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.appsecurity.user.dao.IUserLeaderPlusDao;
import com.peak.prd.appsecurity.user.model.UserLeader;
import com.peak.prd.appsecurity.user.service.IUserLeaderPlusService;
import com.peak.prd.appsecurity.user.vo.UserLeaderQuery;
import com.peak.prd.base.service.imple.PrdBaseService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class UserLeaderPlusService
extends PrdBaseService<UserLeader, Map<String, Object>, UserLeaderQuery>
implements IUserLeaderPlusService {
    private IUserLeaderPlusDao userLeaderPlusDao;

    public void setUserLeaderPlusDao(IUserLeaderPlusDao dao) {
        this.userLeaderPlusDao = dao;
    }

    public IUserLeaderPlusDao getUserLeaderPlusDao() {
        return this.userLeaderPlusDao;
    }

    public IEntityDao<UserLeader, Map<String, Object>, UserLeaderQuery> getEntityDao() {
        return this.userLeaderPlusDao;
    }

    @Override
    public void insertBatch(Long userId, List<Long> leaderIds, Long creatorId) {
        ArrayList<UserLeader> userLeaders = new ArrayList<UserLeader>();
        Date curDate = new Date();
        for (Long leaderId : leaderIds) {
            UserLeader userLeader = new UserLeader();
            userLeader.setUserId(userId);
            userLeader.setLeaderId(leaderId);
            userLeader.setCreatorId(creatorId);
            userLeader.setCreatedate(curDate);
            userLeaders.add(userLeader);
        }
        this.getUserLeaderPlusDao().insertBatch(userLeaders);
    }

    @Override
    public Integer update(Long userId, List<Long> leaderIds, Long updaterId) {
        int row = this.getUserLeaderPlusDao().deleteByUserId(userId);
        this.insertBatch(userId, leaderIds, updaterId);
        return row;
    }

    @Override
    public List<Long> getLeaderIdsByUserId(Long userId) {
        UserLeaderQuery query = new UserLeaderQuery();
        query.setUserId(userId);
        query.setColumns("ul.leader_id");
        query.getPage().setSortColumns("ul.createdate");
        List userLeaders = this.getUserLeaderPlusDao().findAll(query);
        return IdUtil.getIds((List)userLeaders, UserLeader::getLeaderId);
    }

    @Override
    public Integer deleteByUserId(Long userId) {
        return this.getUserLeaderPlusDao().deleteByUserId(userId);
    }
}

