/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.appsecurity.user.service.imple;

import com.peak.common.util.ListUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.appsecurity.domain.model.Domain;
import com.peak.prd.appsecurity.domain.service.IDomainPlusService;
import com.peak.prd.appsecurity.user.dao.IUserOrgPlusDao;
import com.peak.prd.appsecurity.user.model.UserOrg;
import com.peak.prd.appsecurity.user.service.IUserOrgPlusService;
import com.peak.prd.appsecurity.user.vo.UserOrgQuery;
import com.peak.prd.base.service.imple.PrdBaseService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class UserOrgPlusService
extends PrdBaseService<UserOrg, Map<String, Object>, UserOrgQuery>
implements IUserOrgPlusService {
    @Resource
    private IDomainPlusService domainPlusService;
    private IUserOrgPlusDao userOrgPlusDao;

    public void setUserOrgPlusDao(IUserOrgPlusDao dao) {
        this.userOrgPlusDao = dao;
    }

    public IUserOrgPlusDao getUserOrgPlusDao() {
        return this.userOrgPlusDao;
    }

    public IEntityDao<UserOrg, Map<String, Object>, UserOrgQuery> getEntityDao() {
        return this.userOrgPlusDao;
    }

    @Override
    public UserOrg getUserOrg(Long userId) {
        UserOrgQuery userOrgQuery = new UserOrgQuery();
        userOrgQuery.setUserId(userId);
        userOrgQuery.setDomainId(0L);
        List userOrgs = this.getUserOrgPlusDao().findAll(userOrgQuery);
        if (userOrgs.size() > 0) {
            return (UserOrg)userOrgs.get(0);
        }
        return null;
    }

    @Override
    public void insert(Long userId, Long orgId, Long domainId, Long creatorId) {
        UserOrg userOrg = new UserOrg();
        userOrg.setUserId(userId);
        userOrg.setOrgId(orgId);
        userOrg.setDomainId(domainId);
        userOrg.setCreatorId(creatorId);
        userOrg.setCreatedate(new Date());
        this.getUserOrgPlusDao().insertSelective((BaseEntity)userOrg);
    }

    @Override
    public int delete(Long userId, Long orgId, Long domainId) {
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("userId", userId);
        param.put("orgId", orgId);
        param.put("domainId", domainId);
        return this.getUserOrgPlusDao().deleteById(param);
    }

    @Override
    public void txFreshFilteruserDomain(Long domainId) {
        this.getUserOrgPlusDao().deleteAllFilteruserDomainUser(domainId);
        Domain domain = (Domain)this.domainPlusService.getById(domainId);
        String whereSql = domain.getRulesql();
        this.getUserOrgPlusDao().insertAllFilteruserDomainUser(domainId, whereSql);
    }

    @Override
    public long getUserCount(Long orgId) {
        return this.userOrgPlusDao.getUserCount(orgId);
    }

    @Override
    public List<UserOrg> getUserFilterVirtualDomains(Long userId) {
        List<UserOrg> userOrgList = this.getUserOrgList(userId);
        if (ListUtil.isNullorEmpty(userOrgList)) {
            return new ArrayList<UserOrg>();
        }
        ArrayList<UserOrg> userVirtualOrgList = new ArrayList<UserOrg>();
        for (UserOrg userOrg : userOrgList) {
            if (userOrg.getDomainId() <= 0L) continue;
            userVirtualOrgList.add(userOrg);
        }
        return userVirtualOrgList;
    }

    @Override
    public List<UserOrg> getUserOrgList(Long userId) {
        UserOrgQuery query = new UserOrgQuery();
        query.setUserId(userId);
        query.getPage().setSortColumns("uo.createdate");
        return this.userOrgPlusDao.findAll(query);
    }
}

