/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.appsecurity.user.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.ListUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.appsecurity.domain.vo.MngDomainVO;
import com.peak.prd.appsecurity.org.model.Org;
import com.peak.prd.appsecurity.org.service.IOrgPlusService;
import com.peak.prd.appsecurity.org.util.OrgUtil;
import com.peak.prd.appsecurity.org.vo.OrgVO;
import com.peak.prd.appsecurity.rbac.service.IRbacPlusService;
import com.peak.prd.appsecurity.resource.model.Resource;
import com.peak.prd.appsecurity.resource.service.IResourcePlusService;
import com.peak.prd.appsecurity.resource.vo.PermissionVO;
import com.peak.prd.appsecurity.resource.vo.ResourceVO;
import com.peak.prd.appsecurity.role.model.Role;
import com.peak.prd.appsecurity.role.service.IRoleResourcePlusService;
import com.peak.prd.appsecurity.role.util.RoleUtil;
import com.peak.prd.appsecurity.user.bo.UserOrgRoleBO;
import com.peak.prd.appsecurity.user.bo.UserOrgRoleQueryBO;
import com.peak.prd.appsecurity.user.dao.IUserOrgRolePlusDao;
import com.peak.prd.appsecurity.user.export.model.UserOrgRoleExcelModel;
import com.peak.prd.appsecurity.user.model.UserOrgRole;
import com.peak.prd.appsecurity.user.model.Userextend;
import com.peak.prd.appsecurity.user.service.IUserOrgRolePlusService;
import com.peak.prd.appsecurity.user.service.IUserextendPlusService;
import com.peak.prd.appsecurity.user.util.UserCoreUtil;
import com.peak.prd.appsecurity.user.vo.UserOrgRoleMngVO;
import com.peak.prd.appsecurity.user.vo.UserOrgRoleQuery;
import com.peak.prd.appsecurity.user.vo.UserVO;
import com.peak.prd.base.annotation.AsynExport;
import com.peak.prd.base.model.Paging;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.base.util.ExceptionUtil;
import com.peak.prd.enums.MenuTypeEnum;
import com.peak.prd.enums.SysInitData;
import com.peak.prd.sys.impexpinfo.vo.ExportInfoVO;
import com.peak.prd.sys.tracelog.util.TracelogUtil;
import com.peak.tools.easyexcel.util.ExcelWriteUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@CacheConfig(cacheNames={"prd"})
public class UserOrgRolePlusService
extends PrdBaseService<UserOrgRole, Map<String, Object>, UserOrgRoleQuery>
implements IUserOrgRolePlusService {
    private static final Logger log = LoggerFactory.getLogger(UserOrgRolePlusService.class);
    private IUserOrgRolePlusDao userOrgRolePlusDao;
    @Autowired
    private IUserextendPlusService userextendPlusService;
    @Autowired
    private IOrgPlusService orgPlusService;
    @Autowired
    private IRoleResourcePlusService roleResourcePlusService;
    @Autowired
    private IResourcePlusService resourcePlusService;
    @Autowired
    private IRbacPlusService rbacPlusService;
    @Autowired
    @Lazy
    private IUserOrgRolePlusService self;

    public void setUserOrgRolePlusDao(IUserOrgRolePlusDao dao) {
        this.userOrgRolePlusDao = dao;
    }

    public IUserOrgRolePlusDao getUserOrgRolePlusDao() {
        return this.userOrgRolePlusDao;
    }

    public IEntityDao<UserOrgRole, Map<String, Object>, UserOrgRoleQuery> getEntityDao() {
        return this.userOrgRolePlusDao;
    }

    @Override
    public MngDomainVO getDefMngDomain(Long userId) {
        Userextend userextend = (Userextend)this.userextendPlusService.getById(userId);
        if (userextend.getDefmngdomainId() != null) {
            List<UserOrgRole> userOrgRoles = this.getUserOrgRoleListByUserIdDomainId(userId, userextend.getDefmngdomainId());
            if (ListUtil.isNullorEmpty(userOrgRoles)) {
                this.userextendPlusService.updateDefMngDomain(userId, null);
            } else {
                MngDomainVO mngDomainVO = this.getMngDomainVO(userextend.getDefmngdomainId());
                if (mngDomainVO.getDeleted() == 0) {
                    mngDomainVO.setIsDefMngDomain(1);
                    return mngDomainVO;
                }
            }
        }
        UserOrgRoleQuery query = new UserOrgRoleQuery(1, 1);
        query.setUserId(userId);
        query.setColumns("uor.org_id");
        List userOrgRoleList = this.getUserOrgRolePlusDao().findList(query, "getValidOrgByUserId");
        if (!userOrgRoleList.isEmpty()) {
            UserOrgRole userOrgRole = (UserOrgRole)userOrgRoleList.get(0);
            MngDomainVO mngDomainVO = this.getMngDomainVO(userOrgRole.getOrgId());
            mngDomainVO.setIsDefMngDomain(1);
            return mngDomainVO;
        }
        return null;
    }

    private MngDomainVO getMngDomainVO(Long domainId) {
        Org org = (Org)this.orgPlusService.findById(domainId);
        return (MngDomainVO)ConvertUtil.convert((Object)org, MngDomainVO.class);
    }

    @Override
    @Cacheable
    public Long findMngDomainCount(Long userId) {
        UserOrgRoleQuery query = new UserOrgRoleQuery();
        query.setUserId(userId);
        return this.getUserOrgRolePlusDao().count(query, "findMngDomainCount");
    }

    @Override
    public List<MngDomainVO> getMngDomainList(Long userId) {
        UserOrgRoleQuery query = new UserOrgRoleQuery();
        query.setUserId(userId);
        query.setColumns("uor.org_id");
        query.getPage().setSortColumns("uor.createdate");
        List userOrgRoleList = this.getUserOrgRolePlusDao().findAll(query);
        if (ListUtil.isNullorEmpty((List)userOrgRoleList)) {
            return new ArrayList<MngDomainVO>();
        }
        List orgIdList = IdUtil.getIds((List)userOrgRoleList, UserOrgRole::getOrgId);
        List orgIds = ListUtil.removeDuplicate((List)orgIdList);
        List orgList = this.orgPlusService.findByIds(orgIds);
        ListUtil.removeAllNull((List)orgList);
        orgList = orgList.stream().filter(e -> e.getDeleted() == 0).collect(Collectors.toList());
        List mngDomainVOList = ConvertUtil.convert(orgList, MngDomainVO.class);
        ConvertUtil.setProperties((List)mngDomainVOList, e -> e.setIsDefMngDomain(0));
        ((MngDomainVO)mngDomainVOList.get(0)).setIsDefMngDomain(1);
        Userextend userextend = (Userextend)this.userextendPlusService.getById(userId);
        if (userextend.getDefmngdomainId() != null && userextend.getDefmngdomainId() > 0L) {
            for (MngDomainVO mngDomainVO : mngDomainVOList) {
                if (mngDomainVO.getOrgId().longValue() != userextend.getDefmngdomainId().longValue()) continue;
                ((MngDomainVO)mngDomainVOList.get(0)).setIsDefMngDomain(0);
                mngDomainVO.setIsDefMngDomain(1);
                break;
            }
        }
        return mngDomainVOList;
    }

    @Override
    @Cacheable
    public List<ResourceVO> findMngNavResourceList(Long userId, Long orgId, Integer equitment) {
        UserOrgRoleQuery query = new UserOrgRoleQuery();
        query.setUserId(userId);
        query.setOrgId(orgId);
        query.setColumns("uor.role_id");
        query.getPage().setSortColumns("uor.createdate");
        List userOrgRoleList = this.getUserOrgRolePlusDao().findAll(query);
        if (ListUtil.isNullorEmpty((List)userOrgRoleList)) {
            return new ArrayList<ResourceVO>();
        }
        List roleIds = IdUtil.getIds((List)userOrgRoleList, UserOrgRole::getRoleId);
        List<Long> userResourceIds = this.roleResourcePlusService.getResourceIdsByRoleIds(roleIds);
        List<Long> resourceIds = this.resourcePlusService.findMgnNavResourceIds();
        userResourceIds.retainAll(resourceIds);
        ListUtil.sort(userResourceIds, resourceIds);
        if (ListUtil.isNullorEmpty(userResourceIds)) {
            return new ArrayList<ResourceVO>();
        }
        List userResAndOperates = this.resourcePlusService.findByIds(userResourceIds);
        List userResources = userResAndOperates.stream().filter(e -> e.getType().intValue() != MenuTypeEnum.OPERATE.getValue()).collect(Collectors.toList());
        userResources = userResources.stream().filter(e -> e.getEquipment().intValue() == equitment.intValue() || e.getEquipment() == 3).collect(Collectors.toList());
        List resourceVOList = ConvertUtil.convert(userResources, ResourceVO.class);
        List<Resource> allResOperateList = this.resourcePlusService.getAllOperateList();
        if (ListUtil.notNullorEmpty(allResOperateList)) {
            List userOperates = userResAndOperates.stream().filter(e -> e != null && e.getType().intValue() == MenuTypeEnum.OPERATE.getValue()).collect(Collectors.toList());
            Map userOperateMap = ConvertUtil.listToMap(userOperates, Resource::getResourceId);
            for (ResourceVO userResourceVO : resourceVOList) {
                List curResourceOperates;
                if (userResourceVO.getIsleaf() != null && userResourceVO.getIsleaf() == 0 || ListUtil.isNullorEmpty(curResourceOperates = allResOperateList.stream().filter(e -> e.getParentId().equals(userResourceVO.getResourceId())).collect(Collectors.toList()))) continue;
                List permissionVOS = ConvertUtil.convert(curResourceOperates, PermissionVO.class);
                for (PermissionVO permissionVO : permissionVOS) {
                    if (userOperateMap.containsKey(permissionVO.getResourceId())) {
                        permissionVO.setIsHasPermission(1);
                        continue;
                    }
                    permissionVO.setIsHasPermission(0);
                }
                userResourceVO.setPermissionVOList(permissionVOS);
            }
        }
        return ListUtil.convertToTree((List)resourceVOList, (Long)0L, ResourceVO::getResourceId, ResourceVO::getParentId, ResourceVO::getChildren, ResourceVO::setChildren);
    }

    @Override
    @Cacheable
    public List<ResourceVO> findMngLeafNavResourceList(Long userId, Integer equitment) {
        List<UserOrgRole> userOrgRoleList = this.getUserOrgRolesByUserId(userId);
        if (ListUtil.isNullorEmpty(userOrgRoleList)) {
            return new ArrayList<ResourceVO>();
        }
        List roleIds = IdUtil.getIds(userOrgRoleList, UserOrgRole::getRoleId);
        List<Long> userResourceIds = this.roleResourcePlusService.getResourceIdsByRoleIds(roleIds);
        List<Long> resourceIds = this.resourcePlusService.findMgnNavResourceIds();
        userResourceIds.retainAll(resourceIds);
        ListUtil.sort(userResourceIds, resourceIds);
        List resources = this.resourcePlusService.findByIds(userResourceIds);
        resources = resources.stream().filter(e -> e.getEquipment().intValue() == equitment.intValue() || e.getEquipment() == 3).filter(e -> e.getIsleaf() == 1).collect(Collectors.toList());
        return ConvertUtil.convert(resources, ResourceVO.class);
    }

    @Override
    @Cacheable
    public List<ResourceVO> findDefMngNavResourceList(Long userId, Integer equitment) {
        MngDomainVO mngDomainVO = this.self.getDefMngDomain(userId);
        if (mngDomainVO == null) {
            return new ArrayList<ResourceVO>();
        }
        return this.self.findMngNavResourceList(userId, mngDomainVO.getOrgId(), equitment);
    }

    @Override
    public Integer switchCurMngDomain(Long userId, String token, Long orgId, Integer isdefault) {
        List<MngDomainVO> mngDomainVOList = this.self.getMngDomainList(userId);
        MngDomainVO mngDomainVO = null;
        for (MngDomainVO mngDomain : mngDomainVOList) {
            if (!orgId.equals(mngDomain.getOrgId())) continue;
            mngDomainVO = mngDomain;
            break;
        }
        if (mngDomainVO == null) {
            return 0;
        }
        if (mngDomainVO.getIsDefMngDomain() == 1 && isdefault == 0) {
            this.userextendPlusService.updateDefMngDomain(userId, null);
        }
        if (isdefault == 1) {
            this.userextendPlusService.updateDefMngDomain(userId, orgId);
        }
        this.rbacPlusService.setMngCurrDomainId(token, orgId);
        return 1;
    }

    @Override
    public List<MngDomainVO> getMngDomainList(Long userId, String token, Long curDomainId) {
        if (curDomainId == null) {
            MngDomainVO mngDomainVO = this.getDefMngDomain(userId);
            if (mngDomainVO == null) {
                return new ArrayList<MngDomainVO>();
            }
            curDomainId = mngDomainVO.getOrgId();
            this.rbacPlusService.setMngCurrDomainId(token, curDomainId);
        }
        List<MngDomainVO> mngDomainVOList = this.self.getMngDomainList(userId);
        for (MngDomainVO mngDomainVO : mngDomainVOList) {
            if (mngDomainVO.getOrgId().longValue() == curDomainId.longValue()) {
                mngDomainVO.setIsCurMngDomain(1);
                continue;
            }
            mngDomainVO.setIsCurMngDomain(0);
        }
        return mngDomainVOList;
    }

    @Override
    public List<UserOrgRoleMngVO> getDomainAdminList(Long domainId) {
        UserOrgRoleQuery query = new UserOrgRoleQuery();
        query.setOrgId(domainId);
        query.getPage().setSortColumns("uor.createdate desc");
        List userOrgRoleList = this.findAll(query);
        List userOrgRoleMngVOList = ConvertUtil.convert((List)userOrgRoleList, UserOrgRoleMngVO.class);
        UserCoreUtil.setUserVO(userOrgRoleMngVOList, UserOrgRoleMngVO::getUserId, UserOrgRoleMngVO::setUserVO);
        RoleUtil.setRoleVO(userOrgRoleMngVOList, UserOrgRoleMngVO::getRoleId, UserOrgRoleMngVO::setRoleVO);
        UserCoreUtil.setUserVO(userOrgRoleMngVOList, UserOrgRoleMngVO::getCreatorId, UserOrgRoleMngVO::setCreatorVO);
        return userOrgRoleMngVOList;
    }

    @Override
    public Integer insertDomainAdmin(UserOrgRoleBO userOrgRoleBO, Long creatorId) {
        int row = 0;
        for (Long userId : userOrgRoleBO.getUserIdList()) {
            UserOrgRole userOrgRole = this.getById(userId, userOrgRoleBO.getOrgId(), userOrgRoleBO.getRoleId());
            if (userOrgRole != null) continue;
            row += this.self.insertDomainAdmin(userId, userOrgRoleBO.getOrgId(), userOrgRoleBO.getRoleId(), creatorId).intValue();
        }
        return row;
    }

    private UserOrgRole getById(Long userId, Long orgId, Long roleId) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("userId", userId);
        params.put("orgId", orgId);
        params.put("roleId", roleId);
        return (UserOrgRole)this.userOrgRolePlusDao.getById(params);
    }

    @Override
    @Caching(evict={@CacheEvict(cacheNames={"prd"}, key="'UserOrgRolePlusService:findMngDomainCount:' + #userId"), @CacheEvict(cacheNames={"prd"}, key="'UserOrgRolePlusService:findMngNavResourceList:' + #userId + ','+ #orgId +',1'"), @CacheEvict(cacheNames={"prd"}, key="'UserOrgRolePlusService:findMngNavResourceList:' + #userId + ','+ #orgId +',2'"), @CacheEvict(cacheNames={"prd"}, key="'UserOrgRolePlusService:findMngLeafNavResourceList:' + #userId +',1'"), @CacheEvict(cacheNames={"prd"}, key="'UserOrgRolePlusService:findMngLeafNavResourceList:' + #userId +',2'"), @CacheEvict(cacheNames={"prd"}, key="'UserOrgRolePlusService:findDefMngNavResourceList:' + #userId +',1'"), @CacheEvict(cacheNames={"prd"}, key="'UserOrgRolePlusService:findDefMngNavResourceList:' + #userId +',2'"), @CacheEvict(cacheNames={"prd"}, key="'UserOrgRolePlusService:findSetRoleNavResourceList:' + #userId + ','+ #orgId"), @CacheEvict(cacheNames={"prd"}, key="'UserOrgRolePlusService:getUserOrgRoleList:' + #roleId"), @CacheEvict(cacheNames={"prd"}, key="'UserOrgRolePlusService:getUserOrgRoleList:' + #orgId + ','+ #roleId"), @CacheEvict(cacheNames={"prd"}, key="'UserOrgRolePlusService:getSelfAndUpList:' + #orgId + ','+ #roleId")})
    public Integer insertDomainAdmin(Long userId, Long orgId, Long roleId, Long creatorId) {
        UserOrgRole userOrgRole = new UserOrgRole();
        userOrgRole.setUserId(userId);
        userOrgRole.setOrgId(orgId);
        userOrgRole.setRoleId(roleId);
        userOrgRole.setCreatorId(creatorId);
        userOrgRole.setCreatedate(new Date());
        return this.getUserOrgRolePlusDao().insertSelective((BaseEntity)userOrgRole);
    }

    @Override
    @Cacheable
    public List<ResourceVO> findSetRoleNavResourceList(Long userId, Long orgId) {
        UserOrgRoleQuery query = new UserOrgRoleQuery();
        query.setUserId(userId);
        query.setOrgId(orgId);
        query.setColumns("uor.role_id");
        query.getPage().setSortColumns("uor.createdate");
        List userOrgRoleList = this.getUserOrgRolePlusDao().findAll(query);
        if (ListUtil.isNullorEmpty((List)userOrgRoleList)) {
            return new ArrayList<ResourceVO>();
        }
        List roleIds = IdUtil.getIds((List)userOrgRoleList, UserOrgRole::getRoleId);
        if (roleIds.contains(SysInitData.ROLE_SYSADMIN.getValue())) {
            List<Resource> resourceList = this.resourcePlusService.findMgnNavResource();
            List resourceVOList = ConvertUtil.convert(resourceList, ResourceVO.class);
            return ListUtil.convertToTree((List)resourceVOList, (Long)0L, ResourceVO::getResourceId, ResourceVO::getParentId, ResourceVO::getChildren, ResourceVO::setChildren);
        }
        List<Long> userResourceIds = this.roleResourcePlusService.getResourceIdsByRoleIds(roleIds);
        List<Long> resourceIds = this.resourcePlusService.findMgnNavResourceIds();
        userResourceIds.retainAll(resourceIds);
        ListUtil.sort(userResourceIds, resourceIds);
        List resources = this.resourcePlusService.findByIds(userResourceIds);
        List resourceVOList = ConvertUtil.convert((List)resources, ResourceVO.class);
        return ListUtil.convertToTree((List)resourceVOList, (Long)0L, ResourceVO::getResourceId, ResourceVO::getParentId, ResourceVO::getChildren, ResourceVO::setChildren);
    }

    @Override
    @Caching(evict={@CacheEvict(cacheNames={"prd"}, key="'UserOrgRolePlusService:findMngDomainCount:' + #userId"), @CacheEvict(cacheNames={"prd"}, key="'UserOrgRolePlusService:findMngNavResourceList:' + #userId + ','+ #orgId +',1'"), @CacheEvict(cacheNames={"prd"}, key="'UserOrgRolePlusService:findMngNavResourceList:' + #userId + ','+ #orgId +',2'"), @CacheEvict(cacheNames={"prd"}, key="'UserOrgRolePlusService:findMngLeafNavResourceList:' + #userId +',1'"), @CacheEvict(cacheNames={"prd"}, key="'UserOrgRolePlusService:findMngLeafNavResourceList:' + #userId +',2'"), @CacheEvict(cacheNames={"prd"}, key="'UserOrgRolePlusService:findDefMngNavResourceList:' + #userId +',1'"), @CacheEvict(cacheNames={"prd"}, key="'UserOrgRolePlusService:findDefMngNavResourceList:' + #userId +',2'"), @CacheEvict(cacheNames={"prd"}, key="'UserOrgRolePlusService:findSetRoleNavResourceList:' + #userId + ','+ #orgId"), @CacheEvict(cacheNames={"prd"}, key="'UserOrgRolePlusService:getUserOrgRoleList:' + #roleId"), @CacheEvict(cacheNames={"prd"}, key="'UserOrgRolePlusService:getUserOrgRoleList:' + #orgId + ','+ #roleId"), @CacheEvict(cacheNames={"prd"}, key="'UserOrgRolePlusService:getSelfAndUpList:' + #orgId + ','+ #roleId")})
    public Integer deleteDomainAdmin(Long userId, Long orgId, Long roleId, Long deletorId) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("userId", userId);
        params.put("orgId", orgId);
        params.put("roleId", roleId);
        int row = this.deleteById(params);
        Userextend userextend = (Userextend)this.userextendPlusService.getById(userId);
        if (userextend.getDefmngdomainId() != null && userextend.getDefmngdomainId().longValue() == orgId.longValue()) {
            this.userextendPlusService.updateDefMngDomain(userId, null);
        }
        return row;
    }

    @Override
    public List<Long> getHasRoleIdList(Long userId) {
        List<UserOrgRole> userOrgRoleList = this.getUserOrgRolesByUserId(userId);
        if (ListUtil.isNullorEmpty(userOrgRoleList)) {
            return new ArrayList<Long>();
        }
        List roleIdList = IdUtil.getIds(userOrgRoleList, UserOrgRole::getRoleId);
        roleIdList = ListUtil.removeDuplicate((List)roleIdList);
        return roleIdList;
    }

    private List<UserOrgRole> getUserOrgRolesByUserId(Long userId) {
        UserOrgRoleQuery query = new UserOrgRoleQuery();
        query.setUserId(userId);
        query.getPage().setSortColumns("uor.createdate");
        return this.getUserOrgRolePlusDao().findAll(query);
    }

    @Override
    @Cacheable
    public List<Long> getMngDomainIdList(Long userId, Long resourceId) {
        List<UserOrgRole> userOrgRoleList = this.getUserOrgRolesByUserId(userId);
        if (ListUtil.isNullorEmpty(userOrgRoleList)) {
            return new ArrayList<Long>();
        }
        List<Long> roleIdList = this.roleResourcePlusService.getRoleIdsByResourceId(resourceId);
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        for (UserOrgRole userOrgRole : userOrgRoleList) {
            if (!roleIdList.contains(userOrgRole.getRoleId())) continue;
            orgIdList.add(userOrgRole.getOrgId());
        }
        return orgIdList;
    }

    @Override
    public ResourceVO getResourcePermissionVO(Long userId, Long resourceId) {
        UserOrgRoleQuery query = new UserOrgRoleQuery();
        query.setUserId(userId);
        query.setColumns("uor.role_id");
        query.getPage().setSortColumns("uor.createdate");
        List userOrgRoleList = this.getUserOrgRolePlusDao().findAll(query);
        if (ListUtil.isNullorEmpty((List)userOrgRoleList)) {
            return null;
        }
        List roleIds = IdUtil.getIds((List)userOrgRoleList, UserOrgRole::getRoleId);
        List<Long> userResourceIds = this.roleResourcePlusService.getResourceIdsByRoleIds(roleIds = ListUtil.removeDuplicate((List)roleIds));
        if (!userResourceIds.contains(resourceId)) {
            return null;
        }
        Resource resource = (Resource)this.resourcePlusService.findById(resourceId);
        ResourceVO resourceVO = (ResourceVO)ConvertUtil.convert((Object)resource, ResourceVO.class);
        List<Resource> allResOperateList = this.resourcePlusService.getAllOperateList();
        if (ListUtil.isNullorEmpty(allResOperateList)) {
            return resourceVO;
        }
        List userResAndOperates = this.resourcePlusService.findByIds(userResourceIds);
        List curResourceOperates = allResOperateList.stream().filter(e -> e.getParentId().equals(resourceVO.getResourceId())).collect(Collectors.toList());
        if (ListUtil.isNullorEmpty(curResourceOperates)) {
            return resourceVO;
        }
        List userOperates = userResAndOperates.stream().filter(e -> e != null && e.getType().intValue() == MenuTypeEnum.OPERATE.getValue()).collect(Collectors.toList());
        Map userOperateMap = ConvertUtil.listToMap(userOperates, Resource::getResourceId);
        List permissionVOS = ConvertUtil.convert(curResourceOperates, PermissionVO.class);
        for (PermissionVO permissionVO : permissionVOS) {
            if (userOperateMap.containsKey(permissionVO.getResourceId())) {
                permissionVO.setIsHasPermission(1);
                continue;
            }
            permissionVO.setIsHasPermission(0);
        }
        resourceVO.setPermissionVOList(permissionVOS);
        return resourceVO;
    }

    @Override
    public Paging<UserOrgRoleMngVO> getVOList(UserOrgRoleQueryBO userOrgRoleQueryBO) {
        UserOrgRoleQuery query = (UserOrgRoleQuery)ConvertUtil.convert((Object)((Object)userOrgRoleQueryBO), UserOrgRoleQuery.class);
        Paging userOrgRoleMngVOPaging = this.userOrgRolePlusDao.findPaging(query, "getQueryList", UserOrgRoleMngVO.class);
        List userOrgRoleMngVOList = userOrgRoleMngVOPaging.getList();
        UserCoreUtil.setUserVO(userOrgRoleMngVOList, UserOrgRoleMngVO::getUserId, UserOrgRoleMngVO::setUserVO);
        RoleUtil.setRoleVO(userOrgRoleMngVOList, UserOrgRoleMngVO::getRoleId, UserOrgRoleMngVO::setRoleVO);
        OrgUtil.setOrgVO(userOrgRoleMngVOList, UserOrgRoleMngVO::getOrgId, UserOrgRoleMngVO::setOrgVO);
        UserCoreUtil.setUserVO(userOrgRoleMngVOList, UserOrgRoleMngVO::getCreatorId, UserOrgRoleMngVO::setCreatorVO);
        return userOrgRoleMngVOPaging;
    }

    @Override
    @Cacheable
    public List<UserOrgRole> getUserOrgRoleList(Long domainId, Long roleId) {
        UserOrgRoleQuery query = new UserOrgRoleQuery();
        query.setOrgId(domainId);
        query.setRoleId(roleId);
        query.getPage().setSortColumns("uor.CREATEDATE");
        return this.userOrgRolePlusDao.findAll(query);
    }

    @Override
    @Cacheable
    public List<UserOrgRole> getUserOrgRoleList(Long roleId) {
        UserOrgRoleQuery query = new UserOrgRoleQuery();
        query.setRoleId(roleId);
        query.getPage().setSortColumns("uor.CREATEDATE");
        return this.userOrgRolePlusDao.findAll(query);
    }

    @Override
    @Cacheable
    public List<UserOrgRole> getSelfAndUpList(Long roleId, Long orgId) {
        List<Long> orgIdList = this.orgPlusService.getOrgIdFullpathList(orgId);
        UserOrgRoleQuery query = new UserOrgRoleQuery();
        query.setRoleId(roleId);
        query.setOrgIdList(orgIdList);
        query.getPage().setSortColumns("uor.CREATEDATE");
        return this.userOrgRolePlusDao.findAll(query);
    }

    @Override
    public List<UserOrgRole> getUserOrgRoleListByUserIdDomainId(Long userId, Long orgId) {
        UserOrgRoleQuery query = new UserOrgRoleQuery();
        query.setUserId(userId);
        query.setOrgId(orgId);
        query.getPage().setSortColumns("uor.createdate");
        return this.getUserOrgRolePlusDao().findAll(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AsynExport
    public ExportInfoVO asynExportList(UserOrgRoleQueryBO userOrgRoleQueryBO) {
        ExcelWriteUtil excelWriteUtil = new ExcelWriteUtil(UserOrgRoleExcelModel.class);
        int pageNumber = 0;
        int pageSize = 500;
        try {
            while (pageNumber < 5000) {
                userOrgRoleQueryBO.setPageNumber(++pageNumber);
                userOrgRoleQueryBO.setPageSize(pageSize);
                UserOrgRoleQuery query = (UserOrgRoleQuery)ConvertUtil.convert((Object)((Object)userOrgRoleQueryBO), UserOrgRoleQuery.class);
                List userOrgRoleList = this.userOrgRolePlusDao.findList(query, "getQueryList");
                if (ListUtil.isNullorEmpty((List)userOrgRoleList)) {
                } else {
                    ArrayList<UserOrgRoleExcelModel> writeDataList = new ArrayList<UserOrgRoleExcelModel>();
                    for (UserOrgRole userOrgRole : userOrgRoleList) {
                        UserVO userVO = UserCoreUtil.getUserVO(userOrgRole.getUserId());
                        if (userVO == null) continue;
                        UserOrgRoleExcelModel userOrgRoleExcelModel = (UserOrgRoleExcelModel)((Object)ConvertUtil.convert((Object)userVO, UserOrgRoleExcelModel.class));
                        OrgVO orgVO = OrgUtil.getOrgVO(userOrgRole.getOrgId());
                        if (orgVO == null) continue;
                        userOrgRoleExcelModel.setMngDomainName(orgVO.getOrgname());
                        Role role = RoleUtil.getRole(userOrgRole.getRoleId());
                        if (role == null) continue;
                        userOrgRoleExcelModel.setRolename(role.getRolename());
                        writeDataList.add(userOrgRoleExcelModel);
                    }
                    excelWriteUtil.excelWrite("\u7528\u6237\u6743\u9650\u5217\u8868", writeDataList);
                    if (userOrgRoleList.size() >= pageSize) continue;
                }
                break;
            }
        }
        catch (Exception e) {
            ArrayList<UserOrgRoleExcelModel> writeDataList = new ArrayList<UserOrgRoleExcelModel>();
            UserOrgRoleExcelModel userOrgRoleExcelModel = new UserOrgRoleExcelModel();
            userOrgRoleExcelModel.setUsername("\u5bfc\u51fa\u4e2d\u65ad\uff1a\u5bfc\u51fa\u7684\u6570\u636e\u5b58\u5728\u95ee\u9898\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            writeDataList.add(userOrgRoleExcelModel);
            excelWriteUtil.excelWrite("\u7528\u6237\u5217\u8868", writeDataList);
            TracelogUtil.error("\u5bfc\u51fa\u7528\u6237\u6743\u9650\u5217\u8868\u4fe1\u606f\u9519\u8bef\uff01", ExceptionUtil.getStackTraceString((Exception)e));
            e.printStackTrace();
        }
        finally {
            excelWriteUtil.finishWrite();
        }
        ExportInfoVO exportInfoVO = new ExportInfoVO();
        exportInfoVO.setFilepath(excelWriteUtil.getExcelWritePath());
        return exportInfoVO;
    }
}

