/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.appsecurity.user.service.imple;

import com.peak.common.util.AppPathUtil;
import com.peak.common.util.ClientPwdUtil;
import com.peak.common.util.ConvertUtil;
import com.peak.common.util.DataMaskUtil;
import com.peak.common.util.HttpUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.ListUtil;
import com.peak.common.util.PWDUtil;
import com.peak.common.util.RedisObjectService;
import com.peak.common.util.StringUtil;
import com.peak.common.util.UploadFileUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.appsecurity.domain.model.Domain;
import com.peak.prd.appsecurity.domain.service.IDomainPlusService;
import com.peak.prd.appsecurity.org.model.Org;
import com.peak.prd.appsecurity.org.model.Orgexpand;
import com.peak.prd.appsecurity.org.model.Orgtree;
import com.peak.prd.appsecurity.org.service.IOrgPlusService;
import com.peak.prd.appsecurity.org.service.IOrgexpandPlusService;
import com.peak.prd.appsecurity.org.service.IOrgtreePlusService;
import com.peak.prd.appsecurity.org.util.OrgUtil;
import com.peak.prd.appsecurity.org.vo.OrgMngVO;
import com.peak.prd.appsecurity.position.service.IPositionPlusService;
import com.peak.prd.appsecurity.position.vo.PositionVO;
import com.peak.prd.appsecurity.rbac.service.IRbacInnerService;
import com.peak.prd.appsecurity.user.bo.UserBO;
import com.peak.prd.appsecurity.user.bo.UserDataImportExcelModel;
import com.peak.prd.appsecurity.user.bo.UserListQueryBO;
import com.peak.prd.appsecurity.user.bo.UserQueryBO;
import com.peak.prd.appsecurity.user.dao.IUserPlusDao;
import com.peak.prd.appsecurity.user.model.MSUserImportExcelModel;
import com.peak.prd.appsecurity.user.model.User;
import com.peak.prd.appsecurity.user.model.UserImportExcelModel;
import com.peak.prd.appsecurity.user.model.UserOrg;
import com.peak.prd.appsecurity.user.model.Userextend;
import com.peak.prd.appsecurity.user.service.IUserLeaderPlusService;
import com.peak.prd.appsecurity.user.service.IUserOrgPlusService;
import com.peak.prd.appsecurity.user.service.IUserPlusService;
import com.peak.prd.appsecurity.user.service.IUserPositionPlusService;
import com.peak.prd.appsecurity.user.service.IUserextendPlusService;
import com.peak.prd.appsecurity.user.util.UserCoreUtil;
import com.peak.prd.appsecurity.user.vo.UserDetailStuVO;
import com.peak.prd.appsecurity.user.vo.UserDetailVO;
import com.peak.prd.appsecurity.user.vo.UserExcelResultVO;
import com.peak.prd.appsecurity.user.vo.UserMiniVO;
import com.peak.prd.appsecurity.user.vo.UserMngVO;
import com.peak.prd.appsecurity.user.vo.UserQuery;
import com.peak.prd.appsecurity.user.vo.UserVO;
import com.peak.prd.base.annotation.ClearCache;
import com.peak.prd.base.model.IRespStatusEnum;
import com.peak.prd.base.model.Paging;
import com.peak.prd.base.model.ResponseStatusEnum;
import com.peak.prd.base.model.UploadFile;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.base.util.ExceptionUtil;
import com.peak.prd.common.appconfig.util.AppconfigUtil;
import com.peak.prd.common.appdict.util.AppdictUtil;
import com.peak.prd.common.util.AppCommonUtil;
import com.peak.prd.config.RedisConfig;
import com.peak.prd.enums.AppconfigEnum;
import com.peak.prd.enums.CreateWayEnum;
import com.peak.prd.enums.ProjectnameEnum;
import com.peak.prd.enums.SysInitData;
import com.peak.prd.exception.PrdBaseException;
import com.peak.prd.inc.IncUser;
import com.peak.prd.messageq.util.MessageQHelper;
import com.peak.tools.easyexcel.model.ExcelResultVO;
import com.peak.tools.easyexcel.util.ExcelReadUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.cache.support.NullValue;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@CacheConfig(cacheNames={"prd"})
public class UserPlusService
extends PrdBaseService<User, Long, UserQuery>
implements IUserPlusService {
    private static final Logger log = LoggerFactory.getLogger(UserPlusService.class);
    private IUserPlusDao userPlusDao;
    @Autowired
    IRbacInnerService rbacInnerService;
    @Resource
    @Lazy
    private IUserPlusService self;
    @Resource
    private RedisObjectService redisObjectService;
    @Resource
    private RedisConfig redisConfig;
    @Resource
    private IOrgtreePlusService orgtreePlusService;
    @Autowired
    private IUserextendPlusService userextendPlusService;
    @Autowired
    private IUserOrgPlusService userOrgPlusService;
    @Autowired
    private IOrgPlusService orgPlusService;
    @Autowired
    private IUserPositionPlusService userPositionPlusService;
    @Autowired
    private IPositionPlusService positionPlusService;
    @Autowired
    private IDomainPlusService domainPlusService;
    @Autowired
    private IOrgexpandPlusService orgexpandPlusService;
    @Autowired
    private IUserLeaderPlusService userLeaderPlusService;

    public void setUserPlusDao(IUserPlusDao dao) {
        this.userPlusDao = dao;
    }

    public IUserPlusDao getUserPlusDao() {
        return this.userPlusDao;
    }

    public IEntityDao<User, Long, UserQuery> getEntityDao() {
        return this.userPlusDao;
    }

    @Override
    public User getByUsername(String username) {
        if (username == null || username.isEmpty()) {
            return null;
        }
        return this.userPlusDao.getByUsername(username);
    }

    @Override
    public User getByUsercode(String usercode) {
        if (usercode == null || usercode.isEmpty()) {
            return null;
        }
        return this.userPlusDao.getByUsercode(usercode);
    }

    @Override
    public User getByUsernameOfEnterprise(String username, Long enterpriseId) {
        if (username == null || username.isEmpty()) {
            return null;
        }
        username = UserPlusService.getUsernameByLowerUpperType(username);
        UserQuery query = new UserQuery();
        query.setUsername(username);
        query.setDomainlevel1Id(enterpriseId);
        List users = this.userPlusDao.findAll(query);
        if (users == null || users.isEmpty()) {
            return null;
        }
        return (User)users.get(0);
    }

    @Override
    public UserDetailVO getInfo(@NotNull Long userId) {
        return this.getVOById(userId, UserDetailVO.class);
    }

    @Override
    @ClearCache(value="#userId")
    public int addPhoto(@NotNull Long userId, @NotNull String picpath) throws Exception {
        User user = new User();
        user.setUserId(userId);
        user.setPhoto(picpath);
        MessageQHelper.send("user", userId, "setface", null);
        return this.userPlusDao.updateSelective(user);
    }

    @Override
    @ClearCache(value="#userId")
    public int savePhone(@NotNull Long userId, @NotNull String cellphone) throws Exception {
        Userextend user = new Userextend();
        user.setUserId(userId);
        user.setCellphone(cellphone);
        return this.userextendPlusService.updateSelective(user);
    }

    @Override
    @ClearCache(value="#userId")
    public void changePassword(@NotNull Long userId, @NotNull String newmd5password, @NotNull String oldmd5password) {
        User user = (User)this.getById(userId);
        if (!oldmd5password.equals(user.getPwd())) {
            ExceptionUtil.handle((IRespStatusEnum)ResponseStatusEnum.USER_PWD_ERROR);
        }
        User userupdate = new User();
        userupdate.setUserId(userId);
        userupdate.setPwd(newmd5password);
        userupdate.setPwdmodifydate(new Date());
        this.userPlusDao.updateSelective(userupdate);
        log.info("\u7528\u6237[id:" + userId + "]\u5bc6\u7801\u91cd\u7f6e(resetpwd)");
    }

    @Override
    @ClearCache(value="#userId")
    public void lockUser(@NotNull Long userId, @NotNull Date lockEnddate) {
        User userupdate = new User(userId);
        userupdate.setLockenddate(lockEnddate);
        this.userPlusDao.updateSelective(userupdate);
    }

    @Override
    public Paging<UserVO> getSelectVOList(UserQueryBO userQueryBO) {
        Paging userSelectVOPaging;
        List userSelectVOS;
        UserQuery query = new UserQuery(userQueryBO.getPageNumber(), userQueryBO.getPageSize());
        ConvertUtil.copyProperties((Object)((Object)userQueryBO), (Object)query);
        if (query.getIncUser() == null) {
            IncUser incUser = new IncUser();
            query.setIncUser(incUser);
            if (userQueryBO.getOrgId() == null) {
                query.getIncUser().setOrgId(userQueryBO.getDomainId());
            } else {
                query.getIncUser().setOrgId(userQueryBO.getOrgId());
            }
            query.getIncUser().setKeywords(userQueryBO.getKeywords());
        }
        if (query.getIncUser().getOrgId() == null) {
            query.getIncUser().setOrgId(userQueryBO.getDomainId());
        }
        if (ListUtil.isNullorEmpty((List)(userSelectVOS = (userSelectVOPaging = this.getUserPlusDao().findPaging(query, "getSelectUserIdList", UserVO.class)).getList()))) {
            return userSelectVOPaging;
        }
        List userIds = IdUtil.getIds((List)userSelectVOS, UserVO::getUserId);
        userSelectVOS = this.findVOsByIds(userIds, UserVO.class);
        userSelectVOPaging.setList(userSelectVOS);
        return userSelectVOPaging;
    }

    @Override
    public Paging<UserMngVO> getMngVOList(Long domainId, UserListQueryBO userListQueryBO) {
        Paging userMngVOPaging;
        List userMngVOList;
        UserQuery query = new UserQuery(userListQueryBO.getPageNumber(), userListQueryBO.getPageSize());
        ConvertUtil.copyProperties((Object)((Object)userListQueryBO), (Object)query);
        if (userListQueryBO.getIncUser().getOrgId() == null) {
            query.getIncUser().setOrgId(domainId);
        }
        if (ListUtil.isNullorEmpty((List)(userMngVOList = (userMngVOPaging = this.getUserPlusDao().findPaging(query, "getUserIdList", UserMngVO.class)).getList()))) {
            return userMngVOPaging;
        }
        List userIds = IdUtil.getIds((List)userMngVOList, UserVO::getUserId);
        List userDetailVOList = this.findVOsByIds(userIds, UserDetailVO.class);
        List userMngVOs = ConvertUtil.convert((List)userDetailVOList, UserMngVO.class);
        userMngVOPaging.setList(userMngVOs);
        return userMngVOPaging;
    }

    @Override
    public void checkUsername(String username) {
        User user = this.getByUsername(username);
        if (user != null) {
            ExceptionUtil.handle((IRespStatusEnum)ResponseStatusEnum.USER_USERNAME_SAME);
        }
    }

    @Override
    public Integer updateCheckUsername(Long userId, String username) {
        User user = this.getByUsername(username = UserPlusService.getUsernameByLowerUpperType(username));
        if (user != null && user.getUserId().longValue() != userId.longValue()) {
            return 0;
        }
        return 1;
    }

    @Override
    public Integer insertCheckUsername(String username) {
        User user = this.getByUsername(username = UserPlusService.getUsernameByLowerUpperType(username));
        if (user != null) {
            return 0;
        }
        return 1;
    }

    @Override
    public Long txInsert(Long creatorId, UserBO userBO) throws Exception {
        String username = UserPlusService.getUsernameByLowerUpperType(userBO.getUsername());
        if (StringUtil.isNullorEmptyStr((String)userBO.getGkey())) {
            this.checkUsername(username);
        }
        if (StringUtil.isNullorEmptyStr((String)userBO.getUsercode())) {
            userBO.setUsercode(username);
        }
        User user = (User)ConvertUtil.convert((Object)userBO, User.class);
        user.setUsername(username);
        Long userId = IdUtil.getSequence((String)"TUSER");
        user.setUserId(userId);
        String photo = userBO.getPhoto();
        if (StringUtils.isNotBlank((String)photo)) {
            UploadFile photoFile = UploadFileUtil.upload((String)photo, (String)"userphoto/");
            user.setPhoto(photoFile.getFullpath());
        }
        if (StringUtil.isNullorEmptyStr((String)user.getGkey())) {
            user.setGkey(IdUtil.getGkey());
        }
        Integer createway = userBO.getCreateway();
        String pwd = userBO.getPwd();
        if (createway != null && createway == 1 && StringUtil.isNullorEmptyStr((String)(pwd = ClientPwdUtil.decryptClientPwd((String)userBO.getPwd())))) {
            ExceptionUtil.handle((IRespStatusEnum)ResponseStatusEnum.USER_CLIENT_PWD_ERROR);
        }
        user.setPwd(PWDUtil.encrypt((String)pwd));
        user.setDeleted(0);
        user.setCreatorId(creatorId);
        user.setCreatedate(new Date());
        if (user.getStatus() == null) {
            user.setStatus(0);
        }
        Long orgId = userBO.getOrgId();
        this.setDomainlevelIds(user, orgId);
        this.getUserPlusDao().insertSelective((BaseEntity)user);
        Userextend userextend = (Userextend)ConvertUtil.convert((Object)userBO, Userextend.class);
        userextend.setUserId(userId);
        this.userextendPlusService.insertSelective((BaseEntity)userextend);
        this.userOrgPlusService.insert(userId, orgId, 0L, creatorId);
        if (ListUtil.notNullorEmpty(userBO.getPositionIds())) {
            this.userPositionPlusService.insertBatch(userId, userBO.getPositionIds(), creatorId);
        }
        if (ListUtil.notNullorEmpty(userBO.getLeaderIds())) {
            this.userLeaderPlusService.insertBatch(userId, userBO.getLeaderIds(), creatorId);
        }
        return userId;
    }

    private static String getUsernameByLowerUpperType(String username) {
        if (AppconfigUtil.getUsennameLowerUpperType() == 1) {
            username = username.toLowerCase();
        } else if (AppconfigUtil.getUsennameLowerUpperType() == 2) {
            username = username.toUpperCase();
        }
        return username;
    }

    private void setDomainlevelIds(User user, Long deptId) {
        Long sysRootId = OrgUtil.getOrgRootId();
        Orgexpand orgexpand = this.orgexpandPlusService.getRealOrgexpand(sysRootId, deptId);
        if (orgexpand == null) {
            Org org = (Org)this.orgPlusService.findById(deptId);
            Long enterpriseId = org.getEnterpriseId();
            enterpriseId = enterpriseId == null ? sysRootId : enterpriseId;
            this.domainPlusService.refreshNoFilteruserDomain(enterpriseId);
            orgexpand = this.orgexpandPlusService.getRealOrgexpand(sysRootId, deptId);
        }
        List orgIdList = StringUtil.splitToLongList((String)orgexpand.getIdpath(), (String)",");
        Integer isCorpRoot9002 = AppconfigUtil.getIsCorpRoot9002();
        if (isCorpRoot9002 == 0) {
            orgIdList.remove(9002L);
        }
        for (int i = 0; i < orgIdList.size(); ++i) {
            Org org;
            if (i == 0) {
                user.setDomainlevel1Id((Long)orgIdList.get(i));
                continue;
            }
            if (i == 1) {
                org = (Org)this.orgPlusService.findById(orgIdList.get(i));
                if (!org.getIsdomain().equals(1)) break;
                user.setDomainlevel2Id((Long)orgIdList.get(i));
                continue;
            }
            if (i == 2) {
                org = (Org)this.orgPlusService.findById(orgIdList.get(i));
                if (!org.getIsdomain().equals(1)) break;
                user.setDomainlevel3Id((Long)orgIdList.get(i));
                continue;
            }
            if (i == 3) {
                org = (Org)this.orgPlusService.findById(orgIdList.get(i));
                if (!org.getIsdomain().equals(1)) break;
                user.setDomainlevel4Id((Long)orgIdList.get(i));
                continue;
            }
            if (i != 4) continue;
            org = (Org)this.orgPlusService.findById(orgIdList.get(i));
            if (!org.getIsdomain().equals(1)) break;
            user.setDomainlevel5Id((Long)orgIdList.get(i));
        }
    }

    @Override
    @ClearCache(value="#userBO.userId")
    public Integer txUpdate(Long updaterId, UserBO userBO) throws Exception {
        User olduser = (User)this.getById(userBO.getUserId());
        if (olduser == null) {
            return 0;
        }
        User user = (User)ConvertUtil.convert((Object)userBO, User.class);
        if (AppconfigUtil.getUserDataIsmask() == 1 && userBO.getCardnum() != null && userBO.getCardnum().contains("*")) {
            String oldcardnum = olduser.getCardnum();
            int length = 0;
            if (!StringUtil.isNullorEmptyStr((String)oldcardnum)) {
                length = olduser.getCardnum().length();
            }
            if (length == 0 || length == 15 || length == 18) {
                user.setCardnum(olduser.getCardnum());
            }
        }
        String username = UserPlusService.getUsernameByLowerUpperType(userBO.getUsername());
        if (!olduser.getUsername().equals(username)) {
            this.checkUsername(username);
            user.setUsername(username);
        } else {
            user.setUsername(null);
        }
        String photo = userBO.getPhoto();
        if (StringUtils.isNotBlank((String)photo)) {
            UploadFile photoFile = UploadFileUtil.upload((String)photo, (String)"userphoto/");
            user.setPhoto(photoFile.getFullpath());
        }
        user.setUpdatetime(new Date());
        Long orgId = userBO.getOrgId();
        UserOrg userorg = this.userOrgPlusService.getUserOrg(userBO.getUserId());
        if (!userorg.getOrgId().equals(orgId)) {
            this.setDomainlevelIds(user, orgId);
        }
        Userextend userextend = (Userextend)ConvertUtil.convert((Object)userBO, Userextend.class);
        if (AppconfigUtil.getUserDataIsmask() == 1 && userBO.getCellphone() != null && userBO.getCellphone().contains("*")) {
            Userextend oldUserextend = (Userextend)this.userextendPlusService.getById(userBO.getUserId());
            userextend.setCellphone(oldUserextend.getCellphone());
        }
        this.userextendPlusService.updateUserextend(userextend);
        if (!userorg.getOrgId().equals(orgId)) {
            this.userOrgPlusService.delete(userBO.getUserId(), userorg.getOrgId(), 0L);
            this.userOrgPlusService.insert(userBO.getUserId(), orgId, 0L, updaterId);
        }
        if (ListUtil.notNullorEmpty(userBO.getPositionIds())) {
            this.userPositionPlusService.update(userBO.getUserId(), userBO.getPositionIds(), updaterId);
        } else {
            this.userPositionPlusService.deleteByUserId(userBO.getUserId());
        }
        if (ListUtil.notNullorEmpty(userBO.getLeaderIds())) {
            this.userLeaderPlusService.update(userBO.getUserId(), userBO.getLeaderIds(), updaterId);
        } else {
            this.userLeaderPlusService.deleteByUserId(userBO.getUserId());
        }
        return this.getUserPlusDao().updateUser(user);
    }

    @Override
    @ClearCache(value="#userId")
    public Integer updateStatus(Long userId, Integer status) {
        User user = new User();
        user.setUserId(userId);
        user.setStatus(status);
        return this.getUserPlusDao().updateSelective(user);
    }

    @Override
    public Integer updateStatusBatch(List<Long> userIds, Integer status) {
        int row = 0;
        for (Long userId : userIds) {
            row += this.self.updateStatus(userId, status).intValue();
        }
        return row;
    }

    @Override
    public Integer delete(Long userId) {
        User user = new User();
        user.setUserId(userId);
        user.setDeleted(1);
        user.setDeletedate(new Date());
        return this.getUserPlusDao().updateSelective(user);
    }

    @Override
    public Integer deleteBatch(List<Long> userIds) {
        return this.getUserPlusDao().deleteBatch(userIds);
    }

    @Override
    @ClearCache(value="#userId")
    public void resetPassword(Long userId, String clientpwd) {
        String pwd = ClientPwdUtil.decryptClientPwd((String)clientpwd);
        if (StringUtil.isNullorEmptyStr((String)pwd)) {
            ExceptionUtil.handle((IRespStatusEnum)ResponseStatusEnum.USER_CLIENT_PWD_ERROR);
        }
        pwd = PWDUtil.encrypt((String)pwd);
        User user = new User(userId);
        user.setPwd(pwd);
        this.getUserPlusDao().updateSelective(user);
    }

    @Override
    public long count(Long enterpriseId) {
        UserQuery query = new UserQuery();
        query.setDomainlevel1Id(enterpriseId);
        query.setStatus(1);
        query.setDeleted(0);
        return this.getUserPlusDao().count(query);
    }

    @Override
    public String getDirectdomainFullpath(Long userId) {
        UserOrg userOrg = this.userOrgPlusService.getUserOrg(userId);
        if (userOrg == null) {
            return null;
        }
        Long directDomainId = UserCoreUtil.getDirectDomainId(userId);
        return this.findDeptFullpath(directDomainId, userOrg.getOrgId());
    }

    @Override
    public String findDeptFullpath(Long beginOrdId, Long endOrgId) {
        Orgexpand orgexpand = this.orgexpandPlusService.findRealOrgexpand(beginOrdId, endOrgId);
        if (orgexpand != null) {
            return orgexpand.getNamepath();
        }
        return null;
    }

    @Override
    public void setDomainlevelIds(Long userId) {
        UserOrg userOrg = this.userOrgPlusService.getUserOrg(userId);
        User user = new User(userId);
        this.setDomainlevelIds(user, userOrg.getOrgId());
        this.userPlusDao.updateSelective(user);
    }

    @Override
    public void setDomainlevelIdsByEnterpriseId(Long enterpriseId) {
        List<Long> userIdList;
        int pageNumber = 0;
        int pageSize = 500;
        while (pageNumber < 5000 && !ListUtil.isNullorEmpty(userIdList = this.getValidUserIdList(enterpriseId, ++pageNumber, pageSize))) {
            for (Long userId : userIdList) {
                try {
                    this.setDomainlevelIds(userId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (userIdList.size() >= pageSize) continue;
            break;
        }
    }

    @Override
    public List<Long> getNewWorkdateUserIdList(Date afterCreatedate, Date afterWorkdate, Integer pageNum, Integer pageSize) {
        if ((long)pageSize.intValue() > SysInitData.MAX_PAGESIZE.getValue()) {
            ExceptionUtil.handle((IRespStatusEnum)ResponseStatusEnum.MAX_PAGESIZE_ERROR);
        }
        UserQuery query = new UserQuery(pageNum, pageSize);
        query.setCreatedate(afterCreatedate);
        query.setWorkdate(afterWorkdate);
        List userList = this.userPlusDao.findList(query, "getNewWorkdateUserIdList");
        return IdUtil.getIds((List)userList, User::getUserId);
    }

    @Override
    @ClearCache(value="#userId")
    public void updateUsertype2(Long userId, Long usertype2) {
        User user = new User(userId);
        user.setUsertype2(usertype2);
        this.userPlusDao.updateSelective(user);
    }

    private List<Long> getValidUserIdList(Long enterpriseId, int pageNumber, int pageSize) {
        UserQuery query = new UserQuery(pageNumber, pageSize);
        query.setDomainlevel1Id(enterpriseId);
        query.setDeleted(0);
        query.setStatus(1);
        query.setColumns("tu.User_id");
        query.getPage().setSortColumns("tu.user_id");
        List userList = this.userPlusDao.findList(query);
        return IdUtil.getIds((List)userList, User::getUserId);
    }

    public <VO> VO getVOById(Long userId, Class<VO> clazz) {
        UserOrg userOrg;
        User user = (User)this.getById(userId);
        if (user == null) {
            log.warn("userPlusService.findById user null");
            return null;
        }
        if (AppconfigUtil.getUserDataIsmask() == 1) {
            user.setCardnum(this.getIdcardnum(user.getCardnum()));
        }
        Object vo = ConvertUtil.convert((Object)user, clazz);
        Userextend userextend = (Userextend)this.userextendPlusService.getById(userId);
        String photo = user.getPhoto();
        if (photo != null) {
            if (photo.indexOf("web/resource/") == -1) {
                photo = HttpUtil.formatURL((String)("web/resource/" + photo));
            } else {
                HttpUtil.formatURL((String)photo);
            }
            ((UserVO)vo).setPhoto(photo);
        }
        if (userextend != null) {
            ((UserVO)vo).setSex(userextend.getSex());
            if (AppconfigUtil.getUserDataIsmask() == 1) {
                ((UserVO)vo).setCellphone(DataMaskUtil.phonenumMask((String)userextend.getCellphone()));
            } else {
                ((UserVO)vo).setCellphone(userextend.getCellphone());
            }
            ((UserVO)vo).setWorkdate(userextend.getWorkdate());
        }
        if ((userOrg = this.userOrgPlusService.getUserOrg(userId)) != null) {
            ((UserVO)vo).setDeptId(userOrg.getOrgId());
            Org org = (Org)this.orgPlusService.findById(userOrg.getOrgId());
            String fulldeptpath = this.orgPlusService.getOrgFullpath(userOrg.getOrgId());
            ((UserVO)vo).setDeptName(fulldeptpath);
            ((UserVO)vo).setShortFullDeptName(org.getShortfullname());
            String fullOrgIds = this.orgPlusService.getOrgIdFullpath(userOrg.getOrgId());
            ((UserVO)vo).setFullOrgIds(fullOrgIds);
            if (!StringUtil.isNullorEmptyStr((String)fullOrgIds)) {
                ((UserVO)vo).setFullOrgIdList(StringUtil.splitToTrimList((String)fullOrgIds, (String)","));
                ((UserVO)vo).setFullOrgIdLongList(StringUtil.splitToLongList((String)fullOrgIds, (String)","));
            }
        }
        if (clazz.equals(UserDetailVO.class)) {
            List<Long> leaderIds;
            List<Long> positionIds = this.userPositionPlusService.getPositionIdsByUserId(userId);
            if (ListUtil.notNullorEmpty(positionIds)) {
                List positionVOList = this.positionPlusService.findVOsByIds(positionIds, PositionVO.class);
                ((UserDetailVO)vo).setPositionVOs(positionVOList);
            }
            if (user.getUserrank() != null) {
                ((UserDetailVO)vo).setUserrankVO(AppdictUtil.getAppdictMiniVO(user.getUserrank()));
            }
            ((UserDetailVO)vo).setIdentitys(userextend.getIdentitys());
            if (userextend.getIdentitys() != null) {
                ((UserDetailVO)vo).setIdentitysVO(AppdictUtil.getAppdictMiniVO(userextend.getIdentitys()));
            }
            if (ListUtil.notNullorEmpty(leaderIds = this.userLeaderPlusService.getLeaderIdsByUserId(userId))) {
                ((UserDetailVO)vo).setLeaderIds(leaderIds);
                List userList = this.findByIds(leaderIds);
                List userMiniVO = ConvertUtil.convert((List)userList, UserMiniVO.class);
                ((UserDetailVO)vo).setLeaderVO(userMiniVO);
            }
            if (user.getCardtype() != null) {
                ((UserDetailVO)vo).setCardtypeVO(AppdictUtil.getAppdictMiniVO(user.getCardtype()));
            }
            ((UserDetailVO)vo).setFolk(userextend.getFolk());
            if (userextend.getFolk() != null) {
                ((UserDetailVO)vo).setFolkVO(AppdictUtil.getAppdictMiniVO(userextend.getFolk()));
            }
            ((UserDetailVO)vo).setBirth(userextend.getBirth());
            List orgRoleList = this.rbacInnerService.getDomainRolesByUser(userId);
            ((UserDetailVO)vo).setMng(orgRoleList != null && orgRoleList.size() > 0);
            ((UserDetailVO)vo).setEducation(userextend.getEducation());
            if (userextend.getEducation() != null) {
                ((UserDetailVO)vo).setEducationVO(AppdictUtil.getAppdictMiniVO(userextend.getEducation()));
            }
            ((UserDetailVO)vo).setSchool(userextend.getSchool());
            ((UserDetailVO)vo).setSpecialty(userextend.getSpecialty());
            ((UserDetailVO)vo).setNote(userextend.getNote());
        }
        return (VO)vo;
    }

    private String getIdcardnum(String cardnum) {
        if (StringUtil.isNullorEmptyStr((String)cardnum)) {
            return cardnum;
        }
        int length = cardnum.length();
        if (length != 15 && length != 18) {
            return cardnum;
        }
        cardnum = DataMaskUtil.idCardMask((String)cardnum);
        return cardnum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserExcelResultVO importUserCommonList(@NotBlank String excelfilepath) {
        ExcelReadUtil excelReadUtil = new ExcelReadUtil();
        ArrayList<UserVO> userVOList = new ArrayList<UserVO>();
        try {
            List readDataList;
            int firstDataRowIndex = 2;
            int pageNumber = 1;
            while ((readDataList = excelReadUtil.getExcelReadData(excelfilepath, UserImportExcelModel.class, firstDataRowIndex, pageNumber)) != null) {
                if (readDataList.size() != 0) {
                    if (pageNumber > 5000) {
                    }
                    for (int rowIndex = 0; rowIndex < readDataList.size(); ++rowIndex) {
                        UserImportExcelModel excelUserModelDemo = (UserImportExcelModel)((Object)readDataList.get(rowIndex));
                        try {
                            if (excelUserModelDemo.getUsername() == null) {
                                excelUserModelDemo.setExcelImportErrorMessage("\u3010\u7528\u6237\u540d\u3011\u4e0d\u80fd\u4e3a\u7a7a!");
                                excelReadUtil.addReadErrorData((Object)excelUserModelDemo, pageNumber, rowIndex);
                                continue;
                            }
                            if (excelUserModelDemo.getName() == null) {
                                excelUserModelDemo.setExcelImportErrorMessage("\u3010\u59d3\u540d\u3011\u4e0d\u80fd\u4e3a\u7a7a!");
                                excelReadUtil.addReadErrorData((Object)excelUserModelDemo, pageNumber, rowIndex);
                                continue;
                            }
                            User user = this.getByUsername(excelUserModelDemo.getUsername());
                            if (user != null) {
                                if (excelUserModelDemo.getName() != null && excelUserModelDemo.getName().equals(user.getName())) {
                                    UserVO userVO = new UserVO();
                                    userVO.setUserId(user.getUserId());
                                    userVO.setName(user.getName());
                                    userVOList.add(userVO);
                                    continue;
                                }
                                excelUserModelDemo.setExcelImportErrorMessage("\u3010\u7528\u6237\u540d\u3011" + excelUserModelDemo.getUsername() + "\u3010\u59d3\u540d\u3011" + excelUserModelDemo.getName() + "\u7684\u59d3\u540d\u4fe1\u606f\u4e0d\u5339\u914d\uff01\uff01");
                                excelReadUtil.addReadErrorData((Object)excelUserModelDemo, pageNumber, rowIndex);
                                continue;
                            }
                            excelUserModelDemo.setExcelImportErrorMessage("\u3010\u7528\u6237\u540d\u3011" + excelUserModelDemo.getUsername() + "\u7684\u7528\u6237\u4e0d\u5b58\u5728\uff01\uff01");
                            excelReadUtil.addReadErrorData((Object)excelUserModelDemo, pageNumber, rowIndex);
                            continue;
                        }
                        catch (Exception e) {
                            excelUserModelDemo.setExcelImportErrorMessage("\u4e1a\u52a1\u5904\u7406\u5931\u8d25\u4e86\uff01\uff01");
                            excelReadUtil.addReadErrorData((Object)excelUserModelDemo, pageNumber, rowIndex);
                        }
                    }
                    ++pageNumber;
                    continue;
                }
                break;
            }
        }
        catch (PrdBaseException excelResultVO) {}
        finally {
            ExcelResultVO excelResultVO = excelReadUtil.getExcelResultVO(UserImportExcelModel.class);
            UserExcelResultVO userExcelResultVO = (UserExcelResultVO)ConvertUtil.convert((Object)excelResultVO, UserExcelResultVO.class);
            userExcelResultVO.setUserVOList(userVOList);
            return userExcelResultVO;
        }
    }

    @Override
    public UserExcelResultVO importMSUserCommonList(@NotBlank String excelfilepath) {
        ExcelReadUtil excelReadUtil = new ExcelReadUtil();
        ArrayList<UserVO> userVOList = new ArrayList<UserVO>();
        try {
            List readDataList;
            int firstDataRowIndex = 2;
            for (int pageNumber = 1; (readDataList = excelReadUtil.getExcelReadData(excelfilepath, MSUserImportExcelModel.class, firstDataRowIndex, pageNumber)) != null && readDataList.size() != 0 && pageNumber <= 5000; ++pageNumber) {
                for (int rowIndex = 0; rowIndex < readDataList.size(); ++rowIndex) {
                    MSUserImportExcelModel msexcelUserModelDemo = (MSUserImportExcelModel)((Object)readDataList.get(rowIndex));
                    try {
                        User user = this.getByUsername(msexcelUserModelDemo.getUsername());
                        if (user != null) {
                            UserVO userVO = new UserVO();
                            userVO.setUserId(user.getUserId());
                            userVO.setName(user.getName());
                            userVOList.add(userVO);
                            continue;
                        }
                        msexcelUserModelDemo.setExcelImportErrorMessage("\u3010\u5341\u4f4d\u5458\u5de5\u53f7\u3011" + msexcelUserModelDemo.getUsername() + "\u7684\u7528\u6237\u4e0d\u5b58\u5728\uff01\uff01");
                        excelReadUtil.addReadErrorData((Object)msexcelUserModelDemo, pageNumber, rowIndex);
                        continue;
                    }
                    catch (Exception e) {
                        msexcelUserModelDemo.setExcelImportErrorMessage("\u4e1a\u52a1\u5904\u7406\u5931\u8d25\u4e86\uff01\uff01");
                        excelReadUtil.addReadErrorData((Object)msexcelUserModelDemo, pageNumber, rowIndex);
                    }
                }
            }
        }
        catch (PrdBaseException firstDataRowIndex) {
            // empty catch block
        }
        ExcelResultVO excelResultVO = excelReadUtil.getExcelResultVO(MSUserImportExcelModel.class);
        UserExcelResultVO userExcelResultVO = (UserExcelResultVO)ConvertUtil.convert((Object)excelResultVO, UserExcelResultVO.class);
        userExcelResultVO.setUserVOList(userVOList);
        return userExcelResultVO;
    }

    @Override
    public void cacheAllUserVO() {
        List<Long> userIdList;
        String userprefix = this.getUserKeyPrefix();
        int usercahcetime = this.getUsercahcetime();
        int pageNumber = 0;
        int pageSize = 500;
        while (pageNumber < 5000 && !ListUtil.isNullorEmpty(userIdList = this.getValidUserIdList(++pageNumber, pageSize))) {
            for (Long userId : userIdList) {
                try {
                    String userkey = userprefix + userId;
                    UserVO userVO = this.getVOById(userId, UserVO.class);
                    this.redisObjectService.set(userkey, (Object)userVO, (long)usercahcetime);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (userIdList.size() >= pageSize) continue;
            break;
        }
    }

    private int getUsercahcetime() {
        String cachetime = AppconfigUtil.getValueByConfigkey(AppconfigEnum.ALLUSER_CACHE_TIME.getValue());
        if (cachetime == null) {
            cachetime = "1440";
        }
        int usercahcetime = Integer.parseInt(cachetime) * 60;
        return usercahcetime;
    }

    private String getUserKeyPrefix() {
        return "alluser:";
    }

    private List<Long> getValidUserIdList(int pageNumber, int pageSize) {
        UserQuery query = new UserQuery(pageNumber, pageSize);
        query.setDeleted(0);
        query.setStatus(1);
        query.setColumns("tu.User_id");
        query.getPage().setSortColumns("tu.user_id");
        List userList = this.userPlusDao.findList(query);
        return IdUtil.getIds((List)userList, User::getUserId);
    }

    @Override
    public List<UserVO> getUserVOListFromALLUserCache(List<Long> userIdList) {
        ArrayList<String> keys = new ArrayList<String>();
        String userprefix = this.getUserKeyPrefix();
        for (Long userId : userIdList) {
            String key = userprefix + userId;
            keys.add(key);
        }
        List userVOList = this.redisObjectService.multiGet(keys);
        for (int i = 0; i < userVOList.size(); ++i) {
            boolean isNull;
            boolean bl = isNull = userVOList.get(i) == null || userVOList.get(i) instanceof NullValue;
            if (!isNull) continue;
            if (userVOList.get(i) instanceof NullValue) {
                userVOList.set(i, null);
                continue;
            }
            UserVO userVO = this.getVOById(userIdList.get(i), UserVO.class);
            String userkey = userprefix + userIdList.get(i);
            this.redisObjectService.set(userkey, (Object)userVO, (long)this.getUsercahcetime());
            userVOList.set(i, userVO);
        }
        return userVOList;
    }

    @Override
    public User getByGkey(String gkey) {
        UserQuery query = new UserQuery();
        query.setGkey(gkey);
        return (User)this.userPlusDao.findOne(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExcelResultVO importUser(Long creatorId, MultipartFile userExcelFile) throws Exception {
        ExcelResultVO excelResultVO;
        UploadFile uploadFile = UploadFileUtil.upload((MultipartFile)userExcelFile, (String)"userimport/", (boolean)true);
        String excelfilepath = AppPathUtil.getTempLocalPath() + uploadFile.getFullpath();
        ExcelReadUtil excelReadUtil = new ExcelReadUtil();
        try {
            List readDataList;
            int firstDataRowIndex = 2;
            int pageNumber = 1;
            while ((readDataList = excelReadUtil.getExcelReadData(excelfilepath, UserDataImportExcelModel.class, firstDataRowIndex, pageNumber)) != null && !readDataList.isEmpty()) {
                if (pageNumber > 5000) {
                    break;
                }
                for (int rowIndex = 0; rowIndex < readDataList.size(); ++rowIndex) {
                    UserDataImportExcelModel userDataImportExcelModel = (UserDataImportExcelModel)((Object)readDataList.get(rowIndex));
                    try {
                        UserBO userBO = (UserBO)ConvertUtil.convert((Object)((Object)userDataImportExcelModel), UserBO.class);
                        userBO.setCreateway(CreateWayEnum.SYNC.getValue());
                        Org org = this.orgPlusService.findOrgByOrgcode(userDataImportExcelModel.getOrgcode());
                        if (org == null) {
                            userDataImportExcelModel.setExcelImportErrorMessage("\u76f4\u5c5e\u90e8\u95e8\u7f16\u53f7\u4e0d\u5b58\u5728\uff01");
                            excelReadUtil.addReadErrorData((Object)userDataImportExcelModel, pageNumber, rowIndex);
                            continue;
                        }
                        userBO.setOrgId(org.getOrgId());
                        userBO.setStatus(1);
                        String defaultPassword = AppconfigUtil.getValueByConfigkey("Key_UserDefaultPassword");
                        userBO.setPwd(defaultPassword);
                        if (StringUtil.isNullorEmptyStr((String)userDataImportExcelModel.getGkey())) {
                            userBO.setGkey(IdUtil.getGkey());
                        } else {
                            userBO.setGkey(userDataImportExcelModel.getGkey());
                        }
                        User user = this.getByUsername(userDataImportExcelModel.getUsername());
                        if (user == null) {
                            this.self.txInsert(creatorId, userBO);
                            continue;
                        }
                        userBO.setUserId(user.getUserId());
                        this.self.txUpdate(creatorId, userBO);
                        continue;
                    }
                    catch (Exception e) {
                        log.error(ExceptionUtil.getStackTraceString((Exception)e));
                        userDataImportExcelModel.setExcelImportErrorMessage("\u4e1a\u52a1\u5904\u7406\u5931\u8d25\u4e86\uff01\uff01");
                        excelReadUtil.addReadErrorData((Object)userDataImportExcelModel, pageNumber, rowIndex);
                    }
                }
                ++pageNumber;
            }
        }
        catch (PrdBaseException e) {
            log.error(ExceptionUtil.getStackTraceString((Exception)((Object)e)));
        }
        finally {
            excelResultVO = excelReadUtil.getExcelResultVO(UserDataImportExcelModel.class);
        }
        return excelResultVO;
    }

    @Override
    public UserDetailStuVO getStuInfo(Long userId) {
        UserDetailVO userDetailVO = this.getInfo(userId);
        return (UserDetailStuVO)ConvertUtil.convert((Object)userDetailVO, UserDetailStuVO.class);
    }

    @Caching(evict={@CacheEvict(cacheNames={"prd"}, key="'UserPlusService:' + #userId"), @CacheEvict(cacheNames={"prd"}, key="'UserextendPlusService:' + #userId"), @CacheEvict(cacheNames={"prd"}, key="'UserPlusService:UserVO:' + #userId"), @CacheEvict(cacheNames={"prd"}, key="'UserPlusService:UserDetailVO:' + #userId")})
    public void clearCache(Long userId) {
    }

    @Override
    public List<User> getListByUsercodeList(@NotNull List<String> usercodeList) {
        return this.userPlusDao.getListByUsercodeList(usercodeList);
    }

    @Override
    public List<User> getListByUsercode(String usercode) {
        return this.userPlusDao.getListByUsercode(usercode);
    }

    @Override
    public User getValidUserByUsercode(String usercode) {
        List<User> userList = this.getListByUsercode(usercode);
        if (ListUtil.isNullorEmpty(userList)) {
            return null;
        }
        for (User user : userList) {
            if (user.getStatus() == null || user.getStatus() != 1) continue;
            return user;
        }
        return null;
    }

    @Override
    @Cacheable
    public List<Long> getStuBranchDomainIds(Long branchRootId, Long userId) {
        ArrayList<Long> domainIdList = new ArrayList<Long>();
        domainIdList.addAll(this.getStuAllRealDomainIds(userId));
        domainIdList.addAll(this.getStuAllVirtualDomainIds(userId));
        ArrayList<Long> branchDomainIdList = new ArrayList<Long>();
        for (Long domainId : domainIdList) {
            Orgexpand orgexpand = this.orgexpandPlusService.findRealOrgexpand(branchRootId, domainId);
            if (orgexpand == null) continue;
            branchDomainIdList.add(domainId);
        }
        if (ListUtil.isNullorEmpty(branchDomainIdList)) {
            branchDomainIdList.add(0L);
        }
        return branchDomainIdList;
    }

    @Override
    @Cacheable
    public List<Long> getStuAllDomainIds(Long userId) {
        ArrayList<Long> domainIdList = new ArrayList<Long>();
        domainIdList.addAll(this.getStuAllRealDomainIds(userId));
        if (!AppCommonUtil.getProjectname().equals(ProjectnameEnum.BEIJINGBANK.getValue())) {
            domainIdList.addAll(this.getStuAllVirtualDomainIds(userId));
        }
        if (ListUtil.isNullorEmpty(domainIdList)) {
            domainIdList.add(0L);
        }
        domainIdList = ListUtil.removeDuplicate(domainIdList);
        return domainIdList;
    }

    @Override
    public String getAllDomainIdsAndFullOrgIdsStr(Long userId) {
        List<Long> domainIdAndOrgIds = this.self.getAllDomainIdsAndFullOrgIds(userId);
        return StringUtils.join(domainIdAndOrgIds, (String)",");
    }

    @Override
    @Cacheable
    public List<Long> getAllDomainIdsAndFullOrgIds(Long userId) {
        List<Long> domainIdList = this.getStuAllDomainIds(userId);
        UserVO userVO = UserCoreUtil.getUserVO(userId);
        List<Long> orgIdList = userVO.getFullOrgIdLongList();
        ArrayList<Long> domainIdAndOrgIds = new ArrayList<Long>();
        domainIdAndOrgIds.addAll(domainIdList);
        domainIdAndOrgIds.addAll(orgIdList);
        domainIdAndOrgIds = ListUtil.removeDuplicate(domainIdAndOrgIds);
        return domainIdAndOrgIds;
    }

    private List<Long> getStuAllRealDomainIds(Long userId) {
        UserVO userVO = UserCoreUtil.getUserVO(userId);
        List<Long> realIdPathList = this.orgexpandPlusService.getRealIdPathList(OrgUtil.getOrgRootId(), userVO.getDeptId());
        realIdPathList = ListUtil.removeDuplicate(realIdPathList);
        if (!(realIdPathList = this.getDomainIdList(realIdPathList)).contains(SysInitData.ORG_ROOT.getValue())) {
            realIdPathList.add(SysInitData.ORG_ROOT.getValue());
        }
        return realIdPathList;
    }

    private List<Long> getStuAllVirtualDomainIds(Long userId) {
        List<Orgtree> selectOrgtreeList;
        List<Long> domainIdList = new ArrayList();
        List<UserOrg> userOrgList = this.userOrgPlusService.getUserFilterVirtualDomains(userId);
        if (ListUtil.notNullorEmpty(userOrgList)) {
            domainIdList.addAll(IdUtil.getIds(userOrgList, UserOrg::getDomainId));
        }
        UserVO userVO = UserCoreUtil.getUserVO(userId);
        List<Long> userOrgIdList = this.orgexpandPlusService.getRealIdPathList(OrgUtil.getOrgRootId(), userVO.getDeptId());
        if (ListUtil.notNullorEmpty(userOrgIdList)) {
            List<Orgtree> mngRangeOrgtreeList = this.orgtreePlusService.getMngRangeContain(userOrgIdList);
            List<Long> mngDomainIdList = IdUtil.getIds(mngRangeOrgtreeList, Orgtree::getParentId);
            if (ListUtil.notNullorEmpty(mngDomainIdList = this.removeFilterVirtualDomain(mngDomainIdList))) {
                domainIdList.addAll(mngDomainIdList);
            }
        }
        if (ListUtil.notNullorEmpty(selectOrgtreeList = this.orgtreePlusService.getSelectContain(userOrgIdList))) {
            domainIdList.addAll(IdUtil.getIds(selectOrgtreeList, Orgtree::getParentId));
        }
        domainIdList = ListUtil.removeDuplicate(domainIdList);
        ArrayList upsDomainIdList = new ArrayList(domainIdList);
        for (Long domainId : upsDomainIdList) {
            List<Long> realIdPathList = this.orgexpandPlusService.getRealIdPathList(OrgUtil.getOrgRootId(), domainId);
            domainIdList.addAll(realIdPathList);
        }
        domainIdList = ListUtil.removeDuplicate(domainIdList);
        domainIdList = this.getDomainIdList(domainIdList);
        return domainIdList;
    }

    private List<Long> removeFilterVirtualDomain(List<Long> orgIdList) {
        if (ListUtil.isNullorEmpty(orgIdList)) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> noFilterVirtualDomains = new ArrayList<Long>();
        List domainList = this.domainPlusService.findByIds(orgIdList);
        for (Domain domain : domainList) {
            if (domain == null || domain.getFilteruseron() != 0) continue;
            noFilterVirtualDomains.add(domain.getDomainId());
        }
        return noFilterVirtualDomains;
    }

    private List<Long> getDomainIdList(List<Long> orgIdList) {
        if (ListUtil.isNullorEmpty(orgIdList)) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> domainList = new ArrayList<Long>();
        List orgList = this.orgPlusService.findByIds(orgIdList);
        for (Org org : orgList) {
            if (org == null || org.getIsdomain() != 1) continue;
            domainList.add(org.getOrgId());
        }
        return domainList;
    }

    @Override
    public Long getBranchSonDomain(Long branchDomainId, Long userId) {
        List<OrgMngVO> orgMngVOList;
        List branchSonDomainIds;
        List<Long> allDomainIds = this.self.getStuAllDomainIds(userId);
        List userBranchSonDomainIds = ListUtil.intersection(allDomainIds, (List)(branchSonDomainIds = IdUtil.getIds(orgMngVOList = this.orgPlusService.getSonDomain(branchDomainId), OrgMngVO::getOrgId)));
        if (ListUtil.isNullorEmpty((List)userBranchSonDomainIds)) {
            return 0L;
        }
        return (Long)userBranchSonDomainIds.get(0);
    }
}

