/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.appsecurity.user.service.imple;

import com.peak.common.util.IdUtil;
import com.peak.common.util.StringUtil;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.appsecurity.position.model.Position;
import com.peak.prd.appsecurity.position.service.IPositionPlusService;
import com.peak.prd.appsecurity.user.dao.IUserPositionPlusDao;
import com.peak.prd.appsecurity.user.model.UserPosition;
import com.peak.prd.appsecurity.user.service.IUserPositionPlusService;
import com.peak.prd.appsecurity.user.vo.UserPositionQuery;
import com.peak.prd.base.service.imple.PrdBaseService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserPositionPlusService
extends PrdBaseService<UserPosition, Map<String, Object>, UserPositionQuery>
implements IUserPositionPlusService {
    private IUserPositionPlusDao userPositionPlusDao;
    @Autowired
    private IPositionPlusService positionPlusService;

    public void setUserPositionPlusDao(IUserPositionPlusDao dao) {
        this.userPositionPlusDao = dao;
    }

    public IUserPositionPlusDao getUserPositionPlusDao() {
        return this.userPositionPlusDao;
    }

    public IEntityDao<UserPosition, Map<String, Object>, UserPositionQuery> getEntityDao() {
        return this.userPositionPlusDao;
    }

    @Override
    public List<Long> getUserIdsByPositionId(@NotNull Long positionId) {
        UserPositionQuery userPositionQuery = new UserPositionQuery();
        userPositionQuery.setPositionId(positionId);
        List userPositions = this.userPositionPlusDao.findAll(userPositionQuery);
        return IdUtil.getIds((List)userPositions, e -> e.getUserId());
    }

    @Override
    public List<Long> getPositionIdsByUserId(@NotNull Long userId) {
        UserPositionQuery userPositionQuery = new UserPositionQuery();
        userPositionQuery.setUserId(userId);
        userPositionQuery.setColumns("up.POSITION_ID");
        List userPositions = this.userPositionPlusDao.findAll(userPositionQuery);
        return IdUtil.getIds((List)userPositions, e -> e.getPositionId());
    }

    @Override
    public List<String> getLablesByUserId(@NotNull Long userId) {
        List<Long> positionIds = this.getPositionIdsByUserId(userId);
        List positions = this.positionPlusService.findByIds(positionIds);
        HashSet<String> set = new HashSet<String>();
        for (Position position : positions) {
            if (StringUtil.isNullorEmptyStr((String)position.getLabel())) continue;
            String[] labels = StringUtil.splitToStrings((String)position.getLabel(), (String)",");
            set.addAll(Arrays.asList(labels));
        }
        if (set.size() == 0) {
            return null;
        }
        return new ArrayList<String>(set);
    }

    @Override
    public List<UserPosition> getList(@NotNull Long positionId, int pageNumber, int pageSize) {
        UserPositionQuery userPositionQuery = new UserPositionQuery(pageNumber, pageSize);
        userPositionQuery.setPositionId(positionId);
        userPositionQuery.setColumns(" up.USER_ID ");
        return this.userPositionPlusDao.findList(userPositionQuery);
    }

    @Override
    public void insertBatch(Long userId, List<Long> positionIds, Long creatorId) {
        ArrayList<UserPosition> userPositions = new ArrayList<UserPosition>();
        Date curDate = new Date();
        for (Long positionId : positionIds) {
            UserPosition userPosition = new UserPosition();
            userPosition.setUserId(userId);
            userPosition.setPositionId(positionId);
            userPosition.setCreatorId(creatorId);
            userPosition.setCreatedate(curDate);
            userPositions.add(userPosition);
        }
        this.getUserPositionPlusDao().insertBatch(userPositions);
    }

    @Override
    public Integer update(Long userId, List<Long> positionIds, Long updaterId) {
        int row = this.getUserPositionPlusDao().deleteByUserId(userId);
        this.insertBatch(userId, positionIds, updaterId);
        return row;
    }

    @Override
    public Integer deleteByUserId(Long userId) {
        return this.getUserPositionPlusDao().deleteByUserId(userId);
    }
}

