/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.appsecurity.user.util;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.ListUtil;
import com.peak.common.util.SpringUtil;
import com.peak.prd.appsecurity.user.model.User;
import com.peak.prd.appsecurity.user.service.IUserPlusService;
import com.peak.prd.appsecurity.user.service.imple.UserPlusService;
import com.peak.prd.appsecurity.user.vo.UserStuVO;
import com.peak.prd.appsecurity.user.vo.UserVO;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class UserCoreUtil {
    public static <VO> void setUserRealname(List<VO> vos, Function<VO, Long> getUserIdFunc, BiConsumer<VO, String> setUserRealnameFunc) {
        List<User> users = UserCoreUtil.findUsers(vos, getUserIdFunc);
        if (users == null || users.isEmpty()) {
            return;
        }
        for (int i = 0; i < vos.size(); ++i) {
            VO vo = vos.get(i);
            User u = users.get(i);
            if (vo == null || u == null) continue;
            setUserRealnameFunc.accept(vo, u.getName());
        }
    }

    public static <VO> void setUserDeptId(List<VO> vos, Function<VO, Long> getUserIdFunc, BiConsumer<VO, Long> setUserDeptIdFunc) {
        List<UserVO> users = UserCoreUtil.findUserVOs(vos, getUserIdFunc);
        if (users == null || users.isEmpty()) {
            return;
        }
        for (int i = 0; i < vos.size(); ++i) {
            VO vo = vos.get(i);
            UserVO u = users.get(i);
            if (vo == null || u == null) continue;
            setUserDeptIdFunc.accept(vo, u.getDeptId());
        }
    }

    public static <VO> void setUserVO(List<VO> vos, Function<VO, Long> getUserIdFunc, BiConsumer<VO, UserVO> setUserVOFunc) {
        List<UserVO> users = UserCoreUtil.findUserVOs(vos, getUserIdFunc);
        if (users == null || users.isEmpty()) {
            return;
        }
        for (int i = 0; i < vos.size(); ++i) {
            VO vo = vos.get(i);
            UserVO u = users.get(i);
            if (vo == null || u == null) continue;
            setUserVOFunc.accept(vo, u);
        }
    }

    public static <VO> void setUserProperties(List<VO> vos, Function<VO, Long> getUserIdFunc, BiConsumer<VO, User> ... funcs) {
        List<User> users = UserCoreUtil.findUsers(vos, getUserIdFunc);
        if (users == null || users.isEmpty()) {
            return;
        }
        for (int i = 0; i < funcs.length; ++i) {
            ConvertUtil.setProperties(vos, users, funcs[i]);
        }
    }

    private static <T> List<User> findUsers(List<T> vos, Function<T, Long> getIdFunc) {
        if (vos == null) {
            return null;
        }
        IUserPlusService userPlusService = (IUserPlusService)SpringUtil.getBean(IUserPlusService.class);
        List userIds = ConvertUtil.removeNull((List)IdUtil.getIds(vos, vo -> (Long)getIdFunc.apply(vo)));
        userIds = ListUtil.removeDuplicate((List)userIds);
        List users = userPlusService.getByIds(userIds);
        List sortedUsers = ConvertUtil.refact(vos, (List)users, (vo, u) -> {
            Long voUid = (Long)getIdFunc.apply(vo);
            return voUid != null && voUid.equals(u.getUserId());
        });
        return sortedUsers;
    }

    private static <T> List<UserVO> findUserVOs(List<T> vos, Function<T, Long> getIdFunc) {
        if (vos == null) {
            return null;
        }
        IUserPlusService userPlusService = (IUserPlusService)SpringUtil.getBean(IUserPlusService.class);
        List userIds = ConvertUtil.removeNull((List)IdUtil.getIds(vos, vo -> (Long)getIdFunc.apply(vo)));
        List users = (userIds = ListUtil.removeDuplicate((List)userIds)).size() > 5 ? userPlusService.getUserVOListFromALLUserCache(userIds) : userPlusService.findVOsByIds(userIds, UserVO.class);
        List sortedUsers = ConvertUtil.refact(vos, (List)users, (vo, u) -> {
            Long voUid = (Long)getIdFunc.apply(vo);
            return voUid != null && voUid.equals(u.getUserId());
        });
        return sortedUsers;
    }

    public static UserVO getUserVO(Long userId) {
        UserPlusService userPlusService = (UserPlusService)SpringUtil.getBean(UserPlusService.class);
        return (UserVO)userPlusService.findVOById(userId, UserVO.class);
    }

    public static User getUser(Long userId) {
        if (userId == null) {
            return null;
        }
        UserPlusService userPlusService = (UserPlusService)SpringUtil.getBean(UserPlusService.class);
        return (User)userPlusService.findById(userId);
    }

    public static Long getDirectDomainId(Long userId) {
        if (userId == null) {
            return null;
        }
        UserVO vo = UserCoreUtil.getUserVO(userId);
        if (vo == null) {
            return null;
        }
        return vo.getDirectDomainId();
    }

    public static Long getDomainlevel1Id(Long userId) {
        if (userId == null) {
            return null;
        }
        UserVO vo = UserCoreUtil.getUserVO(userId);
        if (vo == null) {
            return null;
        }
        return vo.getDomainlevel1Id();
    }

    public static List<Long> getAllDomainIdList(Long userId) {
        return UserCoreUtil.getStuAllDomainIds(userId);
    }

    private static List<Long> getStuAllDomainIds(Long userId) {
        IUserPlusService userPlusService = (IUserPlusService)SpringUtil.getBean(UserPlusService.class);
        return userPlusService.getStuAllDomainIds(userId);
    }

    public static UserStuVO getUserStuVO(Long userId) {
        if (userId == null) {
            return null;
        }
        UserPlusService userPlusService = (UserPlusService)SpringUtil.getBean(UserPlusService.class);
        UserVO userVO = (UserVO)userPlusService.findVOById(userId, UserVO.class);
        return (UserStuVO)ConvertUtil.convert((Object)userVO, UserStuVO.class);
    }

    public static String getFullOrgIds(Long userId) {
        if (userId == null) {
            return "";
        }
        UserVO userVO = UserCoreUtil.getUserVO(userId);
        return userVO.getFullOrgIds();
    }

    public static List<User> getListByUsercodeList(List<String> usercodeList) {
        UserPlusService userPlusService = (UserPlusService)SpringUtil.getBean(UserPlusService.class);
        return userPlusService.getListByUsercodeList(usercodeList);
    }

    public static List<Long> getStuBranchDomainIds(Long branchRootId, Long userId) {
        IUserPlusService userPlusService = (IUserPlusService)SpringUtil.getBean(UserPlusService.class);
        return userPlusService.getStuBranchDomainIds(branchRootId, userId);
    }

    public static String getAllDomainIdsAndFullOrgIdsStr(Long userId) {
        if (userId == null) {
            return "";
        }
        IUserPlusService userPlusService = (IUserPlusService)SpringUtil.getBean(UserPlusService.class);
        return userPlusService.getAllDomainIdsAndFullOrgIdsStr(userId);
    }

    public static List<Long> getAllDomainIdsAndFullOrgIds(Long userId) {
        if (userId == null) {
            return new ArrayList<Long>();
        }
        IUserPlusService userPlusService = (IUserPlusService)SpringUtil.getBean(UserPlusService.class);
        return userPlusService.getAllDomainIdsAndFullOrgIds(userId);
    }
}

