/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.base.advise;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.SpringUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.prd.base.annotation.AsynExport;
import com.peak.prd.enums.AsynImpExpEnum;
import com.peak.prd.sys.impexpinfo.model.Impexpinfo;
import com.peak.prd.sys.impexpinfo.service.IImpexpinfoPlusService;
import com.peak.prd.sys.impexpinfo.vo.ExportInfoVO;
import com.peak.prd.thread.ExportThread;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AsynExportAdvise {
    private static ExecutorService exprotThreadExecutor = new ThreadPoolExecutor(1, 100, 3000L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>());

    @Around(value="@annotation(asynExport)")
    public Object exportAround(ProceedingJoinPoint proceedingJoinPoint, AsynExport asynExport) throws Exception {
        Object[] args = proceedingJoinPoint.getArgs();
        Impexpinfo impexpinfo = new Impexpinfo();
        Long sysieiId = IdUtil.getSequence((String)"SYS_IMPEXPINFO");
        impexpinfo.setStatus(AsynImpExpEnum.STATUS_PROGRESS.getValue());
        impexpinfo.setExetype(AsynImpExpEnum.EXETYPE_EXPORT.getValue());
        impexpinfo.setSysieiId(sysieiId);
        impexpinfo.setCreatedate(new Date());
        IImpexpinfoPlusService impexpinfoPlusService = (IImpexpinfoPlusService)SpringUtil.getBean(IImpexpinfoPlusService.class);
        impexpinfoPlusService.insertSelective((BaseEntity)impexpinfo);
        exprotThreadExecutor.execute(new ExportThread(proceedingJoinPoint, args, sysieiId, asynExport.value()));
        ExportInfoVO exportInfoVO = (ExportInfoVO)ConvertUtil.convert((Object)impexpinfo, ExportInfoVO.class);
        exportInfoVO.setIsAsyn(AsynImpExpEnum.ASYN_EXECUTE.getValue());
        return exportInfoVO;
    }
}

