/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.base.advise;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.SpringUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.prd.base.annotation.AsynImport;
import com.peak.prd.enums.AsynImpExpEnum;
import com.peak.prd.sys.impexpinfo.model.Impexpinfo;
import com.peak.prd.sys.impexpinfo.service.IImpexpinfoPlusService;
import com.peak.prd.sys.impexpinfo.vo.ImportInfoVO;
import com.peak.prd.thread.ImportThread;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AsynImportAdvise {
    private static ExecutorService importThreadExecutor = new ThreadPoolExecutor(1, 100, 3000L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>());

    @Around(value="@annotation(asynImport)")
    public Object importAround(ProceedingJoinPoint proceedingJoinPoint, AsynImport asynImport) throws Exception {
        Object[] args = proceedingJoinPoint.getArgs();
        Impexpinfo impexpinfo = new Impexpinfo();
        Long sysieiId = IdUtil.getSequence((String)"SYS_IMPEXPINFO");
        impexpinfo.setStatus(AsynImpExpEnum.STATUS_PROGRESS.getValue());
        impexpinfo.setExetype(AsynImpExpEnum.EXETYPE_IMPORT.getValue());
        impexpinfo.setSysieiId(sysieiId);
        impexpinfo.setCreatedate(new Date());
        IImpexpinfoPlusService impexpinfoPlusService = (IImpexpinfoPlusService)SpringUtil.getBean(IImpexpinfoPlusService.class);
        impexpinfoPlusService.insertSelective((BaseEntity)impexpinfo);
        importThreadExecutor.execute(new ImportThread(proceedingJoinPoint, args, sysieiId));
        ImportInfoVO importInfoVO = (ImportInfoVO)ConvertUtil.convert((Object)impexpinfo, ImportInfoVO.class);
        importInfoVO.setIsAsyn(AsynImpExpEnum.ASYN_EXECUTE.getValue());
        return importInfoVO;
    }
}

