/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.base.advise;

import com.peak.prd.base.annotation.ExportExcel;
import com.peak.prd.base.bo.PageBO;
import com.peak.prd.base.vo.ExportExcelVO;
import com.peak.tools.easyexcel.util.ExcelWriteUtil;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ExportExcelAdvise {
    private static final Logger log = LoggerFactory.getLogger(ExportExcelAdvise.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(exportExcel)")
    public Object exportAround(ProceedingJoinPoint proceedingJoinPoint, ExportExcel exportExcel) throws Exception {
        Object[] args = proceedingJoinPoint.getArgs();
        ExportExcelVO exportExcelVO = null;
        if (args == null) {
            log.error("\u5bfc\u51fa\u7684\u65b9\u6cd5\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            throw new Exception("\u5bfc\u51fa\u7684\u65b9\u6cd5\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ExcelWriteUtil excelWriteUtil = new ExcelWriteUtil(exportExcel.modelClass());
        try {
            int pageNumber = 1;
            while (true) {
                ((PageBO)args[0]).setPageNumber(pageNumber);
                ((PageBO)args[0]).setPageSize(1000);
                exportExcelVO = (ExportExcelVO)proceedingJoinPoint.proceed(args);
                if (exportExcelVO.getDateMap() == null) break;
                if (exportExcelVO.getDateMap().get(exportExcel.modelList()) == null) {
                    break;
                }
                Long totalCount = (Long)exportExcelVO.getDateMap().get(exportExcel.totalCount());
                List writeDataList = (List)exportExcelVO.getDateMap().get(exportExcel.modelList());
                if (exportExcel.excludeFieldNames() == null || exportExcel.excludeFieldNames().length == 0) {
                    excelWriteUtil.excelWrite(exportExcel.sheetName(), writeDataList);
                } else {
                    excelWriteUtil.excelWrite(exportExcel.sheetName(), writeDataList, exportExcel.excludeFieldNames());
                }
                if (writeDataList == null || writeDataList.size() == 0 || pageNumber > 5000) break;
                if ((long)(pageNumber * ((PageBO)args[0]).getPageSize()) > totalCount) {
                    break;
                }
                ++pageNumber;
            }
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            e.printStackTrace();
        }
        finally {
            if (excelWriteUtil != null) {
                excelWriteUtil.finishWrite();
            }
        }
        String excelWritePath = excelWriteUtil.getExcelWritePath();
        exportExcelVO.setExcelWritePath(excelWritePath);
        return exportExcelVO;
    }
}

