/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.base.excel.util;

import com.peak.prd.base.bo.PageBO;
import com.peak.prd.base.model.Paging;
import com.peak.prd.sys.impexpinfo.vo.ExportInfoVO;
import com.peak.tools.easyexcel.util.ExcelWriteUtil;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelExportUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcelExportUtil.class);
    private static final int MAX_PAGE_NO = 5000;
    private static final int PAGE_SIZE = 1000;

    public static <BO extends PageBO, VO> ExportInfoVO exportPaging(BO queryBO, Class<VO> clazz, Function<BO, Paging<VO>> pagingFunction, String sheetName) {
        return ExcelExportUtil.exeExportPaging(queryBO, clazz, pagingFunction, sheetName, null);
    }

    public static <BO extends PageBO, VO> ExportInfoVO exportPaging(BO queryBO, Class<VO> clazz, Function<BO, Paging<VO>> pagingFunction, String sheetName, Integer pageSize) {
        return ExcelExportUtil.exeExportPaging(queryBO, clazz, pagingFunction, sheetName, pageSize);
    }

    private static <BO extends PageBO, VO> ExportInfoVO exeExportPaging(BO queryBO, Class<VO> clazz, Function<BO, Paging<VO>> pagingFunction, String sheetName, Integer pageSize) {
        boolean hasErr;
        long startms;
        long totalCount;
        ExcelWriteUtil excelWriteUtil;
        block10: {
            excelWriteUtil = new ExcelWriteUtil(clazz);
            if (pageSize == null) {
                pageSize = 1000;
            }
            queryBO.setPageSize(pageSize.intValue());
            totalCount = -1L;
            startms = System.currentTimeMillis();
            hasErr = false;
            try {
                for (int pageNo = 1; pageNo <= 5000; ++pageNo) {
                    queryBO.setPageNumber(pageNo);
                    Paging<VO> paging = pagingFunction.apply(queryBO);
                    if (pageNo == 1) {
                        totalCount = paging.getTotalCount();
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("exportPaging {}, totalCount:{}, currPageNo:{}", new Object[]{sheetName, paging.getTotalCount(), pageNo});
                    }
                    if (paging.isListNullOrEmpty()) {
                        if (!log.isDebugEnabled()) break;
                        log.debug("empty pageNo:{}, pageSize:{}, break loop, {}", new Object[]{pageNo, queryBO.getPageSize(), sheetName});
                        break;
                    }
                    excelWriteUtil.excelWrite(sheetName, paging.getList());
                }
                if (excelWriteUtil == null) break block10;
            }
            catch (Exception ex) {
                try {
                    hasErr = true;
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (excelWriteUtil != null) {
                        excelWriteUtil.finishWrite();
                    }
                    ExportInfoVO exportInfoVO = new ExportInfoVO();
                    String excelWritePath = excelWriteUtil.getExcelWritePath();
                    exportInfoVO.setFilepath(excelWritePath);
                    log.info("export finish [{}] {}, totalCount:{}, totalSpentms:{}, filepath:{}", new Object[]{hasErr ? "OK" : "ERR", sheetName, totalCount, System.currentTimeMillis() - startms, exportInfoVO.getFilepath()});
                    return exportInfoVO;
                }
            }
            excelWriteUtil.finishWrite();
        }
        ExportInfoVO exportInfoVO = new ExportInfoVO();
        String excelWritePath = excelWriteUtil.getExcelWritePath();
        exportInfoVO.setFilepath(excelWritePath);
        log.info("export finish [{}] {}, totalCount:{}, totalSpentms:{}, filepath:{}", new Object[]{hasErr ? "OK" : "ERR", sheetName, totalCount, System.currentTimeMillis() - startms, exportInfoVO.getFilepath()});
        return exportInfoVO;
    }
}

