/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.base.excel.util;

import com.peak.common.util.ListUtil;
import com.peak.prd.base.excel.util.ExcelWriteBusinessDataUtil;
import com.peak.prd.sys.impexpinfo.vo.ExportInfoVO;
import com.peak.tools.easyexcel.model.BaseExcelModel;
import com.peak.tools.easyexcel.model.ExcelModelData;
import com.peak.tools.easyexcel.util.ExcelWriteUtil;
import java.util.ArrayList;
import java.util.List;

public class ExcelUtil {
    private static final int pageSize = 1000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <ExcelModel extends BaseExcelModel> ExportInfoVO exeExportList(ExcelWriteBusinessDataUtil<ExcelModel> businessDataUtil, String sheetName, Class<ExcelModel> excelModel) {
        ExcelWriteUtil excelWriteUtil = new ExcelWriteUtil(excelModel);
        try {
            for (int pageNumber = 1; pageNumber < 5000; ++pageNumber) {
                ExcelModelData<ExcelModel> excelModelData = businessDataUtil.getExcelModelData(pageNumber, 1000);
                Long totalCount = excelModelData.getTotalCount();
                List writeDataList = excelModelData.getModelDataList();
                List<String> hideColumnList = businessDataUtil.getHideColumnList();
                if (ListUtil.isNullorEmpty(hideColumnList)) {
                    excelWriteUtil.excelWrite(sheetName, writeDataList);
                } else {
                    hideColumnList.add(0, "excelImportErrorMessage");
                    excelWriteUtil.excelWrite(sheetName, writeDataList, (String[])hideColumnList.stream().toArray(String[]::new));
                }
                if (!ListUtil.isNullorEmpty((List)writeDataList)) {
                    if ((long)(pageNumber * 1000) <= totalCount) continue;
                }
                break;
            }
        }
        catch (Exception e) {
            ExcelModel errorExcelModel = businessDataUtil.getExcelErrorModelData(e);
            if (errorExcelModel != null) {
                ArrayList<ExcelModel> writeErrorDataList = new ArrayList<ExcelModel>();
                writeErrorDataList.add(errorExcelModel);
                excelWriteUtil.excelWrite(sheetName, writeErrorDataList);
            }
            e.printStackTrace();
        }
        finally {
            if (excelWriteUtil != null) {
                excelWriteUtil.finishWrite();
            }
        }
        ExportInfoVO exportInfoVO = new ExportInfoVO();
        String excelWritePath = excelWriteUtil.getExcelWritePath();
        exportInfoVO.setFilepath(excelWritePath);
        return exportInfoVO;
    }
}

