/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.base.homepopup.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.UploadFileUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.base.homepopup.bo.HomepopupBO;
import com.peak.prd.base.homepopup.dao.IHomepopupPlusDao;
import com.peak.prd.base.homepopup.model.Homepopup;
import com.peak.prd.base.homepopup.service.IHomepopupPlusService;
import com.peak.prd.base.homepopup.vo.HomepopupQuery;
import com.peak.prd.base.homepopup.vo.HomepopupVO;
import com.peak.prd.base.model.UploadFile;
import com.peak.prd.base.service.imple.PrdBaseService;
import java.util.Date;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@CacheConfig(cacheNames={"homepopup"})
public class HomepopupPlusService
extends PrdBaseService<Homepopup, Long, HomepopupQuery>
implements IHomepopupPlusService {
    private IHomepopupPlusDao homepopupPlusDao;
    @Autowired
    @Lazy
    IHomepopupPlusService self;

    public void setHomepopupPlusDao(IHomepopupPlusDao dao) {
        this.homepopupPlusDao = dao;
    }

    public IHomepopupPlusDao getHomepopupPlusDao() {
        return this.homepopupPlusDao;
    }

    public IEntityDao<Homepopup, Long, HomepopupQuery> getEntityDao() {
        return this.homepopupPlusDao;
    }

    @Override
    public Integer insert(@NotNull Long userId, @NotNull HomepopupBO homepopupBO) throws Exception {
        Integer updateNum = this.self.update(homepopupBO);
        if (updateNum > 0) {
            return updateNum;
        }
        Homepopup homepopup = this.getBoToHomepopup(homepopupBO);
        homepopup.setHomepopupId(IdUtil.getSequence((String)"BASE_HOMEPOPUP"));
        homepopup.setCreatorId(userId);
        homepopup.setCreatedate(new Date());
        return this.insertSelective((BaseEntity)homepopup);
    }

    @Override
    @CacheEvict(cacheNames={"homepopup"}, key="'HomepopupPlusService:' + #homepopupBO.domainId")
    public Integer update(@NotNull HomepopupBO homepopupBO) throws Exception {
        Homepopup homepopup = this.getByDomainId(homepopupBO.getDomainId());
        if (homepopup != null) {
            Homepopup updatehomepopup = this.getBoToHomepopup(homepopupBO);
            updatehomepopup.setHomepopupId(homepopup.getHomepopupId());
            return this.updateSelective(updatehomepopup);
        }
        return 0;
    }

    @Override
    public Homepopup getByDomainId(@NotNull Long domainId) {
        HomepopupQuery query = new HomepopupQuery(1, 1);
        query.setDomainId(domainId);
        return (Homepopup)this.homepopupPlusDao.findOne(query);
    }

    @Override
    @Cacheable
    public HomepopupVO findVOInfoByDomainId(@NotNull Long domainId) {
        return this.getVOInfoByDomainId(domainId);
    }

    @Override
    public HomepopupVO getVOInfoByDomainId(@NotNull Long domainId) {
        Homepopup homepopup = this.getByDomainId(domainId);
        return homepopup == null ? new HomepopupVO() : (HomepopupVO)ConvertUtil.convert((Object)homepopup, HomepopupVO.class);
    }

    private Homepopup getBoToHomepopup(HomepopupBO homepopupBO) throws Exception {
        String apppicpathBase64;
        Homepopup homepopup = (Homepopup)ConvertUtil.convert((Object)homepopupBO, Homepopup.class);
        String pcpicpathBase64 = homepopupBO.getPcpicpathBase64();
        if (pcpicpathBase64 != null && pcpicpathBase64.trim().length() > 0) {
            UploadFile pcpicpatFile = UploadFileUtil.upload((String)pcpicpathBase64, (String)"homepopup/pic/");
            homepopup.setPcpicpath(pcpicpatFile.getFullpath());
        }
        if ((apppicpathBase64 = homepopupBO.getApppicpathBase64()) != null && apppicpathBase64.trim().length() > 0) {
            UploadFile apppicpathFile = UploadFileUtil.upload((String)apppicpathBase64, (String)"homepopup/pic/");
            homepopup.setApppicpath(apppicpathFile.getFullpath());
        }
        return homepopup;
    }
}

