/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.base.service.imple;

import com.peak.prd.base.service.IBasePathService;
import com.peak.prd.common.util.WebUtil;
import com.peak.prd.config.LmsConfig;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BasePathService
implements IBasePathService {
    @Autowired
    LmsConfig lmsConfig;

    public String getPicBasePath(URI uri) {
        return this.lmsConfig.getOuterSchema() + this.lmsConfig.getOuterDomainname() + ":" + this.lmsConfig.getOuterPort() + this.lmsConfig.getOuterContextPath();
    }

    public String getPicBasePath(HttpServletRequest request) {
        return this.getBasePath(request);
    }

    public String getBasePath(HttpServletRequest request) {
        if (this.lmsConfig.getBasepathtype().trim().equalsIgnoreCase("request")) {
            return this.getRequestBasePath(request);
        }
        if (!this.lmsConfig.getInnerouterEnable().booleanValue()) {
            return this.getInnerBasePath(request);
        }
        if (this.isInnerVisit(request)) {
            return this.getInnerBasePath(request);
        }
        return this.getOuterBasePath(request);
    }

    public String getLessonBasePath(HttpServletRequest request) {
        if (this.lmsConfig.getBasepathtype().trim().equalsIgnoreCase("request")) {
            return this.getRequestBasePath(request);
        }
        if (!this.lmsConfig.getInnerouterEnable().booleanValue()) {
            return this.lmsConfig.getLessonInnerDomainname();
        }
        if (this.isInnerVisit(request)) {
            return this.lmsConfig.getLessonInnerDomainname();
        }
        return this.lmsConfig.getLessonOuterDomainname();
    }

    public String getVideoCoursewareBasePath(HttpServletRequest request) {
        if (this.lmsConfig.getBasepathtype().trim().equalsIgnoreCase("request")) {
            return this.getRequestBasePath(request);
        }
        if (!this.lmsConfig.getInnerouterEnable().booleanValue()) {
            return this.lmsConfig.getLessonVideoInnerDomainname();
        }
        if (this.isInnerVisit(request)) {
            return this.lmsConfig.getLessonVideoInnerDomainname();
        }
        return this.lmsConfig.getlessonVideoOuterDomainname();
    }

    public String getOssBasePath(HttpServletRequest request) {
        if (this.lmsConfig.getBasepathtype().trim().equalsIgnoreCase("request")) {
            return this.getRequestBasePath(request);
        }
        if (!this.lmsConfig.getInnerouterEnable().booleanValue()) {
            return this.lmsConfig.getOssInnerDomainname();
        }
        if (this.isInnerVisit(request)) {
            return this.lmsConfig.getOssInnerDomainname();
        }
        return this.lmsConfig.getOssOuterDomainname();
    }

    private String getInnerBasePath(HttpServletRequest request) {
        return this.lmsConfig.getInnerSchema() + this.lmsConfig.getInnerDomainname() + ":" + this.lmsConfig.getInnerPort() + this.lmsConfig.getInnerContextPath();
    }

    private String getOuterBasePath(HttpServletRequest request) {
        return this.lmsConfig.getOuterSchema() + this.lmsConfig.getOuterDomainname() + ":" + this.lmsConfig.getOuterPort() + this.lmsConfig.getOuterContextPath();
    }

    private boolean isInnerVisit(HttpServletRequest request) {
        return WebUtil.isInnerVisit(request);
    }

    private String getRequestBasePath(HttpServletRequest request) {
        if (request.getServerPort() == 80) {
            return request.getScheme() + "://" + request.getServerName() + request.getContextPath() + "/";
        }
        return request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath() + "/";
    }
}

