/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.common.appconfig.bean;

import com.alibaba.fastjson.JSONObject;
import javax.servlet.http.HttpServletRequest;

public class PasswordRule {
    boolean on;
    int minLength;
    boolean mustContainUpperCaseLetter;
    boolean mustContainLowerCaseLetter;
    boolean mustContainSpecailLetter;
    String specailLetters;

    public static PasswordRule parse(String str) {
        PasswordRule r = new PasswordRule();
        if (str != null && str.trim().length() > 0) {
            JSONObject jObj = JSONObject.parseObject((String)str);
            r.setOn(jObj.containsKey((Object)"on") ? jObj.getBoolean("on") : false);
            r.setMinLength(jObj.getInteger("minLength"));
            r.setMustContainUpperCaseLetter(jObj.getBoolean("mustContainUpperCaseLetter"));
            r.setMustContainLowerCaseLetter(jObj.getBoolean("mustContainLowerCaseLetter"));
            r.setMustContainSpecailLetter(jObj.getBoolean("mustContainSpecailLetter"));
            r.setSpecailLetters(jObj.getString("specailLetters"));
        }
        return r;
    }

    public static PasswordRule parse(HttpServletRequest request) {
        String mustContainSpecailLetter;
        String mustContainLowerCaseLetter;
        String minLength;
        PasswordRule r = new PasswordRule();
        String on = request.getParameter("on");
        if (on != null && on.trim().length() > 0) {
            r.setOn(Boolean.parseBoolean(on));
        }
        if ((minLength = request.getParameter("minLength")) != null && minLength.trim().length() > 0) {
            r.setMinLength(Integer.parseInt(minLength));
        } else {
            r.setMinLength(0);
        }
        String mustContainUpperCaseLetter = request.getParameter("mustContainUpperCaseLetter");
        if (mustContainUpperCaseLetter != null && mustContainUpperCaseLetter.trim().length() > 0) {
            r.setMustContainUpperCaseLetter(Boolean.parseBoolean(mustContainUpperCaseLetter));
        }
        if ((mustContainLowerCaseLetter = request.getParameter("mustContainLowerCaseLetter")) != null && mustContainLowerCaseLetter.trim().length() > 0) {
            r.setMustContainLowerCaseLetter(Boolean.parseBoolean(mustContainLowerCaseLetter));
        }
        if ((mustContainSpecailLetter = request.getParameter("mustContainSpecailLetter")) != null && mustContainSpecailLetter.trim().length() > 0) {
            r.setMustContainSpecailLetter(Boolean.parseBoolean(mustContainSpecailLetter));
        }
        r.setSpecailLetters(request.getParameter("specailLetters"));
        return r;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public boolean isMustContainUpperCaseLetter() {
        return this.mustContainUpperCaseLetter;
    }

    public void setMustContainUpperCaseLetter(boolean mustContainUpperCaseLetter) {
        this.mustContainUpperCaseLetter = mustContainUpperCaseLetter;
    }

    public boolean isMustContainLowerCaseLetter() {
        return this.mustContainLowerCaseLetter;
    }

    public void setMustContainLowerCaseLetter(boolean mustContainLowerCaseLetter) {
        this.mustContainLowerCaseLetter = mustContainLowerCaseLetter;
    }

    public boolean isMustContainSpecailLetter() {
        return this.mustContainSpecailLetter;
    }

    public void setMustContainSpecailLetter(boolean mustContainSpecailLetter) {
        this.mustContainSpecailLetter = mustContainSpecailLetter;
    }

    public String getSpecailLetters() {
        return this.specailLetters;
    }

    public void setSpecailLetters(String specailLetters) {
        this.specailLetters = specailLetters;
    }

    public boolean isOn() {
        return this.on;
    }

    public void setOn(boolean on) {
        this.on = on;
    }

    public boolean matchRule(String pwd) {
        if (pwd == null) {
            return false;
        }
        if (!this.on) {
            return true;
        }
        if (this.minLength > 0 && pwd.length() < this.minLength) {
            return false;
        }
        if (this.mustContainUpperCaseLetter && !pwd.matches(".*[A-Z].*")) {
            return false;
        }
        if (this.mustContainLowerCaseLetter && !pwd.matches(".*[a-z].*")) {
            return false;
        }
        return !this.mustContainSpecailLetter || this.specailLetters == null || this.specailLetters.trim().length() <= 0 || pwd.matches(".*[" + this.specailLetters + "].*");
    }

    public static void main(String[] args) {
        PasswordRule r = new PasswordRule();
        r.setMustContainUpperCaseLetter(true);
        r.setMustContainLowerCaseLetter(true);
        r.setMustContainSpecailLetter(true);
        r.setSpecailLetters("123$%^%^");
    }
}

