/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.common.appconfig.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.ListUtil;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.common.appconfig.bo.AppconfigBO;
import com.peak.prd.common.appconfig.dao.IAppconfigPlusDao;
import com.peak.prd.common.appconfig.model.Appconfig;
import com.peak.prd.common.appconfig.service.IAppconfigPlusService;
import com.peak.prd.common.appconfig.vo.AppconfigQuery;
import com.peak.prd.common.appconfig.vo.AppconfigVO;
import com.peak.prd.enums.AppconfigTypeEnum;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@CacheConfig(cacheNames={"prd"})
public class AppconfigPlusService
extends PrdBaseService<Appconfig, String, AppconfigQuery>
implements IAppconfigPlusService {
    private IAppconfigPlusDao appconfigPlusDao;
    @Autowired
    @Lazy
    private IAppconfigPlusService self;

    public void setAppconfigPlusDao(IAppconfigPlusDao dao) {
        this.appconfigPlusDao = dao;
    }

    public IAppconfigPlusDao getAppconfigPlusDao() {
        return this.appconfigPlusDao;
    }

    public IEntityDao<Appconfig, String, AppconfigQuery> getEntityDao() {
        return this.appconfigPlusDao;
    }

    @Override
    public List<AppconfigVO> getVOList(AppconfigTypeEnum configTypeEnum) {
        AppconfigQuery query = this.getQuery(configTypeEnum);
        List appconfigList = this.appconfigPlusDao.findAll(query);
        return ListUtil.notNullorEmpty((List)appconfigList) ? ConvertUtil.convert((List)appconfigList, AppconfigVO.class) : new ArrayList();
    }

    private AppconfigQuery getQuery(AppconfigTypeEnum configTypeEnum) {
        AppconfigQuery query = new AppconfigQuery();
        if (configTypeEnum != null) {
            switch (configTypeEnum) {
                case APPCONFIG_TYPE_REPEAL: {
                    query.setType(configTypeEnum.getValue());
                    break;
                }
                case APPCONFIG_TYPE_RESERVE: {
                    query.setType(configTypeEnum.getValue());
                    break;
                }
                case APPCONFIG_TYPE_ADMIN: {
                    query.setQueryMinType(configTypeEnum.getValue());
                    query.setQueryMaxType(configTypeEnum.getValue() + 99);
                    break;
                }
                case APPCONFIG_TYPE_SYSTEM: {
                    query.setQueryMinType(configTypeEnum.getValue());
                    query.setQueryMaxType(configTypeEnum.getValue() + 99);
                    break;
                }
                case APPCONFIG_TYPE_FOREENDVERSION: {
                    query.setQueryMinType(configTypeEnum.getValue());
                    query.setQueryMaxType(configTypeEnum.getValue() + 99);
                    break;
                }
                case APPCONFIG_TYPE_FREQUENTLYHAPPEN: {
                    query.setQueryMinType(configTypeEnum.getValue());
                    query.setQueryMaxType(configTypeEnum.getValue() + 99);
                }
            }
        }
        query.getPage().setSortColumns("acf.TYPE, acf.CREATEDATE DESC");
        return query;
    }

    @Override
    @CacheEvict(cacheNames={"prd"}, key="'AppconfigPlusService:' + #appconfigBO.configkey")
    public Integer update(@NotNull AppconfigBO appconfigBO) {
        Appconfig appconfig = (Appconfig)ConvertUtil.convert((Object)appconfigBO, Appconfig.class);
        return this.appconfigPlusDao.updateSelective(appconfig);
    }

    @Override
    public Integer updateBatch(@NotEmpty List<AppconfigBO> appconfigBOList) {
        int updatenum = 0;
        for (AppconfigBO appconfigBO : appconfigBOList) {
            updatenum += this.self.update(appconfigBO).intValue();
        }
        return updatenum;
    }
}

