/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.common.appdict.service.imple;

import com.peak.DomainUtil;
import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.ListUtil;
import com.peak.common.util.StringUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.appsecurity.user.util.UserCoreUtil;
import com.peak.prd.base.model.Paging;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.common.appdict.dao.IAppdictPlusDao;
import com.peak.prd.common.appdict.model.Appdict;
import com.peak.prd.common.appdict.service.IAppdictPlusService;
import com.peak.prd.common.appdict.vo.AppdictBO;
import com.peak.prd.common.appdict.vo.AppdictMngVO;
import com.peak.prd.common.appdict.vo.AppdictOrderNumBO;
import com.peak.prd.common.appdict.vo.AppdictQuery;
import com.peak.prd.common.appdict.vo.AppdictQueryBO;
import com.peak.prd.common.appdict.vo.AppdictTreeDateInsertBO;
import com.peak.prd.common.appdict.vo.AppdictUpdateOrderNumBO;
import com.peak.prd.common.appdict.vo.AppdictVO;
import com.peak.prd.enums.SysInitData;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@CacheConfig(cacheNames={"prd"})
public class AppdictPlusService
extends PrdBaseService<Appdict, Long, AppdictQuery>
implements IAppdictPlusService {
    private IAppdictPlusDao appdictPlusDao;
    @Autowired
    @Lazy
    private IAppdictPlusService self;

    public void setAppdictPlusDao(IAppdictPlusDao dao) {
        this.appdictPlusDao = dao;
    }

    public IAppdictPlusDao getAppdictPlusDao() {
        return this.appdictPlusDao;
    }

    public IEntityDao<Appdict, Long, AppdictQuery> getEntityDao() {
        return this.appdictPlusDao;
    }

    @Override
    @Cacheable(cacheNames={"findIdList"}, key="'appdict:list:' + #categoryId + '-'+ #domainId + '-'+ #isRoot +'-' + #pageSize", condition="#pageNum == 1")
    public List<Long> findIdList(Long categoryId, Long domainId, int isRoot, int pageNum, int pageSize) {
        AppdictQuery query = new AppdictQuery(pageNum, pageSize);
        if (categoryId != null) {
            query.setCategoryId(categoryId);
        }
        query.setIsRoot(isRoot);
        query.setIsvalId(1);
        query.setDomainIdIncUp(true);
        query.setRootDomainIdInc(true);
        query.getPage().setSortColumns("ADT.ORDERNUM, ADT.CREATEDATE");
        query.setDomainId(domainId);
        query.setColumns("ADT.APPDICT_ID");
        List appdictList = this.appdictPlusDao.findList(query);
        List ids = IdUtil.getIds((List)appdictList, e -> e.getAppdictId());
        return ids;
    }

    @Override
    public List<Long> findIdList(Long categoryId, List<Long> domainIds, int isRoot, int pageNum, int pageSize) {
        AppdictQuery query = new AppdictQuery(pageNum, pageSize);
        if (categoryId != null) {
            query.setCategoryId(categoryId);
        }
        query.setIsRoot(isRoot);
        query.setIsvalId(1);
        query.getPage().setSortColumns("ADT.ORDERNUM, ADT.CREATEDATE");
        query.setDomainIds(domainIds);
        query.setColumns("ADT.APPDICT_ID");
        List appdictList = this.appdictPlusDao.findList(query);
        List ids = IdUtil.getIds((List)appdictList, e -> e.getAppdictId());
        return ids;
    }

    @Override
    public List<AppdictVO> getVOList(@NotNull Long categoryId, @NotNull Long domainId, int pageNumber, int pageSize) {
        return this.findVOsByIds(this.self.findIdList(categoryId, domainId, 0, pageNumber, pageSize), AppdictVO.class);
    }

    @Override
    public List<AppdictVO> getVOList(Long categoryId, List<Long> domainIds, int pageNumber, int pageSize) {
        return this.findVOsByIds(this.self.findIdList(categoryId, domainIds, 0, pageNumber, pageSize), AppdictVO.class);
    }

    @Override
    public List<AppdictVO> getVOTreeList(@NotNull Long categoryId, @NotNull Long parentId, @NotNull Long domainId) {
        AppdictQuery query = new AppdictQuery();
        query.setCategoryId(categoryId);
        if (parentId != -1L) {
            query.setParentId(parentId);
        } else {
            parentId = 0L;
        }
        query.setDomainId(domainId);
        query.setDomainIdIncUp(true);
        query.setRootDomainIdInc(true);
        query.setIsvalId(1);
        query.getPage().setSortColumns("ADT.ORDERNUM, ADT.CREATEDATE");
        List appdictList = this.appdictPlusDao.findAll(query);
        List appdictVOList = ListUtil.convertToTree((List)ConvertUtil.convert((List)appdictList, AppdictVO.class), (Long)parentId, AppdictVO::getAppdictId, AppdictVO::getParentId, AppdictVO::getChildren, AppdictVO::setChildren);
        return appdictVOList;
    }

    @Override
    public List<AppdictVO> getVOTreeList(Long categoryId, Long parentId, List<Long> domainIds) {
        AppdictQuery query = new AppdictQuery();
        query.setCategoryId(categoryId);
        if (parentId != -1L) {
            query.setParentId(parentId);
        } else {
            parentId = 0L;
        }
        query.setDomainIds(domainIds);
        query.setIsvalId(1);
        query.getPage().setSortColumns("ADT.ORDERNUM, ADT.CREATEDATE");
        List appdictList = this.appdictPlusDao.findAll(query);
        List appdictVOList = ListUtil.convertToTree((List)ConvertUtil.convert((List)appdictList, AppdictVO.class), (Long)parentId, AppdictVO::getAppdictId, AppdictVO::getParentId, AppdictVO::getChildren, AppdictVO::setChildren);
        return appdictVOList;
    }

    public <VO> VO getVOById(Long appdictId, Class<VO> clazz) {
        if (appdictId == null) {
            return null;
        }
        Appdict appdict = (Appdict)this.self.getById(appdictId);
        Object vo = ConvertUtil.convert((Object)appdict, clazz);
        return (VO)vo;
    }

    private List<Appdict> getChildren(Long parentId, Long domainId) {
        AppdictQuery query = new AppdictQuery();
        query.setParentId(parentId);
        query.setIsvalId(1);
        query.setDomainId(domainId);
        query.getPage().setSortColumns("ORDERNUM");
        query.getPage().setPageSize(1000);
        return this.appdictPlusDao.findList(query);
    }

    @Override
    public int deleteByCategoryId(@NotNull Long categoryId) {
        return this.appdictPlusDao.deleteByCategoryId(categoryId);
    }

    @Override
    public Paging<AppdictMngVO> getMngVOList(@NotNull AppdictQueryBO appdictQueryBO) {
        AppdictQuery query = new AppdictQuery(appdictQueryBO.getPageNumber(), appdictQueryBO.getPageSize());
        ConvertUtil.copyProperties((Object)((Object)appdictQueryBO), (Object)query);
        query.getPage().setSortColumns("ADT.ORDERNUM, ADT.CREATEDATE");
        Paging adVOPaging = this.appdictPlusDao.findPaging(query, AppdictMngVO.class);
        List appdictMngVOList = adVOPaging.getList();
        if (appdictMngVOList == null || appdictMngVOList.isEmpty()) {
            return adVOPaging;
        }
        UserCoreUtil.setUserVO(appdictMngVOList, AppdictMngVO::getCreatorId, AppdictMngVO::setUserVO);
        return adVOPaging;
    }

    @Override
    public Paging<AppdictMngVO> getSelectMngVOList(AppdictQueryBO appdictQueryBO) {
        AppdictQuery query = new AppdictQuery(appdictQueryBO.getPageNumber(), appdictQueryBO.getPageSize());
        ConvertUtil.copyProperties((Object)((Object)appdictQueryBO), (Object)query);
        query.setDomainIdIncUp(true);
        query.setRootDomainIdInc(true);
        query.getPage().setSortColumns("ADT.ORDERNUM, ADT.CREATEDATE");
        Paging adVOPaging = this.appdictPlusDao.findPaging(query, AppdictMngVO.class);
        List appdictMngVOList = adVOPaging.getList();
        if (appdictMngVOList == null || appdictMngVOList.isEmpty()) {
            return adVOPaging;
        }
        UserCoreUtil.setUserVO(appdictMngVOList, AppdictMngVO::getCreatorId, AppdictMngVO::setUserVO);
        return adVOPaging;
    }

    @Override
    public List<AppdictMngVO> getMngTreeVOList(@NotNull AppdictQueryBO appdictQueryBO) {
        AppdictQuery query = new AppdictQuery();
        ConvertUtil.copyProperties((Object)((Object)appdictQueryBO), (Object)query);
        query.getPage().setSortColumns("ADT.ORDERNUM, ADT.CREATEDATE");
        List appdictList = this.appdictPlusDao.findAll(query);
        List appdictVOTempList = ConvertUtil.convert((List)appdictList, AppdictMngVO.class);
        if (appdictVOTempList == null || appdictVOTempList.isEmpty()) {
            return appdictVOTempList;
        }
        UserCoreUtil.setUserVO(appdictVOTempList, AppdictMngVO::getCreatorId, AppdictMngVO::setUserVO);
        List appdictVOList = ListUtil.convertToTree((List)appdictVOTempList, (Long)0L, AppdictMngVO::getAppdictId, AppdictMngVO::getParentId, AppdictMngVO::getChildren, AppdictMngVO::setChildren);
        return appdictVOList;
    }

    @Override
    public List<AppdictMngVO> getSelectMngTreeVOList(AppdictQueryBO appdictQueryBO) {
        AppdictQuery query = new AppdictQuery();
        if (Boolean.valueOf(appdictQueryBO.getDomainIdIncUp()) == null) {
            appdictQueryBO.setDomainIdIncUp(true);
        }
        if (Boolean.valueOf(appdictQueryBO.getRootDomainIdInc()) == null) {
            appdictQueryBO.setDomainIdIncUp(true);
        }
        ConvertUtil.copyProperties((Object)((Object)appdictQueryBO), (Object)query);
        query.getPage().setSortColumns("ADT.ORDERNUM, ADT.CREATEDATE");
        List appdictList = this.appdictPlusDao.findAll(query);
        List appdictVOTempList = ConvertUtil.convert((List)appdictList, AppdictMngVO.class);
        if (appdictVOTempList == null || appdictVOTempList.isEmpty()) {
            return appdictVOTempList;
        }
        UserCoreUtil.setUserVO(appdictVOTempList, AppdictMngVO::getCreatorId, AppdictMngVO::setUserVO);
        List appdictVOList = ListUtil.convertToTree((List)appdictVOTempList, (Long)0L, AppdictMngVO::getAppdictId, AppdictMngVO::getParentId, AppdictMngVO::getChildren, AppdictMngVO::setChildren);
        return appdictVOList;
    }

    @Override
    public List<AppdictMngVO> getUnderTreeDictDataList(AppdictQueryBO appdictQueryBO) {
        AppdictQuery query = new AppdictQuery();
        ConvertUtil.copyProperties((Object)((Object)appdictQueryBO), (Object)query);
        query.setDomainIdIncUp(false);
        query.setRootDomainIdInc(false);
        query.getPage().setSortColumns("ADT.ORDERNUM, ADT.CREATEDATE");
        List appdictList = this.appdictPlusDao.findAll(query);
        List appdictVOTempList = ConvertUtil.convert((List)appdictList, AppdictMngVO.class);
        if (appdictVOTempList == null || appdictVOTempList.isEmpty()) {
            return appdictVOTempList;
        }
        UserCoreUtil.setUserVO(appdictVOTempList, AppdictMngVO::getCreatorId, AppdictMngVO::setUserVO);
        return appdictVOTempList;
    }

    @Override
    public Long insertLineDictData(@NotNull Long userId, @NotNull Long domainId, @NotNull AppdictBO appdictBO) throws Exception {
        Appdict appdict = (Appdict)ConvertUtil.convert((Object)appdictBO, Appdict.class);
        Long appdictId = IdUtil.getSequence((String)"COMMON_APPDICT");
        if (StringUtil.isNullorEmptyStr((String)appdict.getCode())) {
            appdict.setCode(appdict.getName());
        }
        appdict.setAppdictId(appdictId);
        appdict.setCreatedate(new Date());
        appdict.setCreatorId(userId);
        appdict.setFullpath("," + appdict.getAppdictId() + ",");
        appdict.setParentId(0L);
        if (domainId != null) {
            appdict.setDomainId(domainId);
        }
        this.insert((BaseEntity)appdict);
        return appdictId;
    }

    @Override
    @CacheEvict(cacheNames={"prd"}, key="'AppdictPlusService:' + #appdictBO.appdictId")
    public Integer updateLineDictData(@NotNull AppdictBO appdictBO) throws Exception {
        Appdict oldAppdict = (Appdict)this.getById(appdictBO.getAppdictId());
        if (oldAppdict == null) {
            return 0;
        }
        if (StringUtil.isNullorEmptyStr((String)appdictBO.getCode())) {
            if (StringUtil.isNullorEmptyStr((String)oldAppdict.getCode())) {
                appdictBO.setCode(appdictBO.getName());
            } else {
                appdictBO.setCode(oldAppdict.getCode());
            }
        }
        Appdict appdict = (Appdict)ConvertUtil.convert((Object)appdictBO, Appdict.class);
        appdict.setParentId(0L);
        appdict.setDomainId(oldAppdict.getDomainId());
        return this.updateSelective(appdict);
    }

    @Override
    public void insertTreeDictData(@NotNull Long userId, @NotNull Long domainId, @NotNull AppdictTreeDateInsertBO appdictTreeDateInsertBO) throws Exception {
        String appdictNames = appdictTreeDateInsertBO.getNames();
        List appdictNameList = StringUtil.splitToTrimList((String)appdictNames, (String)"\\n");
        int dateCount = appdictNameList.size();
        Long parentId = appdictTreeDateInsertBO.getParentId();
        Appdict parentAppdict = null;
        if (parentId > 0L) {
            parentAppdict = (Appdict)this.getById(parentId);
        }
        Integer ordernum = this.getNextOrderNum(appdictTreeDateInsertBO.getCategoryId(), parentId);
        ArrayList<Appdict> appdictList = new ArrayList<Appdict>();
        for (int i = 0; i < dateCount; ++i) {
            String appdictCodeName = (String)appdictNameList.get(i);
            if (StringUtil.isNullorEmptyStr((String)appdictCodeName)) continue;
            String appdictCode = "";
            String appdictName = "";
            appdictCodeName.replace("\uff0c", ",");
            List appdictCodeNameList = StringUtil.splitToTrimList((String)appdictCodeName, (String)",");
            if (appdictCodeNameList.size() > 1) {
                appdictCode = (String)appdictCodeNameList.get(0);
                appdictName = (String)appdictCodeNameList.get(1);
            } else {
                appdictName = (String)appdictCodeNameList.get(0);
            }
            Appdict appdict = (Appdict)ConvertUtil.convert((Object)appdictTreeDateInsertBO, Appdict.class);
            Long appdictId = IdUtil.getSequence((String)"COMMON_APPDICT");
            appdict.setAppdictId(appdictId);
            appdict.setCode(appdictCode);
            appdict.setName(appdictName);
            appdict.setOrdernum(ordernum + i);
            appdict.setIsvalId(1);
            appdict.setCreatedate(new Date());
            appdict.setCreatorId(userId);
            if (domainId != null) {
                appdict.setDomainId(domainId);
            }
            if (parentAppdict == null) {
                appdict.setFullpath("," + appdict.getCategoryId() + ",," + appdict.getAppdictId() + ",");
            } else {
                appdict.setFullpath(parentAppdict.getFullpath() + "," + appdict.getAppdictId() + ",");
            }
            appdictList.add(appdict);
        }
        this.insertBatch(appdictList);
    }

    @Override
    @CacheEvict(cacheNames={"prd"}, key="'AppdictPlusService:' + #appdictBO.appdictId")
    public Integer updateTreeDictData(@NotNull AppdictBO appdictBO) throws Exception {
        Appdict oldAppdict = (Appdict)this.getById(appdictBO.getAppdictId());
        if (oldAppdict == null) {
            return 0;
        }
        if (StringUtil.isNullorEmptyStr((String)appdictBO.getCode())) {
            if (StringUtil.isNullorEmptyStr((String)oldAppdict.getCode())) {
                appdictBO.setCode(appdictBO.getName());
            } else {
                appdictBO.setCode(oldAppdict.getCode());
            }
        }
        if (appdictBO.getParentId() == null) {
            appdictBO.setParentId(oldAppdict.getParentId());
        }
        if (oldAppdict.getParentId().longValue() == appdictBO.getParentId().longValue()) {
            Appdict appdict = (Appdict)ConvertUtil.convert((Object)appdictBO, Appdict.class);
            appdict.setDomainId(oldAppdict.getDomainId());
            return this.updateSelective(appdict);
        }
        Integer ordernum = this.getNextOrderNum(appdictBO.getCategoryId(), appdictBO.getParentId());
        Appdict appdict = (Appdict)ConvertUtil.convert((Object)appdictBO, Appdict.class);
        appdict.setOrdernum(ordernum);
        Appdict newParent = (Appdict)this.getById(appdictBO.getParentId());
        if (newParent != null) {
            appdict.setFullpath(newParent.getFullpath() + "," + appdict.getAppdictId() + ",");
        }
        appdict.setDomainId(oldAppdict.getDomainId());
        this.updateSelective(appdict);
        return 0;
    }

    @Override
    public void updateOrderNum(@NotNull AppdictUpdateOrderNumBO appdictTreeDateUpdateOrderNumBO) throws Exception {
        List<AppdictOrderNumBO> appdictOrderNumBOList = appdictTreeDateUpdateOrderNumBO.getAppdictOrderNumBOList();
        for (AppdictOrderNumBO appdictOrderNumBO : appdictOrderNumBOList) {
            Appdict appdict = (Appdict)ConvertUtil.convert((Object)appdictOrderNumBO, Appdict.class);
            this.updateSelective(appdict);
        }
    }

    @Override
    @CacheEvict(cacheNames={"prd"}, key="'AppdictPlusService:' + #appdictId")
    public Integer delete(@NotNull Long appdictId) throws Exception {
        return this.deleteById(appdictId);
    }

    @Override
    @Cacheable
    public Appdict findByCode(String code) throws Exception {
        AppdictQuery query = new AppdictQuery();
        query.setQuerycode(code);
        return (Appdict)this.appdictPlusDao.findOne(query);
    }

    @Override
    public Appdict getByCode(String code) throws Exception {
        AppdictQuery query = new AppdictQuery();
        query.setQuerycode(code);
        return (Appdict)this.appdictPlusDao.findOne(query);
    }

    @Override
    public Integer getMaxOrderNum(@NotNull Long categoryId, @NotNull Long parentId) {
        Integer ordernum = 0;
        AppdictQuery query = new AppdictQuery();
        query.setCategoryId(categoryId);
        query.setParentId(parentId);
        query.getPage().setSortColumns("ADT.ORDERNUM DESC");
        Appdict maxOrderAppdict = (Appdict)this.appdictPlusDao.findOne(query);
        if (maxOrderAppdict != null) {
            ordernum = maxOrderAppdict.getOrdernum() == null ? 0 : maxOrderAppdict.getOrdernum();
        }
        return ordernum;
    }

    private Integer getNextOrderNum(Long categoryId, Long parentId) {
        return this.getMaxOrderNum(categoryId, parentId) + 1;
    }

    @Override
    @Cacheable
    public List<AppdictVO> findVOLineListByCategoryId(Long categoryId, Long domainId) {
        AppdictQuery query = new AppdictQuery();
        query.setCategoryId(categoryId);
        query.setDomainId(domainId);
        query.getPage().setSortColumns("ADT.ORDERNUM, ADT.CREATEDATE");
        query.setIsvalId(1);
        List appdictList = this.getAppdictPlusDao().findAll(query);
        if (ListUtil.isNullorEmpty((List)appdictList) && domainId.longValue() != SysInitData.ORG_ROOT.getValue()) {
            Long parentId = DomainUtil.findDirectParentId(domainId);
            return this.self.findVOLineListByCategoryId(categoryId, parentId);
        }
        return ConvertUtil.convert((List)appdictList, AppdictVO.class);
    }

    @Override
    @Cacheable
    public AppdictVO getVOByCategoryIdName(Long categoryId, Long domainId, String name) {
        AppdictQuery query = new AppdictQuery();
        query.setCategoryId(categoryId);
        query.setDomainId(domainId);
        query.setName(name);
        query.setIsvalId(1);
        List appdictList = this.getAppdictPlusDao().findList(query, "getVOByCategoryIdName");
        if (!ListUtil.isNullorEmpty((List)appdictList)) {
            Appdict appdict = (Appdict)appdictList.get(0);
            return (AppdictVO)ConvertUtil.convert((Object)appdict, AppdictVO.class);
        }
        return null;
    }
}

