/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.common.appdict.util;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.ListUtil;
import com.peak.common.util.SpringUtil;
import com.peak.common.util.StringUtil;
import com.peak.prd.appsecurity.org.util.OrgUtil;
import com.peak.prd.common.appdict.model.Appdict;
import com.peak.prd.common.appdict.service.IAppdictPlusService;
import com.peak.prd.common.appdict.vo.AppdictMiniVO;
import com.peak.prd.common.appdict.vo.AppdictVO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class AppdictUtil {
    public static <VO> void setAppdictMiniVO(List<VO> vos, Function<VO, Long> getAppdictIdFunc, BiConsumer<VO, AppdictMiniVO> setAppdictMiniVOFunc) {
        if (ListUtil.isNullorEmpty(vos)) {
            return;
        }
        List appdictIds = IdUtil.getIds(vos, getAppdictIdFunc);
        if (ListUtil.isNullorEmpty((List)appdictIds)) {
            return;
        }
        appdictIds = ListUtil.removeDuplicate((List)appdictIds);
        IAppdictPlusService appdictPlusService = (IAppdictPlusService)SpringUtil.getBean(IAppdictPlusService.class);
        List appdictMiniVOList = appdictPlusService.findVOsByIds(appdictIds, AppdictMiniVO.class);
        Map appdictMiniVOMap = ConvertUtil.listToMap((List)appdictMiniVOList, AppdictMiniVO::getAppdictId);
        for (VO vo : vos) {
            AppdictMiniVO appdictMiniVO;
            if (vo == null || (appdictMiniVO = (AppdictMiniVO)appdictMiniVOMap.get(getAppdictIdFunc.apply(vo))) == null) continue;
            setAppdictMiniVOFunc.accept(vo, appdictMiniVO);
        }
    }

    public static AppdictMiniVO getAppdictMiniVO(Long appdictId) {
        if (appdictId == null) {
            return null;
        }
        IAppdictPlusService appdictPlusService = (IAppdictPlusService)SpringUtil.getBean(IAppdictPlusService.class);
        return (AppdictMiniVO)appdictPlusService.findVOById(appdictId, AppdictMiniVO.class);
    }

    public static List<AppdictVO> findVOLineListByCategoryId(Long categoryId, Long domainId) {
        if (categoryId == null) {
            return null;
        }
        if (domainId == null) {
            domainId = 9002L;
        }
        IAppdictPlusService appdictPlusService = (IAppdictPlusService)SpringUtil.getBean(IAppdictPlusService.class);
        return appdictPlusService.findVOLineListByCategoryId(categoryId, domainId);
    }

    public static Appdict getByCode(String code) {
        if (StringUtil.isNullorEmptyStr((String)code)) {
            return null;
        }
        IAppdictPlusService appdictPlusService = (IAppdictPlusService)SpringUtil.getBean(IAppdictPlusService.class);
        try {
            return appdictPlusService.findByCode(code);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static AppdictVO getVOByCategoryIdName(Long categoryId, Long domainId, String name) {
        if (categoryId == null || StringUtil.isNullorEmptyStr((String)name)) {
            return null;
        }
        if (domainId == null) {
            domainId = OrgUtil.getOrgRootId();
        }
        IAppdictPlusService appdictPlusService = (IAppdictPlusService)SpringUtil.getBean(IAppdictPlusService.class);
        return appdictPlusService.getVOByCategoryIdName(categoryId, domainId, name);
    }

    public static void main(String[] args) {
        ArrayList<Long> idList = new ArrayList<Long>();
        idList.add(1111L);
    }
}

