/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.common.rule;

import com.peak.common.util.DBFunction;
import com.peak.common.util.JsonUtil;
import com.peak.common.util.ListUtil;
import com.peak.common.util.StringUtil;
import com.peak.prd.common.rule.Matchrule;
import com.peak.prd.common.rule.UserFilterRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UserFilterRuleUtil {
    public static void main(String[] args) {
        UserFilterRuleUtil.transferRule("(1 AND (2 OR 3) AND 4) OR (5 AND 6) and 7 and 8 and 9");
    }

    public static String getSQL(String jsonRule) {
        if (StringUtil.isNullorEmptyStr((String)jsonRule)) {
            return jsonRule;
        }
        UserFilterRule userFilterRule = (UserFilterRule)JsonUtil.JsonToObject((String)jsonRule, UserFilterRule.class);
        List<Matchrule> matchruleList = userFilterRule.getMatchrulelist();
        String operationrule = userFilterRule.getOperationrule();
        operationrule = UserFilterRuleUtil.transferRule(operationrule);
        int row = 0;
        for (Matchrule matchrule : matchruleList) {
            String tmpStr;
            ++row;
            if (matchrule.getName().equals("userrank")) {
                tmpStr = UserFilterRuleUtil.getNumberSQL("tu.userrank", matchrule);
                operationrule = operationrule.replaceAll(row + "PeAkTEle", tmpStr);
                continue;
            }
            if (matchrule.getName().equals("position")) {
                tmpStr = UserFilterRuleUtil.getPositionSQL(matchrule);
                operationrule = operationrule.replaceAll(row + "PeAkTEle", tmpStr);
                continue;
            }
            if (matchrule.getName().equals("workdate")) {
                tmpStr = UserFilterRuleUtil.getDateSQL("ue.workdate", matchrule);
                operationrule = operationrule.replaceAll(row + "PeAkTEle", tmpStr);
                continue;
            }
            if (matchrule.getName().equals("identitys")) {
                tmpStr = UserFilterRuleUtil.getNumberSQL("ue.identitys", matchrule);
                operationrule = operationrule.replaceAll(row + "PeAkTEle", tmpStr);
                continue;
            }
            if (!matchrule.getName().equals("birth")) continue;
            tmpStr = UserFilterRuleUtil.getDateSQL("ue.birth", matchrule);
            operationrule = operationrule.replaceAll(row + "PeAkTEle", tmpStr);
        }
        return operationrule;
    }

    private static String transferRule(String operationrule) {
        Integer maxDigit = UserFilterRuleUtil.getMaxDigit(operationrule);
        for (int i = 1; i <= maxDigit; ++i) {
            operationrule = operationrule.replaceAll(i + "", i + "PeAkTEle");
        }
        return operationrule;
    }

    private static Integer getMaxDigit(String operationrule) {
        if (StringUtil.isNullorEmptyStr((String)operationrule)) {
            return 0;
        }
        Pattern pattern = Pattern.compile("\\d+");
        Matcher matcher = pattern.matcher(operationrule);
        ArrayList<Integer> dataList = new ArrayList<Integer>();
        while (matcher.find()) {
            dataList.add(Integer.valueOf(matcher.group()));
        }
        if (ListUtil.isNullorEmpty(dataList)) {
            return 0;
        }
        return (Integer)Collections.max(dataList);
    }

    public static String getNumberSQL(String condAndColumnname, Matchrule matchrule) {
        StringBuilder sbSQL = new StringBuilder();
        sbSQL.append(" ");
        sbSQL.append(condAndColumnname);
        sbSQL.append(" ");
        if (matchrule.getRelation().equals("equal")) {
            sbSQL.append(" = ");
            sbSQL.append(matchrule.getValue());
        } else if (matchrule.getRelation().equals("in")) {
            sbSQL.append(" in ( ");
            sbSQL.append(matchrule.getValue());
            sbSQL.append(" ) ");
        }
        return sbSQL.toString();
    }

    public static String getPositionSQL(Matchrule matchrule) {
        StringBuilder sbSQL = new StringBuilder();
        if (matchrule.getRelation().equals("equal")) {
            sbSQL.append(" exists (");
            sbSQL.append(" select 1 from tuser_position up ");
            sbSQL.append(" where up.user_id=tu.user_id and up.POSITION_ID = ");
            sbSQL.append(matchrule.getValue());
            sbSQL.append(" ) ");
        } else if (matchrule.getRelation().equals("in")) {
            sbSQL.append(" exists (");
            sbSQL.append(" select 1 from tuser_position up ");
            sbSQL.append(" where up.user_id=tu.user_id and up.POSITION_ID in ( ");
            sbSQL.append(matchrule.getValue());
            sbSQL.append(" )) ");
        }
        return sbSQL.toString();
    }

    public static String getDateSQL(String condAndColumnname, Matchrule matchrule) {
        StringBuilder sbSQL = new StringBuilder();
        sbSQL.append(" ");
        sbSQL.append(condAndColumnname);
        sbSQL.append(" ");
        if (matchrule.getRelation().equals("equal")) {
            if (DBFunction.isOracle() || DBFunction.isGauss()) {
                sbSQL.append(" = to_date('");
                sbSQL.append(matchrule.getValue());
                sbSQL.append("','yyyy-mm-dd') ");
            } else if (DBFunction.isMysql()) {
                sbSQL.append(" = date('");
                sbSQL.append(matchrule.getValue());
                sbSQL.append("') ");
            } else if (DBFunction.isSqlserver()) {
                sbSQL.append(" = convert(date,'");
                sbSQL.append(matchrule.getValue());
                sbSQL.append("') ");
            }
        } else if (matchrule.getRelation().equals("greater")) {
            if (DBFunction.isOracle() || DBFunction.isGauss()) {
                sbSQL.append(" > to_date('");
                sbSQL.append(matchrule.getValue());
                sbSQL.append("','yyyy-mm-dd') ");
            } else if (DBFunction.isMysql()) {
                sbSQL.append(" > date('");
                sbSQL.append(matchrule.getValue());
                sbSQL.append("') ");
            } else if (DBFunction.isSqlserver()) {
                sbSQL.append(" > convert(date,'");
                sbSQL.append(matchrule.getValue());
                sbSQL.append("') ");
            }
        } else if (matchrule.getRelation().equals("less")) {
            if (DBFunction.isOracle() || DBFunction.isGauss()) {
                sbSQL.append(" < to_date('");
                sbSQL.append(matchrule.getValue());
                sbSQL.append("','yyyy-mm-dd') ");
            } else if (DBFunction.isMysql()) {
                sbSQL.append(" < date('");
                sbSQL.append(matchrule.getValue());
                sbSQL.append("') ");
            } else if (DBFunction.isSqlserver()) {
                sbSQL.append(" < convert(date,'");
                sbSQL.append(matchrule.getValue());
                sbSQL.append("') ");
            }
        } else if (matchrule.getRelation().equals("range")) {
            String[] workdateArray = matchrule.getValue().split(",");
            if (DBFunction.isOracle() || DBFunction.isGauss()) {
                sbSQL.append(" >= to_date('");
                sbSQL.append(workdateArray[0]);
                sbSQL.append("','yyyy-mm-dd') ");
                sbSQL.append(" and ");
                sbSQL.append(condAndColumnname);
                sbSQL.append(" ");
                sbSQL.append(" <= to_date('");
                sbSQL.append(workdateArray[1]);
                sbSQL.append("','yyyy-mm-dd') ");
            } else if (DBFunction.isMysql()) {
                sbSQL.append(" >= date('");
                sbSQL.append(workdateArray[0]);
                sbSQL.append("') ");
                sbSQL.append(" and ");
                sbSQL.append(condAndColumnname);
                sbSQL.append(" ");
                sbSQL.append(" <= date('");
                sbSQL.append(workdateArray[1]);
                sbSQL.append("') ");
            } else if (DBFunction.isSqlserver()) {
                sbSQL.append(" >= convert(date,'");
                sbSQL.append(workdateArray[0]);
                sbSQL.append("') ");
                sbSQL.append(" and ");
                sbSQL.append(condAndColumnname);
                sbSQL.append(" ");
                sbSQL.append(" <= convert(date,'");
                sbSQL.append(workdateArray[1]);
                sbSQL.append("') ");
            }
        }
        return sbSQL.toString();
    }
}

