/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.config;

import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DataSourceExamConfig {
    @Value(value="${spring.datasource.exam.jdbc-url:}")
    String jdbcUrl;

    @Bean(name={"examDataSource"})
    @ConditionalOnProperty(prefix="spring.datasource.exam", name={"username"})
    @ConfigurationProperties(prefix="spring.datasource.exam")
    public DataSource examDataSource() {
        return DataSourceBuilder.create().build();
    }

    public boolean isSqlserver() {
        if (this.jdbcUrl == null) {
            return false;
        }
        return this.jdbcUrl.toLowerCase().indexOf("sqlserver") >= 0;
    }
}

