/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="spring.kafka")
@RefreshScope
public class KafkaConfig {
    @Value(value="${spring.kafka.bootstrap-servers:}")
    private String bootstrapServers;
    @Value(value="${spring.kafka.topic-replicaCount:1}")
    private String replicaCount;
    @Value(value="${spring.kafka.topic-partitionCount:1}")
    private String partitionCount;
    @Value(value="${spring.kafka.consumer.group-id:G1}")
    private String consumerGroupId;
    @Value(value="${spring.kafka.consumer.auto-offset-reset:earliest}")
    private String consumerAutoOffsetReset;
    @Value(value="${spring.kafka.consumer.key-deserializer:org.apache.kafka.common.serialization.StringDeserializer}")
    private String consumerKeyDeserializer;
    @Value(value="${spring.kafka.consumer.value-deserializer:org.apache.kafka.common.serialization.StringDeserializer}")
    private String consumerValueDeserializer;
    @Value(value="${spring.kafka.consumer.enable-auto-commit:false}")
    private String consumerEnableAutoCommit;
    @Value(value="${spring.kafka.producer.key-deserializer:org.apache.kafka.common.serialization.StringSerializer}")
    private String producerKeyDeserializer;
    @Value(value="${spring.kafka.producer.value-deserializer:org.apache.kafka.common.serialization.StringSerializer}")
    private String producerValueDeserializer;
    @Value(value="${spring.kafka.producer.acks:all}")
    private String producerAcks;
    @Value(value="${spring.kafka.producer.retries:0}")
    private String producerRetries;
    @Value(value="${spring.kafka.producer.buffer-memory:33554432}")
    private String producerBufferMemory;
    @Value(value="${spring.kafka.producer.batch-size:16384}")
    private String producerBatchSize;
    @Value(value="${spring.kafka.producer.linger-ms:1}")
    private String producerLingerMs;
    @Value(value="${spring.kafka.producer.properties.security.protocol:}")
    private String producerSecurityProtocol;
    @Value(value="${spring.kafka.producer.properties.sasl.mechanism:}")
    private String producerSaslMechanism;
    @Value(value="${spring.kafka.producer.properties.sasl.jaas.config:}")
    private String producerSaslJaasConfig;
    @Value(value="${spring.kafka.security.auth-login-config:}")
    private String securityAuthLoginConfig;
    @Value(value="${messageq.server:}")
    private String server;
    @Value(value="${messageq.custom.topic-suffix:}")
    private String customTopicSuffix;
    @Value(value="${messageq.custom.topic-prefix:}")
    private String customTopicPrefix;
    @Value(value="${messageq.custom.producer-util:com.peak.prd.messageq.util.kafka.KafkaProducerUtil}")
    private String customProducerUtil;
    @Value(value="${messageq.custom.producer-util-method:sendMessage}")
    private String customProducerUtilMethod;
    @Value(value="${messageq.custom.disable-topic:}")
    private String customDisableTopic;
    @Value(value="${messageq.custom.effective-topic:}")
    private String customEffectiveTopic;

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public String getReplicaCount() {
        return this.replicaCount;
    }

    public String getPartitionCount() {
        return this.partitionCount;
    }

    public String getConsumerGroupId() {
        return this.consumerGroupId;
    }

    public String getConsumerAutoOffsetReset() {
        return this.consumerAutoOffsetReset;
    }

    public String getConsumerKeyDeserializer() {
        return this.consumerKeyDeserializer;
    }

    public String getConsumerValueDeserializer() {
        return this.consumerValueDeserializer;
    }

    public String getConsumerEnableAutoCommit() {
        return this.consumerEnableAutoCommit;
    }

    public String getProducerKeyDeserializer() {
        return this.producerKeyDeserializer;
    }

    public String getProducerValueDeserializer() {
        return this.producerValueDeserializer;
    }

    public String getProducerAcks() {
        return this.producerAcks;
    }

    public String getProducerRetries() {
        return this.producerRetries;
    }

    public String getProducerBufferMemory() {
        return this.producerBufferMemory;
    }

    public String getProducerBatchSize() {
        return this.producerBatchSize;
    }

    public String getProducerLingerMs() {
        return this.producerLingerMs;
    }

    public String getProducerSecurityProtocol() {
        return this.producerSecurityProtocol;
    }

    public String getProducerSaslMechanism() {
        return this.producerSaslMechanism;
    }

    public String getSecurityAuthLoginConfig() {
        return this.securityAuthLoginConfig;
    }

    public String getProducerSaslJaasConfig() {
        return this.producerSaslJaasConfig;
    }

    public void setProducerSaslJaasConfig(String producerSaslJaasConfig) {
        this.producerSaslJaasConfig = producerSaslJaasConfig;
    }

    public String getServer() {
        return this.server;
    }

    public String getCustomTopicSuffix() {
        return this.customTopicSuffix;
    }

    public String getCustomTopicPrefix() {
        return this.customTopicPrefix;
    }

    public String getCustomProducerUtil() {
        return this.customProducerUtil;
    }

    public String getCustomProducerUtilMethod() {
        return this.customProducerUtilMethod;
    }

    public String getCustomDisableTopic() {
        return this.customDisableTopic;
    }

    public String getCustomEffectiveTopic() {
        return this.customEffectiveTopic;
    }
}

