/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.config;

import com.peak.prd.config.DataSourceExamConfig;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@Configuration
@ConfigurationProperties(prefix="mybatis")
public class MybatisExamConfig {
    private static final Logger log = LoggerFactory.getLogger(MybatisExamConfig.class);
    private String configLocation;
    private String[] mapperLocations;
    @Autowired
    DataSourceExamConfig dataSourceExamConfig;

    public String getConfigLocation() {
        return this.configLocation;
    }

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation.substring("classpath:".length());
    }

    public String[] getMapperLocations() {
        return this.mapperLocations;
    }

    public void setMapperLocations(String[] mapperLocations) {
        this.mapperLocations = mapperLocations;
    }

    @Bean(name={"examSqlSessionFactory"})
    @ConditionalOnBean(name={"examDataSource"})
    public SqlSessionFactory createSqlSessionFactoryBean1(@Qualifier(value="examDataSource") DataSource dataSource) throws Exception {
        SqlSessionFactoryBean sqlSessionFactoryBean = new SqlSessionFactoryBean();
        if (this.dataSourceExamConfig.isSqlserver()) {
            String str = "/config/ibatis/sqlserver/sqlMapConfig_base.xml";
            sqlSessionFactoryBean.setConfigLocation((Resource)new ClassPathResource(str));
            log.info("===examDataSource======sqlserver===");
        } else {
            sqlSessionFactoryBean.setConfigLocation((Resource)new ClassPathResource(this.configLocation));
        }
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        ArrayList<Resource[]> resourceList = new ArrayList<Resource[]>();
        int total = 0;
        for (int i = 0; this.mapperLocations != null && i < this.mapperLocations.length; ++i) {
            log.info("exam.mapperLocations[" + i + "]:" + this.mapperLocations[i]);
            Resource[] resourceArray = resolver.getResources(this.mapperLocations[i]);
            if (resourceArray == null || resourceArray.length == 0) continue;
            total += resourceArray.length;
            resourceList.add(resourceArray);
        }
        Resource[] totalArray = new Resource[total];
        int index = 0;
        for (int i = 0; i < resourceList.size(); ++i) {
            for (int j = 0; j < ((Resource[])resourceList.get(i)).length; ++j) {
                totalArray[index] = ((Resource[])resourceList.get(i))[j];
                ++index;
            }
        }
        sqlSessionFactoryBean.setMapperLocations(totalArray);
        sqlSessionFactoryBean.setDataSource(dataSource);
        SqlSessionFactory ret = sqlSessionFactoryBean.getObject();
        log.info("====MybatisExamConfig===" + ret);
        return ret;
    }
}

