/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.job;

import com.peak.common.util.AppPathUtil;
import com.peak.common.util.DateUtil;
import com.peak.common.util.StringUtil;
import com.peak.prd.base.job.BaseJobProcessor;
import com.peak.prd.base.job.JobHelper;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class DeleteTempFileJob
extends BaseJobProcessor {
    public void runJob(String jobParams) throws Exception {
        JobHelper.info((String)"========DeleteTempFileJob begin========", (Object[])new Object[0]);
        String tempPath = AppPathUtil.getTempLocalPath();
        if (StringUtil.isNullorEmptyStr((String)tempPath) || !tempPath.contains("temp")) {
            return;
        }
        File tempDir = new File(tempPath);
        if (!tempDir.exists() || tempDir.isFile()) {
            return;
        }
        for (File file : tempDir.listFiles()) {
            this.deleteDirTempFiles(file, DateUtil.add((Date)new Date(), (double)-2.0), new HashMap<File, Date>());
        }
        JobHelper.info((String)"========DeleteTempFileJob end========", (Object[])new Object[0]);
    }

    private void deleteDirTempFiles(File dir, Date compareDate, Map<File, Date> lastModifiedMap) {
        Date lastModifiedDate = lastModifiedMap.get(dir);
        if (lastModifiedDate == null) {
            lastModifiedMap.put(dir, new Date(dir.lastModified()));
        }
        if (dir.isFile()) {
            if (this.isDeleteFile(dir, compareDate, lastModifiedMap)) {
                dir.delete();
            }
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            this.deleteDirTempFiles(file, compareDate, lastModifiedMap);
        }
        File[] filesAfterDelete = dir.listFiles();
        if ((filesAfterDelete == null || filesAfterDelete.length == 0) && this.isDeleteFile(dir, compareDate, lastModifiedMap)) {
            dir.delete();
        }
    }

    private boolean isDeleteFile(File file, Date compareDate, Map<File, Date> lastModifiedMap) {
        Date lastModified = lastModifiedMap.get(file);
        if (lastModified == null) {
            return false;
        }
        return lastModified.compareTo(compareDate) < 0;
    }
}

