/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.listenner.base;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.peak.common.util.SpringUtil;
import com.peak.common.util.StringUtil;
import com.peak.prd.base.util.ExceptionUtil;
import com.peak.prd.common.appconfig.util.AppconfigUtil;
import com.peak.prd.common.appdict.model.Appdict;
import com.peak.prd.common.appdict.service.IAppdictPlusService;
import com.peak.prd.config.MessageQConfig;
import com.peak.prd.config.PrimaryKeyConfig;
import com.peak.prd.enums.AppconfigEnum;
import com.peak.prd.messageq.MessageQ;
import com.peak.prd.messageq.handler.MessageQBaseHandler;
import com.peak.prd.mq.faillog.service.IFaillogPlusService;
import com.peak.prd.mq.successlog.service.ISuccesslogPlusService;
import com.peak.prd.sys.mqhandler.model.SysMqhandler;
import com.peak.prd.sys.mqhandler.service.ISysMqhandlerPlusService;
import com.peak.prd.sys.syserrorlog.service.ISyserrorlogPlusService;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BaseListener {
    private static final Logger log = LoggerFactory.getLogger(BaseListener.class);
    @Autowired
    private static IFaillogPlusService faillogPlusService;
    @Autowired
    private static ISuccesslogPlusService successlogPlusService;
    @Autowired
    private static IAppdictPlusService appdictPlusService;
    @Autowired
    private static ISyserrorlogPlusService syserrorlogPlusService;
    @Autowired
    private static ISysMqhandlerPlusService sysMqhandlerPlusService;
    @Autowired
    private static PrimaryKeyConfig primaryKeyConfig;
    public static String topicSuffix;
    public static String topicPrefix;
    public static final int defaultMaxFailCount = 5;

    public void listen(String message, String hannlerPartName) {
        try {
            Long sleepTime = AppconfigUtil.getConsumerHandlerSleep();
            Thread.sleep(sleepTime);
        }
        catch (Exception sleepTime) {
            // empty catch block
        }
        Date beginDate = new Date();
        log.info("listen message getMessageQ > {}", (Object)(message + "  ==========  hannler: " + hannlerPartName));
        MessageQ messageQ = this.getMessageQ(message, beginDate);
        if (messageQ != null) {
            String groupId = hannlerPartName;
            if (StringUtil.isNullorEmptyStr((String)messageQ.getGroupId()) || groupId.equals(messageQ.getGroupId())) {
                String handLerName = "";
                int handlerEnable = 0;
                try {
                    String convertAction = StringUtil.upperFirstLetter((String)messageQ.getAction().toLowerCase());
                    if (StringUtil.isNullorEmptyStr((String)convertAction)) {
                        log.info("listen message action is null> {}", (Object)(message + "  ==========  hannler: " + hannlerPartName));
                        this.saveFaillog(messageQ, "\u6d88\u606f\u4f53\u4e2d\u6ca1\u6709action\u4fe1\u606f\u65e0\u6cd5\u786e\u5b9a\u4e1a\u52a1\u5904\u7406handler", handLerName, handlerEnable, beginDate, new Date(), groupId);
                    } else {
                        handLerName = messageQ.getTopic() + convertAction + StringUtil.upperFirstLetter((String)hannlerPartName) + "Handler";
                        if (this.handlerEnable(messageQ.getTopic(), messageQ.getAction(), handLerName)) {
                            handlerEnable = 1;
                            MessageQBaseHandler messageHandler = (MessageQBaseHandler)SpringUtil.getBean((String)handLerName);
                            messageHandler.handle(messageQ);
                            this.saveSuccesslog(messageQ, handLerName, handlerEnable, beginDate, new Date());
                        } else {
                            log.info("listen message hannler is Disable> {}", (Object)(message + "  ==========  hannler: " + handLerName));
                            this.saveFaillog(messageQ, "\u6d88\u606f\u5904\u7406Handler\u672a\u542f\u7528", handLerName, handlerEnable, beginDate, new Date(), groupId);
                        }
                    }
                }
                catch (Exception e) {
                    log.error("listen message error > {}", (Throwable)e);
                    String failMsg = this.trim(e.getMessage(), 2000);
                    if (StringUtil.isNullorEmptyStr((String)failMsg)) {
                        failMsg = this.getStackTraceString(e, 2000);
                    }
                    this.saveFaillog(messageQ, "\u6d88\u606f\u5904\u7406\u51fa\u9519:" + failMsg, handLerName, handlerEnable, beginDate, new Date(), groupId);
                    syserrorlogPlusService.insertExceptionLog(e, null);
                }
            }
        }
    }

    public void autoListen(String message, String hannlerClassName) {
        try {
            Long sleepTime = AppconfigUtil.getConsumerHandlerSleep();
            Thread.sleep(sleepTime);
        }
        catch (Exception sleepTime) {
            // empty catch block
        }
        Date beginDate = new Date();
        log.info("listen message getMessageQ > {}", (Object)(message + "  ==========  hannler: " + hannlerClassName));
        MessageQ messageQ = this.getMessageQ(message, beginDate);
        if (messageQ != null) {
            String groupId = hannlerClassName;
            if (StringUtil.isNullorEmptyStr((String)messageQ.getGroupId()) || groupId.toLowerCase().equals(messageQ.getGroupId().toLowerCase())) {
                String handLerName = hannlerClassName;
                int handlerEnable = 0;
                try {
                    if (this.handlerEnable(handLerName)) {
                        handlerEnable = 1;
                        MessageQBaseHandler messageHandler = (MessageQBaseHandler)SpringUtil.getBean((String)StringUtil.lowerFirstLetter((String)handLerName));
                        messageHandler.handle(messageQ);
                        this.saveSuccesslog(messageQ, handLerName, handlerEnable, beginDate, new Date());
                        if (groupId.toLowerCase().equals(messageQ.getGroupId().toLowerCase())) {
                            this.updateFaillogRetryStatus(messageQ.getGkey(), hannlerClassName, 2);
                        }
                    } else {
                        log.info("listen message hannler is Disable> {}", (Object)(message + "  ==========  hannler: " + handLerName));
                        this.saveFaillog(messageQ, "\u6d88\u606f\u5904\u7406Handler\u672a\u542f\u7528", handLerName, handlerEnable, beginDate, new Date(), groupId);
                        if (groupId.toLowerCase().equals(messageQ.getGroupId().toLowerCase())) {
                            this.updateFaillogRetryStatus(messageQ.getGkey(), hannlerClassName, 3);
                        }
                    }
                }
                catch (Exception e) {
                    log.error("listen message error > {}", (Throwable)e);
                    e.printStackTrace();
                    String failMsg = this.trim(ExceptionUtil.getStackTraceString((Exception)e), 2000);
                    this.saveFaillog(messageQ, "\u6d88\u606f\u5904\u7406\u51fa\u9519:" + failMsg, handLerName, handlerEnable, beginDate, new Date(), groupId);
                }
            }
        }
    }

    public MessageQ getMessageQ(String message, Date beginDate) {
        MessageQ messageQ;
        if (message.startsWith("{{")) {
            message = message.substring(1);
        }
        if (null == (messageQ = MessageQ.analysisBody(message, topicSuffix, topicPrefix))) {
            log.error("listen message getMessageQ error > {}", (Object)message);
            String gkey = "";
            String action = "";
            String topic = "";
            try {
                JSONObject jsonObject = JSON.parseObject((String)message);
                gkey = jsonObject.getString("gkey");
                action = jsonObject.getString("action");
                topic = jsonObject.getString("topic").replace("retry_", "").replace(topicSuffix, "").replace(topicPrefix, "");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.saveFaillog(gkey, topic, action, message, "message\u683c\u5f0f\u9519\u8bef\uff0c\u65e0\u6cd5\u89e3\u6790\u6210MessageQ\u5bf9\u8c61", "", null, beginDate, new Date());
        }
        return messageQ;
    }

    public void saveFaillog(MessageQ messageQ, String failMsg, String handlerName, Integer handlerEnable, Date beginDate, Date endDate, String groupId) {
        this.saveFaillog(messageQ.getGkey(), messageQ.getTopic() + "_" + messageQ.getAction(), messageQ.getAction(), messageQ.toJson(topicPrefix, topicSuffix), failMsg, handlerName, handlerEnable, beginDate, endDate, groupId, 1);
    }

    public void saveFaillog(String gkey, String topic, String action, String messageBody, String failMsg, String handlerName, Integer handlerEnable, Date beginDate, Date endDate) {
        this.saveFaillog(gkey, topic, action, messageBody, failMsg, handlerName, handlerEnable, beginDate, endDate, "", 0);
    }

    public void deleteFaillog(String gkey, String groupId) {
        try {
            faillogPlusService.deleteByGkeyGroup(gkey, groupId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void saveFaillog(String gkey, String topic, String action, String messageBody, String failMsg, String handlerName, Integer handlerEnable, Date beginDate, Date endDate, String groupId, Integer errorStep) {
        try {
            int maxFailCount = StringUtil.isNullorEmptyStr((String)AppconfigUtil.getValueByConfigkey(AppconfigEnum.KEY_MESSAGEHANDMAXFAILCOUNT.getValue())) ? 5 : Integer.valueOf(AppconfigUtil.getValueByConfigkey(AppconfigEnum.KEY_MESSAGEHANDMAXFAILCOUNT.getValue()));
            faillogPlusService.txInsert(gkey, topic, action, messageBody, failMsg, primaryKeyConfig.getApplication() + ":" + handlerName, handlerEnable, beginDate, endDate, groupId, errorStep, maxFailCount);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void updateFaillogRetryStatus(String gkey, String handlerName, Integer retryStatus) {
        faillogPlusService.updateRetryStatus(gkey, handlerName, retryStatus);
    }

    private void saveSuccesslog(MessageQ messageQ, String handlerName, Integer handlerEnable, Date beginDate, Date endDate) {
        try {
            if ("1".equals(AppconfigUtil.getIsMqSaveSendLog().toString())) {
                successlogPlusService.insert(messageQ.getGkey(), messageQ.getTopic() + "_" + messageQ.getAction(), messageQ.getAction(), messageQ.toJson(topicPrefix, topicSuffix), primaryKeyConfig.getApplication() + ":" + handlerName, handlerEnable, beginDate, endDate);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private boolean handlerEnable(String topic, String action, String handLerName) {
        boolean ret = true;
        Appdict appdict = null;
        try {
            appdict = appdictPlusService.findByCode(handLerName.toLowerCase());
            if (appdict != null && appdict.getIsvalId() == 0) {
                ret = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    private boolean handlerEnable(String handLerClassName) {
        boolean ret = true;
        SysMqhandler sysMqhandler = null;
        try {
            sysMqhandler = sysMqhandlerPlusService.findByClassname(handLerClassName);
            if (sysMqhandler != null && sysMqhandler.getStatus() == 0) {
                ret = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    private String trim(String str, int maxLength) {
        int utf8_max_length = maxLength / 3;
        if (str == null || str.length() <= utf8_max_length) {
            return str;
        }
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        if (bytes.length <= maxLength) {
            return str;
        }
        return new String(bytes, 0, utf8_max_length * 3, StandardCharsets.UTF_8);
    }

    /*
     * Exception decompiling
     */
    private String getStackTraceString(Exception ex, int maxLength) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        topicSuffix = "";
        topicPrefix = "";
        MessageQConfig messageQConfig = (MessageQConfig)SpringUtil.getBean((String)"messageQConfig");
        faillogPlusService = (IFaillogPlusService)SpringUtil.getBean((String)"faillogPlusService");
        appdictPlusService = (IAppdictPlusService)SpringUtil.getBean((String)"appdictPlusService");
        successlogPlusService = (ISuccesslogPlusService)SpringUtil.getBean((String)"successlogPlusService");
        syserrorlogPlusService = (ISyserrorlogPlusService)SpringUtil.getBean((String)"syserrorlogPlusService");
        sysMqhandlerPlusService = (ISysMqhandlerPlusService)SpringUtil.getBean((String)"sysMqhandlerPlusService");
        primaryKeyConfig = (PrimaryKeyConfig)SpringUtil.getBean((String)"primaryKeyConfig");
        topicSuffix = messageQConfig.getCustomTopicSuffix();
        topicPrefix = messageQConfig.getCustomTopicPrefix();
    }
}

