/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.listenner.kafka.base;

import com.peak.common.util.SpringUtil;
import com.peak.common.util.StringUtil;
import com.peak.prd.config.PrimaryKeyConfig;
import com.peak.prd.listenner.base.BaseListener;
import com.peak.prd.messageq.MessageQ;
import com.peak.prd.sys.mqdefine.model.SysMqdefine;
import com.peak.prd.sys.mqdefine.service.ISysMqdefinePlusService;
import com.peak.prd.sys.mqhandler.service.ISysMqhandlerPlusService;
import com.peak.prd.sys.mqhandler.vo.SysMqhandlerVO;
import com.peak.prd.sys.syserrorlog.service.ISyserrorlogPlusService;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.kafka.clients.consumer.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BaseKafkaListener
extends BaseListener {
    private static final Logger log = LoggerFactory.getLogger(BaseKafkaListener.class);
    @Resource
    PrimaryKeyConfig primaryKeyConfig;

    public void listen(String message, Consumer<String, Object> consumer) {
        super.listen(message, "");
        consumer.commitAsync();
        log.debug("listen message commitAsync");
    }

    public void listen(String message, Consumer<String, Object> consumer, String hannlerPartName) {
        consumer.commitAsync();
        super.listen(message, hannlerPartName);
        log.debug("listen message commitAsync");
    }

    public void autoListen(String message, Consumer<String, Object> consumer, String groupId) {
        consumer.commitAsync();
        MessageQ messageQ = this.getMessageQ(message, new Date());
        if (messageQ != null) {
            Integer groupNum = null;
            String hannlerPartName = null;
            try {
                String appName = this.primaryKeyConfig.getApplication();
                String groupNumStr = groupId.replaceAll(appName, "");
                groupNum = Integer.parseInt(groupNumStr);
            }
            catch (Exception e) {
                ISyserrorlogPlusService syserrorlogPlusService = (ISyserrorlogPlusService)SpringUtil.getBean(ISyserrorlogPlusService.class);
                syserrorlogPlusService.insertExceptionLog(e, null);
            }
            if (groupNum != null) {
                SysMqhandlerVO sysMqhandlerVO = null;
                String topic = "";
                String action = "";
                try {
                    topic = messageQ.getTopic();
                    action = messageQ.getAction();
                    ISysMqdefinePlusService sysMqdefinePlusService = (ISysMqdefinePlusService)SpringUtil.getBean(ISysMqdefinePlusService.class);
                    SysMqdefine sysMqdefineTopic = sysMqdefinePlusService.findByMqvalue(0L, 1, topic);
                    if (sysMqdefineTopic == null || sysMqdefineTopic.getStatus() == 0) {
                        this.saveFaillog(messageQ.getGkey(), topic, action, message, "\u672a\u627e\u5230topic\u6ce8\u518c\u4fe1\u606f\u6216\u8005topic\u672a\u542f\u7528", "", null, new Date(), new Date());
                        return;
                    }
                    SysMqdefine sysMqdefineAction = sysMqdefinePlusService.findByMqvalue(sysMqdefineTopic.getMqdefineId(), 2, action);
                    if (sysMqdefineAction == null || sysMqdefineAction.getStatus() == 0) {
                        this.saveFaillog(messageQ.getGkey(), topic, action, message, "\u672a\u627e\u5230action\u6ce8\u518c\u4fe1\u606f\u6216\u8005action\u672a\u542f\u7528", "", null, new Date(), new Date());
                        return;
                    }
                    ISysMqhandlerPlusService sysMqhandlerPlusService = (ISysMqhandlerPlusService)SpringUtil.getBean(ISysMqhandlerPlusService.class);
                    sysMqhandlerVO = sysMqhandlerPlusService.getHandler(sysMqdefineAction.getMqdefineId(), groupNum);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (sysMqhandlerVO != null) {
                    hannlerPartName = sysMqhandlerVO.getClassname();
                    if (!StringUtil.isNullorEmptyStr((String)hannlerPartName)) {
                        if (sysMqhandlerVO.getStatus() == 1) {
                            super.autoListen(message, hannlerPartName);
                        } else {
                            log.info("listen message hannler is Disable> {}", (Object)(message + "  ==========  hannler: " + hannlerPartName));
                            this.saveFaillog(messageQ, "\u6d88\u606f\u5904\u7406Handler\u672a\u542f\u7528", hannlerPartName, 0, new Date(), new Date(), groupId);
                        }
                    } else {
                        log.error("MQ\u5904\u7406\u5668\u6ce8\u518c\u4fe1\u606fClassname\u4e3a\u7a7a\uff1agroupId={},topic={},action={}", new Object[]{groupId, topic, action});
                        this.saveFaillog(messageQ.getGkey(), topic, action, message, "handler\u6ce8\u518c\u4fe1\u606fClassname\u4e3a\u7a7a", "", null, new Date(), new Date());
                    }
                } else {
                    this.saveFaillog(messageQ.getGkey(), topic, action, message, "\u672a\u627e\u5230handler\u6ce8\u518c\u4fe1\u606f", "", null, new Date(), new Date());
                    log.error("\u672a\u627e\u5230MQ\u5904\u7406\u5668handler\u6ce8\u518c\u4fe1\u606f\uff1agroupId={},topic={},action={}", new Object[]{groupId, topic, action});
                }
            }
        }
        log.debug("listen message commitAsync");
    }
}

