/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.listenner.kafka.base;

import com.peak.common.util.ListUtil;
import com.peak.common.util.SpringUtil;
import com.peak.common.util.StringUtil;
import com.peak.prd.common.appdict.vo.AppdictVO;
import com.peak.prd.config.PrimaryKeyConfig;
import com.peak.prd.listenner.base.BaseListener;
import com.peak.prd.listenner.temp.kafka.KafkaChildConfig;
import com.peak.prd.sys.mqdefine.service.ISysMqdefinePlusService;
import com.peak.prd.sys.mqdefine.vo.SysMqdefineVO;
import com.peak.prd.sys.mqhandler.service.ISysMqhandlerPlusService;
import com.peak.prd.sys.mqhandler.vo.SysMqhandlerVO;
import java.util.List;
import java.util.Properties;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.stereotype.Component;

@Component
public class KafkaAutoListener
extends BaseListener {
    private static final Logger log = LoggerFactory.getLogger(KafkaAutoListener.class);
    @Resource
    private ApplicationContext context;
    @Resource
    PrimaryKeyConfig primaryKeyConfig;
    private boolean shouldExit = false;

    @Bean
    public void init() throws Exception {
        String appName = this.primaryKeyConfig.getApplication();
        ISysMqdefinePlusService sysMqdefinePlusService = (ISysMqdefinePlusService)SpringUtil.getBean(ISysMqdefinePlusService.class);
        ISysMqhandlerPlusService sysMqhandlerPlusService = (ISysMqhandlerPlusService)SpringUtil.getBean(ISysMqhandlerPlusService.class);
        List<SysMqdefineVO> topicMqdefineVOList = sysMqdefinePlusService.getPublicSysMqdefineVOList();
        if (!ListUtil.isNullorEmpty(topicMqdefineVOList)) {
            this.shouldExit = true;
            for (SysMqdefineVO topicMqdefineVO : topicMqdefineVOList) {
                List<SysMqdefineVO> actionMqdefineVOList = topicMqdefineVO.getChildren();
                if (ListUtil.isNullorEmpty(actionMqdefineVOList)) continue;
                for (SysMqdefineVO actionMqdefineVO : actionMqdefineVOList) {
                    List<SysMqhandlerVO> sysMqhandlerVOList = sysMqhandlerPlusService.getPublicHandlerList(actionMqdefineVO.getMqdefineId());
                    if (ListUtil.isNullorEmpty(sysMqhandlerVOList)) continue;
                    for (int i = 0; i < sysMqhandlerVOList.size(); ++i) {
                        String handlerName;
                        SysMqhandlerVO sysMqhandlerVO = sysMqhandlerVOList.get(i);
                        AppdictVO svrappdict = sysMqhandlerVO.getSvrappdict();
                        if (svrappdict == null || !svrappdict.getName().toLowerCase().equals(appName.toLowerCase()) || StringUtil.isNullorEmptyStr((String)(handlerName = sysMqhandlerVO.getClassname()))) continue;
                        this.addListener(topicMqdefineVO.getMqvalue(), appName + sysMqhandlerVO.getGroupnum().toString(), actionMqdefineVO.getMqvalue(), handlerName);
                    }
                }
            }
            this.shouldExit = false;
        }
        if (this.shouldExit) {
            System.exit(0);
        }
    }

    public void addListener(String topicNoPrefix, String groupId, String action, String handler) {
        log.info("kafka auto addListener =============> topicNoPrefix:{},action:{},groupId:{},handler:{}", new Object[]{topicNoPrefix, action, groupId, handler});
        try {
            AnnotationConfigApplicationContext child = new AnnotationConfigApplicationContext();
            child.setParent(this.context);
            Properties props = new Properties();
            props.setProperty("topic", topicPrefix + topicNoPrefix + "_" + action + topicSuffix);
            props.setProperty("groupId", groupId);
            props.setProperty("handler", handler);
            PropertiesPropertySource pps = new PropertiesPropertySource("listenerProps", props);
            child.getEnvironment().getPropertySources().addLast((PropertySource)pps);
            child.register(new Class[]{KafkaChildConfig.class});
            child.refresh();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }
}

